/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.util.HashMap;
import java.util.Map;
import kalang.compiler.antlr.KalangParser;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.compile.AstBuilderBase;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisReporter;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class ClassNodeInitializer
extends AstBuilderBase {
    private final String className;
    private ClassNode topClass;
    private ClassNode thisClazz;
    private Map<ClassNode, ParserRuleContext> defContext = new HashMap<ClassNode, ParserRuleContext>();
    private boolean inScriptMode = false;
    private boolean isScript = false;
    private final CompilationUnit compilationUnit;
    private final DiagnosisReporter diagnosisReporter;

    public ClassNodeInitializer(CompilationUnit compilationUnit) {
        super(compilationUnit);
        this.className = compilationUnit.getSource().getClassName();
        this.compilationUnit = compilationUnit;
        this.diagnosisReporter = new DiagnosisReporter(compilationUnit);
    }

    @Override
    ClassNode getCurrentClass() {
        return this.thisClazz;
    }

    @Override
    ClassNode getTopClass() {
        return this.topClass;
    }

    public ClassNode build(KalangParser.CompilationUnitContext ctx) {
        this.visitCompilationUnit(ctx);
        return this.topClass;
    }

    @Override
    public Object visitScriptDef(KalangParser.ScriptDefContext ctx) {
        this.isScript = true;
        this.inScriptMode = true;
        int modifier = 1;
        this.topClass = this.thisClazz = new ClassNode(this.className, modifier);
        this.defContext.put(this.topClass, ctx);
        super.visitScriptDef(ctx);
        return null;
    }

    @Override
    public Object visitClassDef(KalangParser.ClassDefContext ctx) {
        String classDefName;
        ClassNode oldClass = this.thisClazz;
        Token nameIdentifier = ctx.name;
        int modifier = this.parseModifier(ctx.varModifier());
        if (this.inScriptMode) {
            modifier |= 8;
        }
        Token classKind = ctx.classKind;
        boolean isInterface = false;
        if (classKind != null && classKind.getText().equals("interface")) {
            modifier |= 0x600;
            isInterface = true;
        }
        if (oldClass != null) {
            if (nameIdentifier == null) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "Identifier excepted", ctx);
                return null;
            }
            classDefName = oldClass.name + "$" + nameIdentifier.getText();
        } else {
            classDefName = this.className;
        }
        ClassNode theClass = this.thisClazz = new ClassNode(classDefName, modifier);
        this.defContext.put(theClass, ctx);
        if (oldClass == null) {
            this.topClass = theClass;
        } else {
            oldClass.classes.add(this.thisClazz);
            this.thisClazz.enclosingClass = oldClass;
        }
        boolean oldScriptMode = this.inScriptMode;
        this.inScriptMode = false;
        this.visit((ParseTree)ctx.classBody());
        this.inScriptMode = oldScriptMode;
        this.mapAst((AstNode)this.thisClazz, ctx);
        this.thisClazz = oldClass;
        return null;
    }

    public ClassNode getClassNode() {
        return this.topClass;
    }

    public ParserRuleContext getClassNodeDefContext(ClassNode classNode) {
        return this.defContext.get(classNode);
    }

    public boolean isScript() {
        return this.isScript;
    }
}

