/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import kalang.compiler.AstNotFoundException;
import kalang.compiler.antlr.KalangParser;
import kalang.compiler.ast.AnnotationNode;
import kalang.compiler.ast.AssignExpr;
import kalang.compiler.ast.AssignableExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.BlockStmt;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.ConstExpr;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.ExprStmt;
import kalang.compiler.ast.FieldNode;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.ObjectFieldExpr;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.StaticFieldExpr;
import kalang.compiler.ast.ThisExpr;
import kalang.compiler.compile.AstBuilder;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.CompileContext;
import kalang.compiler.compile.Configuration;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisReporter;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.exception.Exceptions;
import kalang.compiler.util.AstUtil;
import kalang.compiler.util.ClassTypeUtil;
import kalang.compiler.util.MethodUtil;
import kalang.compiler.util.ModifierUtil;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class ClassNodeStructureBuilder
extends AstBuilder {
    private ClassNode thisClazz;
    private ClassNode topClass;
    private Map<MethodNode, KalangParser.StatContext[]> methodStatsContexts = new HashMap<MethodNode, KalangParser.StatContext[]>();
    private MethodNode method;
    private final CompilationUnit compilationUnit;
    private DiagnosisReporter diagnosisReporter;

    public ClassNodeStructureBuilder(CompilationUnit compilationUnit, KalangParser parser) {
        super(compilationUnit, parser);
        this.compilationUnit = compilationUnit;
        this.diagnosisReporter = new DiagnosisReporter(this.compilationUnit);
    }

    public void build(ClassNode topClass, ClassNode cn, ParserRuleContext ctx) {
        this.thisClazz = cn;
        this.topClass = topClass;
        this.thisClazz = cn;
        this.visit((ParseTree)ctx);
    }

    @Override
    public Object visitClassDef(KalangParser.ClassDefContext ctx) {
        Object parentClass;
        this.thisClazz.annotations.addAll(this.getAnnotations(ctx.annotation()));
        List<Token> gnrTypes = ctx.genericTypes;
        if (gnrTypes != null && !gnrTypes.isEmpty()) {
            for (Token g : gnrTypes) {
                GenericType gt = new GenericType(g.getText(), Types.getRootType(), null, NullableKind.NONNULL);
                this.thisClazz.declareGenericType(gt);
            }
        }
        ObjectType superType = null;
        if (ctx.parentClass != null && (parentClass = this.parseClassType(ctx.parentClass)) != null) {
            superType = parentClass;
        }
        if (Modifier.isInterface(this.thisClazz.modifier)) {
            if (superType != null) {
                this.thisClazz.addInterface(superType);
            }
        } else {
            this.thisClazz.setSuperType(superType == null ? Types.getRootType() : superType);
        }
        if (ctx.interfaces != null && ctx.interfaces.size() > 0) {
            for (KalangParser.ClassTypeContext itf : ctx.interfaces) {
                ObjectType itfClz = this.parseClassType(itf);
                if (itfClz == null) continue;
                this.thisClazz.addInterface(itfClz);
            }
        }
        if (this.isDeclaringNonStaticInnerClass()) {
            parentClass = this.thisClazz.enclosingClass;
            if (parentClass == null) {
                throw Exceptions.unexceptedValue(parentClass);
            }
            this.thisClazz.createField(Types.getClassType(parentClass), "this$0", 4098);
        }
        this.visitClassBody(ctx.classBody());
        if (!(ModifierUtil.isInterface(this.thisClazz.modifier) || AstUtil.containsConstructor(this.thisClazz) || AstUtil.createEmptyConstructor(this.thisClazz))) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "failed to create constructor with no parameters", ctx);
        }
        MethodNode[] methods = this.thisClazz.getDeclaredMethodNodes();
        for (int i = 0; i < methods.length; ++i) {
            MethodNode node = methods[i];
            BlockStmt body = node.getBody();
            if (body == null || !AstUtil.isConstructor(node) || !this.isDeclaringNonStaticInnerClass()) continue;
            ClassNode enclosingClass = this.thisClazz.enclosingClass;
            if (enclosingClass == null) {
                throw Exceptions.unexceptedValue(enclosingClass);
            }
            ParameterNode outerInstanceParam = node.createParameter(0, Types.getClassType(enclosingClass), "this$0");
            ExprNode parentFieldExpr = this.getObjectFieldExpr(new ThisExpr(Types.getClassType(this.thisClazz)), "this$0", ParserRuleContext.EMPTY);
            if (parentFieldExpr == null) {
                throw Exceptions.unexceptedValue(parentFieldExpr);
            }
            body.statements.add(1, new ExprStmt(new AssignExpr((AssignableExpr)parentFieldExpr, new ParameterExpr(outerInstanceParam))));
        }
        for (FieldNode fieldNode : this.thisClazz.getFields()) {
            int mdf = fieldNode.modifier;
            if (Modifier.isStatic(mdf) || !Modifier.isPublic(mdf) && !Modifier.isProtected(mdf)) continue;
            if (!AstUtil.hasGetter(this.thisClazz, fieldNode)) {
                AstUtil.createGetter(this.thisClazz, fieldNode, mdf);
            }
            if (!AstUtil.hasSetter(this.thisClazz, fieldNode)) {
                AstUtil.createSetter(this.thisClazz, fieldNode, mdf);
            }
            fieldNode.modifier = ModifierUtil.setPrivate(mdf);
        }
        return null;
    }

    private boolean isNonStaticInnerClass(ClassNode clazz) {
        return clazz.enclosingClass != null && !Modifier.isStatic(clazz.modifier) && !Modifier.isInterface(clazz.modifier);
    }

    private boolean isDeclaringNonStaticInnerClass() {
        return this.isNonStaticInnerClass(this.thisClazz);
    }

    @Override
    public AstNode visitMethodDecl(KalangParser.MethodDeclContext ctx) {
        Object stats;
        KalangParser.BlockStmtContext bstm;
        MethodDescriptor overriddenMd;
        String[] paramNames;
        Type[] paramTypes;
        String name;
        Type type;
        boolean isOverriding;
        boolean bl = isOverriding = ctx.OVERRIDE() != null;
        if (ctx.prefix != null && ctx.prefix.getText().equals("constructor")) {
            type = Types.VOID_TYPE;
            name = "<init>";
        } else {
            type = ctx.type() == null ? Types.VOID_TYPE : this.parseType(ctx.returnType);
            name = ctx.name.getText();
        }
        List<KalangParser.TypeContext> paramTypesCtx = ctx.paramTypes;
        int modifier = this.parseModifier(ctx.varModifier());
        if (paramTypesCtx != null) {
            int paramSize = paramTypesCtx.size();
            paramTypes = new Type[paramSize];
            paramNames = new String[paramSize];
            for (int i = 0; i < paramSize; ++i) {
                KalangParser.TypeContext t = paramTypesCtx.get(i);
                paramTypes[i] = this.parseType(t);
                paramNames[i] = ctx.paramIds.get(i).getText();
            }
        } else {
            paramTypes = new Type[]{};
            paramNames = new String[]{};
        }
        String mStr = MethodUtil.getDeclarationKey(name, paramTypes);
        boolean existed = Arrays.asList(this.thisClazz.getDeclaredMethodNodes()).stream().anyMatch(m -> MethodUtil.getDeclarationKey(m).equals(mStr));
        if (existed) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "declare method duplicately:" + mStr, ctx);
            return null;
        }
        KalangParser.BlockStmtContext blockStmt = ctx.blockStmt();
        if (blockStmt == null) {
            if (ModifierUtil.isInterface(this.thisClazz.modifier)) {
                modifier |= 0x400;
            } else if (!Modifier.isAbstract(modifier)) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method body required", ctx);
            } else if (!Modifier.isAbstract(this.thisClazz.modifier)) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "declare abstract method in non-abstract class", ctx);
            }
        }
        this.method = this.thisClazz.createMethodNode(type, name, modifier);
        for (int i = 0; i < paramTypes.length; ++i) {
            this.method.createParameter(paramTypes[i], paramNames[i]);
        }
        for (AnnotationNode a : this.getAnnotations(ctx.annotation())) {
            this.method.addAnnotation(a);
        }
        ObjectType superType = this.thisClazz.getSuperType();
        if (superType == null) {
            superType = Types.getRootType();
        }
        if ((overriddenMd = ClassTypeUtil.getMethodDescriptor(superType, mStr, this.thisClazz, true, true)) == null) {
            overriddenMd = ClassTypeUtil.getMethodDescriptor(this.thisClazz.getInterfaces(), mStr, this.thisClazz, true, true);
        }
        if (isOverriding && overriddenMd == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method does not override or implement a method from a supertype", ctx);
        }
        if (!isOverriding && overriddenMd != null && !"<init>".equals(overriddenMd.getName())) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "method overrides or implements a method from a supertype", ctx);
        }
        if ((bstm = ctx.blockStmt()) != null && (stats = bstm.stat()) != null) {
            this.methodStatsContexts.put(this.method, stats.toArray(new KalangParser.StatContext[stats.size()]));
        }
        if (ctx.exceptionTypes != null) {
            for (Token et : ctx.exceptionTypes) {
                ObjectType exType = this.requireClassType(et);
                if (exType == null) continue;
                this.method.addExceptionType(exType);
            }
        }
        this.mapAst((AstNode)this.method, ctx);
        MethodNode m2 = this.method;
        this.method = null;
        return m2;
    }

    @Nullable
    public KalangParser.StatContext[] getStatContexts(MethodNode mn) {
        return this.methodStatsContexts.get(mn);
    }

    @Override
    public AstNode visitClassBody(KalangParser.ClassBodyContext ctx) {
        for (KalangParser.FieldDeclContext f : ctx.fieldDecl()) {
            this.visitFieldDecl(f);
        }
        for (KalangParser.MethodDeclContext m : ctx.methodDecl()) {
            this.visitMethodDecl(m);
        }
        return null;
    }

    @Override
    public Void visitFieldDecl(KalangParser.FieldDeclContext ctx) {
        int fieldModifier = this.parseModifier(ctx.varModifier());
        for (KalangParser.VarDeclContext vd : ctx.varDecl()) {
            ExprNode initExpr = vd.expression() != null ? this.visitExpression(vd.expression()) : null;
            AstBuilder.VarInfo varInfo = this.varDecl(vd, initExpr == null ? Types.getRootType() : initExpr.getType());
            varInfo.modifier |= fieldModifier;
            FieldNode fieldNode = this.thisClazz.createField(varInfo.type, varInfo.name, varInfo.modifier);
            if (initExpr == null) continue;
            if (AstUtil.isStatic(fieldNode.modifier)) {
                this.thisClazz.staticInitStmts.add(new ExprStmt(new AssignExpr(new StaticFieldExpr(new ClassReference(this.thisClazz), fieldNode), initExpr)));
                continue;
            }
            this.thisClazz.initStmts.add(new ExprStmt(new AssignExpr(new ObjectFieldExpr(new ThisExpr(Types.getClassType(this.thisClazz)), fieldNode), initExpr)));
        }
        return null;
    }

    @Override
    public Object visitScriptDef(KalangParser.ScriptDefContext ctx) {
        this.thisClazz.setSuperType(this.getScriptType());
        List<KalangParser.MethodDeclContext> mds = ctx.methodDecl();
        if (mds != null) {
            for (KalangParser.MethodDeclContext m : mds) {
                this.visitMethodDecl(m);
            }
        }
        MethodNode mm = this.thisClazz.createMethodNode(Types.INT_TYPE, "execute", 1);
        mm.addExceptionType(Types.getExceptionClassType());
        mm.setDefaultReturnValue(new ConstExpr(0));
        this.method = mm;
        List<KalangParser.StatContext> stats = ctx.stat();
        if (stats != null) {
            this.methodStatsContexts.put(mm, stats.toArray(new KalangParser.StatContext[stats.size()]));
        }
        AstUtil.createEmptyConstructor(this.thisClazz);
        AstUtil.createScriptMainMethodIfNotExists(this.thisClazz);
        return null;
    }

    private ObjectType getScriptType() {
        CompileContext context = this.compilationUnit.getCompileContext();
        Configuration conf = context.getConfiguration();
        AstLoader astLoader = context.getAstLoader();
        String defaultBaseClass = conf.getScriptBaseClass();
        try {
            return Types.getClassType(astLoader.loadAst(defaultBaseClass));
        }
        catch (AstNotFoundException ex) {
            throw Exceptions.missingRuntimeClass(defaultBaseClass);
        }
    }

    @Override
    ClassNode getCurrentClass() {
        return this.thisClazz;
    }

    @Override
    ClassNode getTopClass() {
        return this.topClass;
    }
}

