/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.CompileContext;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisHandler;
import kalang.compiler.compile.KalangSource;
import kalang.compiler.compile.OffsetRange;
import kalang.compiler.util.OffsetRangeHelper;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public class DiagnosisReporter {
    private final CompileContext compileContext;
    private final KalangSource kalangSource;

    public DiagnosisReporter(CompilationUnit compilationUnit) {
        this.compileContext = compilationUnit.getCompileContext();
        this.kalangSource = compilationUnit.getSource();
    }

    public void report(Diagnosis.Kind kind, String message, OffsetRange offset) {
        Diagnosis diagnosis = new Diagnosis(this.compileContext, kind, offset, message, this.kalangSource);
        this.getDisgnosisHandler().handleDiagnosis(diagnosis);
    }

    public void report(Diagnosis.Kind kind, String message, Token start, Token end) {
        OffsetRange offset = OffsetRangeHelper.getOffsetRange(start, end);
        this.report(kind, message, offset);
    }

    public void report(Diagnosis.Kind kind, String message, Token offset) {
        this.report(kind, message, offset, offset);
    }

    public void report(Diagnosis.Kind kind, String message, ParserRuleContext parserRuleCtx) {
        OffsetRange offset = OffsetRangeHelper.getOffsetRange(parserRuleCtx);
        this.report(kind, message, offset);
    }

    public void report(Diagnosis.Kind kind, String message) {
        this.report(kind, message, OffsetRange.NONE);
    }

    private DiagnosisHandler getDisgnosisHandler() {
        return this.compileContext.getDiagnosisHandler();
    }
}

