/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kalang.compiler.ast.AssignExpr;
import kalang.compiler.ast.AssignableExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.AstVisitor;
import kalang.compiler.ast.BlockStmt;
import kalang.compiler.ast.CatchBlock;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.IfStmt;
import kalang.compiler.ast.LocalVarNode;
import kalang.compiler.ast.LoopStmt;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.ReturnStmt;
import kalang.compiler.ast.ThrowStmt;
import kalang.compiler.ast.TryStmt;
import kalang.compiler.ast.VarExpr;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisReporter;
import kalang.compiler.core.Type;
import kalang.compiler.core.VarTable;
import kalang.compiler.util.CollectionsUtil;

public class InitializationAnalyzer
extends AstVisitor<Object> {
    private AstLoader astLoader;
    private MethodNode method;
    private CompilationUnit source;
    private VarTable<LocalVarNode, Void> assignedVars = new VarTable();
    private DiagnosisReporter diagnosisReporter;
    private boolean returned = false;

    public InitializationAnalyzer(CompilationUnit source, AstLoader astLoader) {
        this.astLoader = astLoader;
        this.source = source;
    }

    public void check(ClassNode clz, MethodNode method) {
        this.diagnosisReporter = new DiagnosisReporter(this.source);
        this.visit(method);
    }

    @Override
    public Object visit(AstNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof VarExpr && !this.assignedVars.exist(((VarExpr)node).getVar(), true)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, ((VarExpr)node).getVar().getName() + " is uninitialized!", ((VarExpr)node).offset);
        }
        return super.visit(node);
    }

    @Override
    public Object visitAssignExpr(AssignExpr node) {
        AssignableExpr to = node.getTo();
        if (to instanceof VarExpr) {
            this.assignedVars.put(((VarExpr)to).getVar(), null);
        }
        return super.visitAssignExpr(node);
    }

    @Override
    public Type visitTryStmt(TryStmt node) {
        ArrayList<VarTable<LocalVarNode, Void>> assignedList = new ArrayList<VarTable<LocalVarNode, Void>>(node.getCatchStmts().size() + 1);
        this.enterNewFrame();
        if (!this.visitAndCheckReturned(node.getExecStmt())) {
            assignedList.add(this.assignedVars);
        }
        this.exitFrame();
        for (CatchBlock cs : node.getCatchStmts()) {
            this.enterNewFrame();
            if (!this.visitAndCheckReturned(cs)) {
                assignedList.add(this.assignedVars);
            }
            this.exitFrame();
        }
        this.addIntersectedAssignedVar(assignedList);
        BlockStmt finallyStmt = node.getFinallyStmt();
        if (finallyStmt != null) {
            this.visit(finallyStmt);
        }
        return null;
    }

    @Override
    public Type visitIfStmt(IfStmt node) {
        ArrayList<VarTable<LocalVarNode, Void>> assignedVarsList = new ArrayList<VarTable<LocalVarNode, Void>>(2);
        this.enterNewFrame();
        if (!this.visitAndCheckReturned(node.getTrueBody())) {
            assignedVarsList.add(this.assignedVars);
        }
        this.exitFrame();
        this.enterNewFrame();
        if (!this.visitAndCheckReturned(node.getFalseBody())) {
            assignedVarsList.add(this.assignedVars);
        }
        this.exitFrame();
        this.addIntersectedAssignedVar(assignedVarsList);
        return null;
    }

    @Override
    public Type visitLoopStmt(LoopStmt node) {
        this.visit(node.getPreConditionExpr());
        this.enterNewFrame();
        this.visit(node.getLoopBody());
        this.exitFrame();
        this.enterNewFrame();
        this.visit(node.getUpdateStmt());
        this.exitFrame();
        this.visit(node.getPostConditionExpr());
        return null;
    }

    @Override
    public Object visitMethodNode(MethodNode node) {
        this.method = node;
        return super.visitMethodNode(node);
    }

    protected void enterNewFrame() {
        this.assignedVars = new VarTable<LocalVarNode, Void>(this.assignedVars);
    }

    protected void exitFrame() {
        this.assignedVars = this.assignedVars.getParent();
    }

    protected void addIntersectedAssignedVar(List<VarTable<LocalVarNode, Void>> assignedVarsList) {
        if (assignedVarsList.isEmpty()) {
            return;
        }
        if (assignedVarsList.size() == 1) {
            for (Map.Entry<LocalVarNode, Void> s : assignedVarsList.get(0).vars().entrySet()) {
                this.assignedVars.put(s.getKey(), null);
            }
            return;
        }
        Set[] assigned = new Set[assignedVarsList.size()];
        for (int i = 0; i < assigned.length; ++i) {
            assigned[i] = assignedVarsList.get(i).keySet();
        }
        Set<LocalVarNode> sets = CollectionsUtil.getIntersection(assigned);
        for (LocalVarNode s : sets) {
            this.assignedVars.put(s, null);
        }
    }

    @Override
    public Object visitCatchBlock(CatchBlock node) {
        this.assignedVars.put(node.catchVar, null);
        return super.visitCatchBlock(node);
    }

    @Override
    public Object visitReturnStmt(ReturnStmt node) {
        this.returned = true;
        return super.visitReturnStmt(node);
    }

    @Override
    public Object visitThrowStmt(ThrowStmt node) {
        this.returned = true;
        return super.visitThrowStmt(node);
    }

    private boolean visitAndCheckReturned(AstNode node) {
        boolean oldReturned = this.returned;
        this.returned = false;
        this.visit(node);
        boolean ret = this.returned;
        this.returned = oldReturned;
        return ret;
    }
}

