/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.compiler.AstNotFoundException;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.JvmClassNode;

public class JavaAstLoader
extends AstLoader {
    static String ROOT_CLASS = "java.lang.Object";
    private ClassLoader javaClassLoader;
    private Map<String, ClassNode> loadedClasses = new HashMap<String, ClassNode>();
    private final AstLoader parentAstLoader;

    public JavaAstLoader(@Nullable AstLoader parentAstLoader, @Nonnull ClassLoader javaClassLoader) {
        Objects.requireNonNull(javaClassLoader);
        this.javaClassLoader = javaClassLoader;
        this.parentAstLoader = parentAstLoader;
    }

    public JavaAstLoader() {
        this(null, JavaAstLoader.class.getClassLoader());
    }

    @Override
    protected ClassNode findAst(String className) throws AstNotFoundException {
        if (className == null) {
            System.err.println("warning:trying to null class");
            throw new AstNotFoundException("null");
        }
        ClassNode ast = this.loadedClasses.get(className);
        if (ast != null) {
            return ast;
        }
        try {
            return super.findAst(className);
        }
        catch (AstNotFoundException e) {
            try {
                Class<?> clz = this.javaClassLoader.loadClass(className);
                ast = this.buildFromClass(clz);
                return ast;
            }
            catch (ClassNotFoundException ex) {
                throw e;
            }
        }
    }

    @Nonnull
    private ClassNode buildFromClass(@Nonnull Class clz) throws AstNotFoundException {
        JvmClassNode cn = new JvmClassNode(clz, this);
        this.loadedClasses.put(clz.getName(), cn);
        return cn;
    }
}

