/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import kalang.compiler.AstNotFoundException;
import kalang.compiler.ast.AnnotationNode;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.FieldNode;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.compile.JavaAstLoader;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.exception.Exceptions;
import kalang.compiler.util.ModifierUtil;

public class JvmClassNode
extends ClassNode {
    private final JavaAstLoader astLoader;
    private final Class clazz;
    private boolean superTypeInitialized;
    private boolean fieldsInitialized;
    private boolean methodsInitialized;
    private boolean interfacesInitialized;
    private boolean genericTypesInitialized;
    private boolean annotationInitialized;
    private Map<TypeVariable, GenericType> genericTypeMap = null;

    public JvmClassNode(Class clazz, JavaAstLoader astLoader) {
        this.astLoader = astLoader;
        this.clazz = clazz;
        this.name = clazz.getName();
        this.modifier = clazz.getModifiers();
    }

    @Override
    public ObjectType getSuperType() {
        if (!this.superTypeInitialized) {
            this.superTypeInitialized = true;
            java.lang.reflect.Type superType = this.clazz.getGenericSuperclass();
            Class superClazz = this.clazz.getSuperclass();
            if (superType != null) {
                this.setSuperType((ObjectType)this.getType(superType, this.getGenericTypeMap(), superClazz, NullableKind.NONNULL));
            }
        }
        return super.getSuperType();
    }

    @Override
    public ObjectType[] getInterfaces() {
        if (!this.interfacesInitialized) {
            this.interfacesInitialized = true;
            java.lang.reflect.Type[] typeInterfaces = this.clazz.getGenericInterfaces();
            Class<?>[] clzInterfaces = this.clazz.getInterfaces();
            if (clzInterfaces != null) {
                for (int i = 0; i < clzInterfaces.length; ++i) {
                    this.addInterface((ObjectType)this.getType(typeInterfaces[i], this.getGenericTypeMap(), clzInterfaces[i], NullableKind.NONNULL));
                }
            }
        }
        return super.getInterfaces();
    }

    @Override
    public FieldNode[] getFields() {
        if (!this.fieldsInitialized) {
            this.fieldsInitialized = true;
            for (Field f : this.clazz.getDeclaredFields()) {
                NullableKind nullable = this.getNullable(f.getAnnotations());
                FieldNode fieldNode = this.createField(this.getType(f.getGenericType(), this.getGenericTypeMap(), f.getType(), nullable), f.getName(), f.getModifiers());
            }
        }
        return super.getFields();
    }

    @Override
    public MethodNode[] getDeclaredMethodNodes() {
        if (!this.methodsInitialized) {
            this.methodsInitialized = true;
            LinkedList<Executable> methods = new LinkedList<Executable>();
            methods.addAll(Arrays.asList(this.clazz.getDeclaredMethods()));
            methods.addAll(Arrays.asList(this.clazz.getDeclaredConstructors()));
            for (Executable m : methods) {
                int mModifier;
                String mName;
                Type mType;
                NullableKind nullable = this.getNullable(m.getAnnotations());
                HashMap<TypeVariable, GenericType> gTypeMap = new HashMap<TypeVariable, GenericType>(this.getGenericTypeMap());
                if (m instanceof Method) {
                    mType = this.getType(((Method)m).getGenericReturnType(), gTypeMap, ((Method)m).getReturnType(), nullable);
                    mName = m.getName();
                    mModifier = m.getModifiers();
                } else if (m instanceof Constructor) {
                    mName = "<init>";
                    mType = Types.VOID_TYPE;
                    mModifier = m.getModifiers();
                } else {
                    throw Exceptions.unexceptedValue(m);
                }
                MethodNode methodNode = this.createMethodNode(mType, mName, mModifier);
                for (Parameter parameter : m.getParameters()) {
                    NullableKind pnullable = this.getNullable(parameter.getAnnotations());
                    methodNode.createParameter(this.getType(parameter.getParameterizedType(), gTypeMap, parameter.getType(), pnullable), parameter.getName());
                }
                for (AnnotatedElement annotatedElement : m.getExceptionTypes()) {
                    methodNode.addExceptionType(this.getType((java.lang.reflect.Type)((Object)annotatedElement), gTypeMap, (Class)annotatedElement, NullableKind.NONNULL));
                }
                for (Annotation annotation : m.getAnnotations()) {
                    methodNode.addAnnotation(this.transAnnotation(annotation));
                }
            }
        }
        return super.getDeclaredMethodNodes();
    }

    @Override
    public GenericType[] getGenericTypes() {
        if (!this.genericTypesInitialized) {
            this.genericTypesInitialized = true;
            this.getGenericTypeMap();
        }
        return super.getGenericTypes();
    }

    @Override
    public AnnotationNode[] getAnnotations() {
        if (!this.annotationInitialized) {
            this.annotationInitialized = true;
            for (Annotation a : this.clazz.getAnnotations()) {
                this.annotations.add(this.transAnnotation(a));
            }
        }
        return super.getAnnotations();
    }

    @Nullable
    private Type[] transType(java.lang.reflect.Type[] ts, Map<TypeVariable, GenericType> genericTypes) {
        Type[] ret = new Type[ts.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.transType(ts[i], genericTypes);
            if (ret[i] != null) continue;
            return null;
        }
        return ret;
    }

    @Nullable
    private Type transType(java.lang.reflect.Type t, Map<TypeVariable, GenericType> genericTypes) {
        if (t instanceof TypeVariable) {
            GenericType vt = genericTypes.get(t);
            if (vt == null) {
                vt = this.transTypeVariableToGenericType((TypeVariable)t, genericTypes);
            }
            return vt;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Type rawType = this.transType(pt.getRawType(), genericTypes);
            if (!(rawType instanceof ObjectType)) {
                return null;
            }
            java.lang.reflect.Type[] typeArgs = pt.getActualTypeArguments();
            Type[] gTypes = this.transType(typeArgs, genericTypes);
            if (gTypes == null) {
                return null;
            }
            return Types.getClassType(((ObjectType)rawType).getClassNode(), gTypes);
        }
        if (t instanceof WildcardType) {
            WildcardType wt = (WildcardType)t;
            Type[] upperBounds = this.transType(wt.getUpperBounds(), genericTypes);
            if (upperBounds == null) {
                return null;
            }
            Type[] lowerBounds = this.transType(wt.getLowerBounds(), genericTypes);
            if (lowerBounds == null) {
                return null;
            }
            return new kalang.compiler.core.WildcardType(upperBounds, lowerBounds);
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)t;
            Type ct = this.transType(gt.getGenericComponentType(), genericTypes);
            if (ct == null) {
                return null;
            }
            return Types.getArrayType(ct, NullableKind.NONNULL);
        }
        if (t instanceof Class) {
            Class type = (Class)t;
            if (type.isPrimitive()) {
                return Types.getPrimitiveType(type.getTypeName());
            }
            if (type.isArray()) {
                Type ct = this.transType(type.getComponentType(), genericTypes);
                if (ct == null) {
                    return null;
                }
                return Types.getArrayType(ct);
            }
            try {
                return Types.getClassType(this.astLoader.findAst(type.getName()));
            }
            catch (AstNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    private Type getType(java.lang.reflect.Type t, Map<TypeVariable, GenericType> genericTypes, Class defaultClass, NullableKind nullable) {
        Type type = this.transType(t, genericTypes);
        if (type == null) {
            type = this.transType(defaultClass, genericTypes);
        }
        if (type instanceof ClassType) {
            return Types.getClassType((ClassType)type, nullable);
        }
        return type;
    }

    private NullableKind getNullable(Annotation[] annotations) {
        for (Annotation a : annotations) {
            String simpleName;
            Class<? extends Annotation> at = a.annotationType();
            switch (simpleName = at.getSimpleName().toLowerCase()) {
                case "nullable": 
                case "nullallowed": {
                    return NullableKind.NULLABLE;
                }
                case "nonnull": 
                case "notnull": {
                    return NullableKind.NONNULL;
                }
            }
        }
        return NullableKind.UNKNOWN;
    }

    private Map<TypeVariable, GenericType> getGenericTypeMap() {
        if (this.genericTypeMap == null) {
            HashMap<TypeVariable, GenericType> gTypesMap = new HashMap<TypeVariable, GenericType>();
            TypeVariable<Class<T>>[] typeParameters = this.clazz.getTypeParameters();
            if (typeParameters.length > 0) {
                for (TypeVariable pt : typeParameters) {
                    GenericType gt = this.transTypeVariableToGenericType(pt, gTypesMap);
                    gTypesMap.put(pt, gt);
                    this.declareGenericType(gt);
                }
            }
            this.genericTypeMap = gTypesMap;
        }
        return this.genericTypeMap;
    }

    private ObjectType[] castToClassTypes(Type[] types) {
        if (types == null) {
            return null;
        }
        ObjectType[] cts = new ObjectType[types.length];
        for (int i = 0; i < types.length; ++i) {
            cts[i] = (ClassType)types[i];
        }
        return cts;
    }

    private GenericType transTypeVariableToGenericType(TypeVariable pt, Map<TypeVariable, GenericType> gTypesMap) {
        ObjectType[] interfaces;
        ObjectType superType;
        GenericType genericClassType = new GenericType(pt.getName(), Types.getRootType(), new ObjectType[0], NullableKind.NONNULL);
        gTypesMap.put(pt, genericClassType);
        ObjectType[] bounds = this.castToClassTypes(this.transType(pt.getBounds(), gTypesMap));
        if (bounds != null && bounds.length > 0) {
            if (ModifierUtil.isInterface(bounds[0].getModifier())) {
                superType = Types.getRootType();
                interfaces = bounds;
            } else {
                superType = bounds[0];
                interfaces = new ObjectType[bounds.length - 1];
                System.arraycopy(bounds, 1, interfaces, 0, interfaces.length);
            }
        } else {
            superType = Types.getRootType();
            interfaces = bounds;
        }
        ClassNode classNode = genericClassType.getClassNode();
        classNode.setSuperType(superType);
        for (ObjectType it : interfaces) {
            classNode.addInterface(it);
        }
        return genericClassType;
    }

    private AnnotationNode transAnnotation(Annotation an) {
        ObjectType anType = (ObjectType)this.transType(an.annotationType(), this.getGenericTypeMap());
        return new AnnotationNode(anType.getClassNode());
    }
}

