/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.compiler.AstNotFoundException;
import kalang.compiler.antlr.KalangLexer;
import kalang.compiler.antlr.KalangParser;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.compile.AstBuilder;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.CompileContext;
import kalang.compiler.compile.Configuration;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisHandler;
import kalang.compiler.compile.JavaAstLoader;
import kalang.compiler.compile.KalangSource;
import kalang.compiler.compile.OffsetRange;
import kalang.compiler.compile.SemanticAnalyzer;
import kalang.compiler.compile.SourceLoader;
import kalang.compiler.compile.StandardDiagnosisHandler;
import kalang.compiler.util.AntlrErrorString;
import kalang.compiler.util.LexerFactory;
import kalang.compiler.util.OffsetRangeHelper;
import kalang.compiler.util.TokenStreamFactory;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public abstract class KalangCompiler
extends AstLoader
implements CompileContext {
    private int compileTargetPhase = 6;
    private HashMap<String, CompilationUnit> compilationUnits = new HashMap();
    @Nonnull
    private final HashMap<String, KalangSource> sources = new HashMap();
    private int compilingPhase;
    private DiagnosisHandler diagnosisHandler = StandardDiagnosisHandler.INSTANCE;
    private Configuration configuration = new Configuration();
    private SourceLoader sourceLoader = new SourceLoader(){

        @Override
        public KalangSource loadSource(String className) {
            return null;
        }
    };

    public KalangCompiler() {
        this(new JavaAstLoader());
    }

    public KalangCompiler(AstLoader astLoader) {
        super(astLoader);
    }

    public void addSource(String className, String source, String fileName) {
        KalangSource src = new KalangSource(className, source, fileName);
        this.addSource(src);
    }

    public void addSource(KalangSource source) {
        String className = source.getClassName();
        this.sources.put(className, source);
        this.compilationUnits.put(className, this.createCompilationUnit(source));
    }

    public void setCompileTargetPhase(int targetPhase) {
        this.compileTargetPhase = targetPhase;
    }

    public int getCompileTargetPhase() {
        return this.compileTargetPhase;
    }

    public void compile(int targetPhase) {
        while (this.compilingPhase < targetPhase && this.compilingPhase < this.compileTargetPhase) {
            ++this.compilingPhase;
            for (CompilationUnit unit : this.compilationUnits.values()) {
                unit.compile(this.compilingPhase);
            }
        }
    }

    public void compile() {
        this.compile(this.compileTargetPhase);
    }

    private ClassNode findInnerClass(ClassNode topClass, String className) {
        for (ClassNode c : topClass.classes) {
            if (className.equals(c.name)) {
                return c;
            }
            ClassNode ic = this.findInnerClass(c, className);
            if (ic == null) continue;
            return ic;
        }
        return null;
    }

    @Override
    protected ClassNode findAst(@Nonnull String className) throws AstNotFoundException {
        KalangSource source;
        SourceLoader srcLoader;
        String[] classNameInfo = className.split("\\$", 2);
        String topClassName = classNameInfo[0];
        if (this.compilationUnits.containsKey(topClassName)) {
            CompilationUnit compilationUnit = this.compilationUnits.get(topClassName);
            ClassNode clazz = compilationUnit.getAst();
            if (classNameInfo.length == 1) {
                return clazz;
            }
            ClassNode c = this.findInnerClass(clazz, className);
            if (c != null) {
                return c;
            }
        }
        if ((srcLoader = this.getSourceLoader()) != null && (source = srcLoader.loadSource(className)) != null) {
            return this.createCompilationUnit(source).getAst();
        }
        return super.findAst(className);
    }

    @Nonnull
    public HashMap<String, KalangSource> getSources() {
        return this.sources;
    }

    @Nonnull
    public HashMap<String, CompilationUnit> getCompilationUnits() {
        return this.compilationUnits;
    }

    @Nullable
    public CompilationUnit getCompilationUnit(@Nonnull String className) {
        return this.compilationUnits.get(className);
    }

    protected CompilationUnit newCompilationUnit(KalangSource source) {
        return new CompilationUnit(source, this);
    }

    private CompilationUnit createCompilationUnit(KalangSource source) {
        CompilationUnit unit = this.newCompilationUnit(source);
        this.compilationUnits.put(source.getClassName(), unit);
        unit.compile(this.compilingPhase);
        return unit;
    }

    public int getCurrentCompilePhase() {
        return this.compilingPhase;
    }

    @Override
    public KalangLexer createLexer(final CompilationUnit compilationUnit, String source) {
        KalangLexer lexer = LexerFactory.createLexer(source);
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                Diagnosis diagnosis = new Diagnosis(compilationUnit.getCompileContext(), Diagnosis.Kind.ERROR, OffsetRange.NONE, "line " + line + ":" + charPositionInLine + " " + msg, compilationUnit.getSource());
                KalangCompiler.this.diagnosisHandler.handleDiagnosis(diagnosis);
            }
        });
        return lexer;
    }

    @Override
    public CommonTokenStream createTokenStream(CompilationUnit compilationUnit, KalangLexer lexer) {
        return TokenStreamFactory.createTokenStream((TokenSource)lexer);
    }

    @Override
    public KalangParser createParser(final CompilationUnit compilationUnit, CommonTokenStream tokenStream) {
        KalangParser parser = new KalangParser((TokenStream)tokenStream);
        parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy(){

            public void reportError(Parser recognizer, RecognitionException e) {
                String msg = AntlrErrorString.exceptionString(recognizer, e);
                Diagnosis diagnosis = new Diagnosis(compilationUnit.getCompileContext(), Diagnosis.Kind.ERROR, OffsetRangeHelper.getOffsetRange(e.getOffendingToken()), msg, compilationUnit.getSource());
                KalangCompiler.this.diagnosisHandler.handleDiagnosis(diagnosis);
            }
        });
        return parser;
    }

    @Override
    public AstBuilder createAstBuilder(CompilationUnit compilationUnit, KalangParser parser) {
        return new AstBuilder(compilationUnit, parser);
    }

    @Override
    public SemanticAnalyzer createSemanticAnalyzer(CompilationUnit compilationUnit, AstLoader astLoader) {
        return new SemanticAnalyzer(compilationUnit, astLoader);
    }

    @Override
    public final AstLoader getAstLoader() {
        return this;
    }

    @Override
    public SourceLoader getSourceLoader() {
        return this.sourceLoader;
    }

    public void setSourceLoader(SourceLoader sourceLoader) {
        this.sourceLoader = sourceLoader;
    }

    @Override
    public DiagnosisHandler getDiagnosisHandler() {
        return this.diagnosisHandler;
    }

    public void setDiagnosisHandler(DiagnosisHandler diagnosisHandler) {
        this.diagnosisHandler = diagnosisHandler;
    }

    @Override
    public void stopCompile(int stopPhase) {
        this.setCompileTargetPhase(stopPhase);
    }

    @Override
    public int getCompilingPhase() {
        return this.compilingPhase;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

