/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.CompareExpr;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.InstanceOfExpr;
import kalang.compiler.ast.LocalVarNode;
import kalang.compiler.ast.LogicExpr;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.StaticInvokeExpr;
import kalang.compiler.ast.UnaryExpr;
import kalang.compiler.ast.VarExpr;
import kalang.compiler.ast.VarObject;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.core.VarTable;
import kalang.compiler.exception.Exceptions;

public class MethodContext {
    public static final int NULLSTATE_MUST_NULL = 0;
    public static final int NULLSTATE_MUST_NONNULL = 1;
    public static final int NULLSTATE_UNKNOWN = 2;
    public static final int NULLSTATE_NULLABLE = 3;
    public final ClassNode classNode;
    public final MethodNode method;
    public boolean returned = false;
    public VarTable<String, LocalVarNode> varTables = new VarTable();
    public VarTable<VarObject, Type> overrideTypes = new VarTable();
    public VarTable<VarObject, Integer> nullState = new VarTable();

    public MethodContext(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.method = methodNode;
    }

    public void newFrame() {
        this.varTables = this.varTables.newStack();
    }

    public void popFrame() {
        this.varTables = this.varTables.popStack();
    }

    public void onAssign(ExprNode to, ExprNode expr) {
        Type toType;
        this.removeOverrideType(to);
        if (to instanceof VarExpr) {
            ((VarExpr)to).removeOverrideType();
        } else if (to instanceof ParameterExpr) {
            ((ParameterExpr)to).removeOverrideType();
        }
        VarObject key = this.getOverrideTypeKey(to);
        if (key != null && (toType = to.getType()) instanceof ObjectType) {
            int ns;
            Type type = expr.getType();
            if (Types.NULL_TYPE.equals(type)) {
                ns = 0;
            } else if (type instanceof ObjectType) {
                ns = this.getNullState(((ObjectType)type).getNullable());
            } else {
                throw Exceptions.unexceptedValue(type);
            }
            this.nullState.put(key, ns);
        }
    }

    public void onIf(ExprNode expr, boolean onTrue) {
        if (expr instanceof InstanceOfExpr && onTrue) {
            InstanceOfExpr ie = (InstanceOfExpr)expr;
            this.changeTypeTemporarilyIfCould(ie.getExpr(), Types.getClassType(ie.getTarget().getReferencedClassNode()));
        } else if (expr instanceof CompareExpr) {
            CompareExpr ce = (CompareExpr)expr;
            ExprNode e1 = ce.getExpr1();
            ExprNode e2 = ce.getExpr2();
            boolean isEQ = ce.getOperation().equals("==");
            if (e1.getType().equals(Types.NULL_TYPE)) {
                this.onNull(e2, onTrue, isEQ);
            } else if (e2.getType().equals(Types.NULL_TYPE)) {
                this.onNull(e1, onTrue, isEQ);
            }
        } else if (expr instanceof StaticInvokeExpr) {
            StaticInvokeExpr sie = (StaticInvokeExpr)expr;
            ExprNode[] args = sie.getArguments();
            if (args == null || args.length != 2) {
                return;
            }
            String invokeClass = sie.getInvokeClass().getReferencedClassNode().name;
            if (!Objects.class.getName().equals(invokeClass)) {
                return;
            }
            String methodName = sie.getMethod().getName();
            if (!"equals".equals(methodName) && !"deepEquals".equals(methodName)) {
                return;
            }
            if (Types.NULL_TYPE.equals(args[0].getType())) {
                this.onNull(args[1], onTrue, true);
            } else if (Types.NULL_TYPE.equals(args[1].getType())) {
                this.onNull(args[0], onTrue, true);
            }
        } else if (expr instanceof UnaryExpr) {
            this.onIf(((UnaryExpr)expr).getExpr(), !onTrue);
        } else if (expr instanceof LogicExpr) {
            LogicExpr le = (LogicExpr)expr;
            if (le.getOperation().equals("&&")) {
                if (onTrue) {
                    this.onIf(le.getExpr1(), true);
                    this.onIf(le.getExpr2(), true);
                }
            } else if (le.getOperation().equals("||") && !onTrue) {
                this.onIf(le.getExpr1(), false);
                this.onIf(le.getExpr2(), false);
            }
        }
    }

    public Type getVarObjectType(VarObject p) {
        Type type = this.overrideTypes.get(p);
        if (type == null) {
            type = p.getType();
        }
        if (type instanceof ClassType) {
            NullableKind nullable;
            Integer ns = this.nullState.get(p);
            if (ns == null) {
                nullable = ((ObjectType)type).getNullable();
            } else if (ns == 1) {
                nullable = NullableKind.NONNULL;
            } else if (ns == 2) {
                nullable = NullableKind.UNKNOWN;
            } else if (ns == 0 || ns == 3) {
                nullable = NullableKind.NULLABLE;
            } else {
                throw Exceptions.unexceptedValue(ns);
            }
            return Types.getClassType((ClassType)type, nullable);
        }
        return type;
    }

    public void handleMultiBranchedAssign(Map<VarObject, Integer> ... assignedTable) {
        if (assignedTable.length < 2) {
            throw Exceptions.illegalArgument(assignedTable);
        }
        HashMap<VarObject, Integer> ret = new HashMap<VarObject, Integer>();
        ret.putAll(assignedTable[0]);
        for (int i = 1; i < assignedTable.length; ++i) {
            Map<VarObject, Integer> other = assignedTable[i];
            for (Map.Entry e : ret.entrySet()) {
                Integer otherNullable;
                Integer oneNullable = (Integer)e.getValue();
                if (oneNullable.equals(otherNullable = other.get(e.getKey()))) continue;
                if (otherNullable == null) {
                    ret.remove(e.getKey());
                    continue;
                }
                int ns = oneNullable.equals(1) && otherNullable.equals(2) || otherNullable.equals(1) && oneNullable.equals(2) ? 2 : 3;
                ret.put((VarObject)e.getKey(), ns);
            }
        }
        for (Map.Entry e : ret.entrySet()) {
            this.nullState.put((VarObject)e.getKey(), (Integer)e.getValue());
        }
    }

    @Nullable
    public LocalVarNode getNamedLocalVar(String name) {
        return this.varTables.get(name);
    }

    public void newOverrideTypeStack() {
        this.overrideTypes = new VarTable<VarObject, Type>(this.overrideTypes);
    }

    public void popOverrideTypeStack() {
        this.overrideTypes = this.overrideTypes.getParent();
    }

    @Nullable
    public ParameterNode getNamedParameter(String name) {
        for (ParameterNode p : this.method.getParameters()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    private void changeTypeTemporarilyIfCould(ExprNode expr, Type type) {
        VarObject key = this.getOverrideTypeKey(expr);
        if (key != null) {
            this.overrideTypes.put(key, type);
        }
    }

    private void onNull(ExprNode expr, boolean onTrue, boolean isEQ) {
        boolean mustNull = onTrue && isEQ || !onTrue && !isEQ;
        VarObject key = this.getOverrideTypeKey(expr);
        if (key != null) {
            this.nullState.put(key, mustNull ? 0 : 1);
        }
    }

    @Nullable
    private VarObject getOverrideTypeKey(ExprNode expr) {
        VarObject key = expr instanceof VarExpr ? ((VarExpr)expr).getVar() : (expr instanceof ParameterExpr ? ((ParameterExpr)expr).getParameter() : null);
        return key;
    }

    private void removeOverrideType(ExprNode expr) {
        VarObject key = this.getOverrideTypeKey(expr);
        if (key != null) {
            this.overrideTypes.remove(key, true);
        }
    }

    private int getNullState(NullableKind nullable) {
        int ns;
        if (nullable == NullableKind.NONNULL) {
            ns = 1;
        } else if (nullable == NullableKind.NULLABLE) {
            ns = 3;
        } else if (nullable == NullableKind.UNKNOWN) {
            ns = 2;
        } else {
            throw Exceptions.unexceptedValue((Object)nullable);
        }
        return ns;
    }
}

