/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nullable;
import kalang.compiler.ast.AnnotationNode;
import kalang.compiler.ast.AssignableExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.AstVisitor;
import kalang.compiler.ast.BinaryExpr;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ElementExpr;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.FieldExpr;
import kalang.compiler.ast.LocalVarNode;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.ReturnStmt;
import kalang.compiler.ast.UnaryExpr;
import kalang.compiler.ast.VarExpr;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.CompileContext;
import kalang.compiler.compile.Diagnosis;
import kalang.compiler.compile.DiagnosisReporter;
import kalang.compiler.compile.OffsetRange;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.FieldDescriptor;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.PrimitiveType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.exception.Exceptions;
import kalang.compiler.util.AstUtil;
import kalang.compiler.util.BoxUtil;

public class SemanticAnalyzer
extends AstVisitor<Type> {
    private AstLoader astLoader;
    private ClassNode clazz;
    private CompilationUnit source;
    private final DiagnosisReporter diagnosisReporter;

    public SemanticAnalyzer(CompilationUnit source, AstLoader astLoader) {
        this.astLoader = astLoader;
        this.source = source;
        CompileContext ctx = source.getCompileContext();
        this.diagnosisReporter = new DiagnosisReporter(source);
    }

    @Nullable
    private ExprNode checkAssign(ExprNode expr, Type from, Type to, AstNode node) {
        if ((expr = BoxUtil.assign(expr, from, to)) == null) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, from.getName() + " can not be converted to " + to.getName(), node.offset);
            return null;
        }
        return expr;
    }

    @Nullable
    public static PrimitiveType getPrimitiveType(Type t) {
        if (t instanceof PrimitiveType) {
            return (PrimitiveType)t;
        }
        if (t instanceof ObjectType) {
            return Types.getPrimitiveType((ObjectType)t);
        }
        return null;
    }

    public boolean validateBinaryExpr(BinaryExpr node) {
        String op;
        ExprNode expr1 = node.getExpr1();
        ExprNode expr2 = node.getExpr2();
        Type t1 = expr1.getType();
        Type t2 = expr2.getType();
        switch (op = node.getOperation()) {
            case "==": 
            case "!=": {
                if (Types.isNumber(t1)) {
                    return this.requireNumber(expr2, t2);
                }
                return true;
            }
            case "+": 
            case "-": 
            case "*": 
            case "/": 
            case "%": 
            case ">=": 
            case "<=": 
            case ">": 
            case "<": 
            case "&": 
            case "|": 
            case "^": 
            case "<<": 
            case ">>": {
                return this.requireNumber(expr1, t1) && this.requireNumber(expr2, t2);
            }
            case "&&": 
            case "||": {
                return this.requireBoolean(expr1, t1) && this.requireBoolean(expr2, t2);
            }
        }
        this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "unsupport operation:" + op, node.offset);
        return false;
    }

    public boolean validateElementExpr(ElementExpr node) {
        return this.requireArray(node, node.getArrayExpr().getType());
    }

    public boolean validateUnaryExpr(UnaryExpr node) {
        String op = node.getOperation();
        Type et = node.getExpr().getType();
        switch (op) {
            case "!": {
                return this.requireBoolean(node, et);
            }
            case "-": 
            case "+": 
            case "~": {
                return this.requireNumber(node, et);
            }
        }
        throw Exceptions.unexceptedValue(op);
    }

    public boolean validateAssign(AssignableExpr to, ExprNode from, OffsetRange offset, boolean isInitializationStmt) {
        Type fromType;
        Type toType;
        if (to instanceof VarExpr) {
            LocalVarNode varObject = ((VarExpr)to).getVar();
            if (!isInitializationStmt && Modifier.isFinal(varObject.modifier)) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, String.format("%s is readonly", varObject.getName()), offset);
                return false;
            }
        } else if (to instanceof FieldExpr) {
            FieldDescriptor field = ((FieldExpr)to).getField();
            if (!isInitializationStmt && Modifier.isFinal(field.getModifier())) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, String.format("%s is readonly", field.getName()), offset);
                return false;
            }
        } else if (to instanceof ParameterExpr) {
            ParameterNode parameter = ((ParameterExpr)to).getParameter();
            if (Modifier.isFinal(parameter.modifier)) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, String.format("%s is readonly", parameter.getName()), offset);
                return false;
            }
        }
        if (!(toType = to.getType()).isAssignableFrom(fromType = from.getType())) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, String.format("incompatible types: %s cannot be converted to %s", fromType, toType), offset);
            return false;
        }
        return true;
    }

    public boolean validateReturnStmt(MethodNode method, ReturnStmt node) {
        Type retType = method.getType();
        if (node.expr == null) {
            if (!retType.equals(Types.VOID_TYPE)) {
                this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "missing return value", node.offset);
                return false;
            }
            return true;
        }
        Type exType = node.expr.getType();
        node.expr = this.checkAssign(node.expr, exType, retType, node);
        return node.expr != null;
    }

    boolean requireNumber(AstNode node, Type t) {
        if (!this.isNumber(t)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "number type required", node.offset);
            return false;
        }
        return true;
    }

    boolean requireBoolean(ExprNode node) {
        return this.requireBoolean(node, node.getType());
    }

    boolean requireBoolean(AstNode node, Type t) {
        if (!Types.isBoolean(t)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "boolean type required.", node.offset);
            return false;
        }
        return true;
    }

    boolean isArray(Type t) {
        return t instanceof ArrayType;
    }

    boolean requireArray(AstNode node, Type t) {
        if (!this.isArray(t)) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "array type required.");
            return false;
        }
        return true;
    }

    public boolean isStatic(int modifier) {
        return AstUtil.isStatic(modifier);
    }

    boolean requireStatic(Integer modifier, AstNode node) {
        boolean isStatic = this.isStatic(modifier);
        if (!isStatic) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "couldn't refer non-static member in static context", node.offset);
            return false;
        }
        return true;
    }

    boolean requireNoneVoid(Type type, AstNode node) {
        if (type == null || type == Types.VOID_TYPE || type == Types.getVoidClassType()) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "use void type as value", node.offset);
            return false;
        }
        return true;
    }

    private boolean isNumber(Type t1) {
        return Types.isNumber(t1);
    }

    protected void validateAnnotation(AnnotationNode[] annotation) {
        for (AnnotationNode an : annotation) {
            this.validateAnnotation(an);
        }
    }

    protected boolean validateAnnotation(AnnotationNode annotation) {
        MethodNode[] mds = annotation.getAnnotationType().getDeclaredMethodNodes();
        Set<String> attrKeys = annotation.values.keySet();
        LinkedList<String> missingValues = new LinkedList<String>();
        for (MethodNode m : mds) {
            String name = m.getName();
            if (attrKeys.contains(name)) continue;
            missingValues.add(name);
        }
        if (missingValues.size() > 0) {
            this.diagnosisReporter.report(Diagnosis.Kind.ERROR, "Missing attribute for annotation:" + ((Object)missingValues).toString(), OffsetRange.NONE);
            return false;
        }
        return true;
    }
}

