/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.util.AstUtil;
import kalang.compiler.util.NameUtil;

public class TypeNameResolver {
    private Map<String, String> simpleToFullNames = new HashMap<String, String>();
    private List<String> importPackages = new LinkedList<String>();
    private AstLoader astLoader;

    public void importClass(String className) {
        this.importClass(className, NameUtil.getSimpleClassName(className));
    }

    public void importClass(String className, String alias) {
        this.simpleToFullNames.put(alias, className);
    }

    public void importPackage(String packageName) {
        this.importPackages.add(packageName);
    }

    private String fixInnerClassName(String className) {
        String name = "";
        for (String n : className.split("\\.")) {
            name = name + n;
            name = this.astLoader != null && this.astLoader.getAst(name) != null ? name + "$" : name + ".";
        }
        return name.substring(0, name.length() - 1);
    }

    @Nullable
    public String resolve(String id, ClassNode topClass, ClassNode declaringClass) {
        if (id.contains(".")) {
            return id;
        }
        if (this.simpleToFullNames.containsKey(id)) {
            return this.fixInnerClassName(this.simpleToFullNames.get(id));
        }
        if (id.contains("$")) {
            String[] idParts = id.split("\\$");
            String outerClassName = this.resolve(idParts[0], topClass, declaringClass);
            if (outerClassName == null) {
                return null;
            }
            return outerClassName + "$" + idParts[1];
        }
        String[] innerClassesNames = AstUtil.listInnerClassesNames(topClass, true);
        String path = declaringClass.name;
        while (!path.isEmpty()) {
            String name = path + "$" + id;
            for (String c : innerClassesNames) {
                if (!name.equals(c)) continue;
                return c;
            }
            int last$ = path.lastIndexOf(36);
            path = last$ > 0 ? path.substring(0, last$) : "";
        }
        ArrayList<String> paths = new ArrayList<String>(this.importPackages.size() + 1);
        paths.addAll(this.importPackages);
        paths.add(NameUtil.getPackageName(topClass.name));
        int pathSize = paths.size();
        for (int i = pathSize - 1; i >= 0; --i) {
            String p = (String)paths.get(i);
            String clsName = p != null && p.length() > 0 ? p + "." + id : id;
            if (this.astLoader == null || this.astLoader.getAst(this.fixInnerClassName(clsName)) == null) continue;
            return clsName;
        }
        return null;
    }

    public void setAstLoader(AstLoader astLoader) {
        this.astLoader = astLoader;
    }
}

