/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalang.compiler.AstNotFoundException;
import kalang.compiler.ast.AbstractAstVisitor;
import kalang.compiler.ast.AnnotationNode;
import kalang.compiler.ast.ArrayLengthExpr;
import kalang.compiler.ast.AssignExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.BinaryExpr;
import kalang.compiler.ast.BlockStmt;
import kalang.compiler.ast.BreakStmt;
import kalang.compiler.ast.CastExpr;
import kalang.compiler.ast.CatchBlock;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ClassReference;
import kalang.compiler.ast.CompareExpr;
import kalang.compiler.ast.ConstExpr;
import kalang.compiler.ast.ContinueStmt;
import kalang.compiler.ast.ElementExpr;
import kalang.compiler.ast.ErrorousExpr;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.ExprStmt;
import kalang.compiler.ast.FieldExpr;
import kalang.compiler.ast.FieldNode;
import kalang.compiler.ast.IfStmt;
import kalang.compiler.ast.IncrementExpr;
import kalang.compiler.ast.InstanceOfExpr;
import kalang.compiler.ast.InvocationExpr;
import kalang.compiler.ast.LocalVarNode;
import kalang.compiler.ast.LogicExpr;
import kalang.compiler.ast.LoopStmt;
import kalang.compiler.ast.MathExpr;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.MultiStmt;
import kalang.compiler.ast.MultiStmtExpr;
import kalang.compiler.ast.NewArrayExpr;
import kalang.compiler.ast.NewObjectExpr;
import kalang.compiler.ast.ObjectFieldExpr;
import kalang.compiler.ast.ObjectInvokeExpr;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.PrimitiveCastExpr;
import kalang.compiler.ast.ReturnStmt;
import kalang.compiler.ast.Statement;
import kalang.compiler.ast.StaticFieldExpr;
import kalang.compiler.ast.StaticInvokeExpr;
import kalang.compiler.ast.StoreArrayElementExpr;
import kalang.compiler.ast.SuperExpr;
import kalang.compiler.ast.ThisExpr;
import kalang.compiler.ast.ThrowStmt;
import kalang.compiler.ast.TryStmt;
import kalang.compiler.ast.UnaryExpr;
import kalang.compiler.ast.UnknownFieldExpr;
import kalang.compiler.ast.UnknownInvocationExpr;
import kalang.compiler.ast.VarDeclStmt;
import kalang.compiler.ast.VarExpr;
import kalang.compiler.ast.VarObject;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.CodeGenerator;
import kalang.compiler.compile.codegen.CatchContext;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.PrimitiveType;
import kalang.compiler.core.Types;
import kalang.compiler.core.VarTable;
import kalang.compiler.core.WildcardType;
import kalang.compiler.exception.Exceptions;
import kalang.compiler.tool.OutputManager;
import kalang.compiler.util.AstUtil;
import kalang.compiler.util.InterfaceUtil;
import kalang.compiler.util.MethodUtil;
import kalang.compiler.util.ModifierUtil;
import kalang.compiler.util.NameUtil;
import kalang.compiler.util.Parameters;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Ast2Class
extends AbstractAstVisitor<Object>
implements CodeGenerator {
    private static Logger LOG = Logger.getLogger(Ast2Class.class.getName());
    private ClassWriter classWriter;
    private MethodVisitor md;
    private OutputManager outputManager;
    private Map<Integer, Label> lineLabels = new HashMap<Integer, Label>();
    private Map<VarObject, Integer> varIds = new HashMap<VarObject, Integer>();
    private Stack<Integer> varStartIndexOfFrame = new Stack();
    private Map<VarObject, Label> varStartLabels = new HashMap<VarObject, Label>();
    private VarTable<Integer, LocalVarNode> varTables = new VarTable();
    private int varIdCounter = 0;
    private Stack<Label> breakLabels = new Stack();
    private Stack<Label> continueLabels = new Stack();
    private Stack<CatchContext> catchContextStack = new Stack();
    private static final int T_I = 0;
    private static final int T_L = 1;
    private static final int T_F = 2;
    private static final int T_D = 3;
    private static final int T_A = 4;
    private ClassNode clazz;
    private String classInternalName;

    public Ast2Class(OutputManager outputManager) {
        this.outputManager = outputManager;
    }

    private int getT(kalang.compiler.core.Type type) {
        int t = type.equals(Types.INT_TYPE) || type.equals(Types.BOOLEAN_TYPE) || type.equals(Types.CHAR_TYPE) || type.equals(Types.BYTE_TYPE) || type.equals(Types.SHORT_TYPE) ? 0 : (type.equals(Types.LONG_TYPE) ? 1 : (type.equals(Types.FLOAT_TYPE) ? 2 : (type.equals(Types.DOUBLE_TYPE) ? 3 : 4)));
        return t;
    }

    @Nullable
    private String classSignature(ClassNode c) {
        GenericType[] genericTypes = c.getGenericTypes();
        if (genericTypes == null || genericTypes.length == 0) {
            return null;
        }
        String gnrTypeStr = "";
        for (GenericType t : genericTypes) {
            gnrTypeStr = gnrTypeStr + t.getName() + ":Ljava/lang/Object;";
        }
        String superTypeStr = "";
        if (c.getSuperType() != null) {
            superTypeStr = superTypeStr + this.typeSignature(c.getSuperType());
        }
        for (ObjectType itf : c.getInterfaces()) {
            superTypeStr = superTypeStr + this.typeSignature(itf);
        }
        return "<" + gnrTypeStr + ">" + superTypeStr;
    }

    private String methodSignature(MethodNode m) {
        String ptype = "";
        for (ParameterNode p : m.getParameters()) {
            ptype = ptype + this.typeSignature(p.getType());
        }
        return "(" + ptype + ")" + this.typeSignature(m.getType());
    }

    @Nullable
    private String typeSignature(kalang.compiler.core.Type type) {
        if (type instanceof GenericType) {
            return "T" + type.getName() + ";";
        }
        if (type instanceof ClassType) {
            ClassType pt = (ClassType)type;
            String ptypes = "";
            for (kalang.compiler.core.Type p : pt.getTypeArguments()) {
                ptypes = ptypes + this.typeSignature(p);
            }
            if (!ptypes.isEmpty()) {
                ptypes = "<" + ptypes + ">";
            }
            return "L" + pt.getClassNode().name.replace('.', '/') + ptypes + ";";
        }
        if (type instanceof PrimitiveType) {
            return this.getTypeDescriptor(type);
        }
        if (type instanceof ArrayType) {
            return "[" + this.typeSignature(((ArrayType)type).getComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            kalang.compiler.core.Type[] lbs = wt.getLowerBounds();
            kalang.compiler.core.Type[] ubs = wt.getUpperBounds();
            if (lbs.length > 0) {
                return "-" + this.typeSignature(lbs[0]);
            }
            if (ubs.length > 0) {
                return "+" + this.typeSignature(ubs[0]);
            }
            return "*";
        }
        throw Exceptions.unsupportedTypeException(type);
    }

    private String internalName(String className) {
        return className.replace(".", "/");
    }

    private String[] internalNames(String[] names) {
        String[] inames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            inames[i] = this.internalName(names[i]);
        }
        return inames;
    }

    protected String getNullableAnnotation(ObjectType type) {
        NullableKind nullable = type.getNullable();
        if (nullable == NullableKind.NONNULL) {
            return "kalang.annotation.Nonnull";
        }
        if (nullable == NullableKind.NULLABLE) {
            return "kalang.annotation.Nullable";
        }
        return null;
    }

    protected void annotationNullable(Object obj, ObjectType type) {
        String annotation = this.getNullableAnnotation(type);
        if (annotation != null) {
            try {
                this.annotation(obj, new AnnotationNode(AstLoader.BASE_AST_LOADER.loadAst(annotation)));
            }
            catch (AstNotFoundException ex) {
                throw Exceptions.missingRuntimeClass(ex.getMessage());
            }
        }
    }

    protected void annotation(Object obj, AnnotationNode ... annotations) {
        for (AnnotationNode an : annotations) {
            AnnotationVisitor av;
            String desc = this.getTypeDescriptor(Types.getClassType(an.getAnnotationType()));
            boolean isVisible = true;
            if (obj instanceof ClassWriter) {
                av = ((ClassWriter)obj).visitAnnotation(desc, isVisible);
            } else if (obj instanceof MethodVisitor) {
                av = ((MethodVisitor)obj).visitAnnotation(desc, isVisible);
            } else {
                throw Exceptions.unsupportedTypeException(obj);
            }
            for (String v : an.values.keySet()) {
                Object javaConst = this.getJavaConst(an.values.get(v));
                av.visit(v, javaConst);
            }
        }
    }

    @Override
    public Object visitClassNode(ClassNode node) {
        ClassWriter oldClassWriter;
        String oldClassInternalName;
        ClassNode oldClass;
        block22: {
            oldClass = this.clazz;
            this.clazz = node;
            oldClassInternalName = this.classInternalName;
            this.classInternalName = this.internalName(this.clazz);
            oldClassWriter = this.classWriter;
            this.classWriter = new ClassWriter(2);
            this.annotation(this.classWriter, this.clazz.getAnnotations());
            String parentName = "java.lang.Object";
            ObjectType superType = node.getSuperType();
            if (superType != null) {
                parentName = superType.getName();
            }
            String[] interfaces = null;
            if (node.getInterfaces().length > 0) {
                interfaces = this.internalName(node.getInterfaces());
            }
            int access = node.modifier;
            this.classWriter.visit(50, access, this.internalName(node.name), this.classSignature(node), this.internalName(parentName), interfaces);
            String fileName = node.fileName;
            if (fileName != null && !fileName.isEmpty()) {
                this.classWriter.visitSource(fileName, null);
            }
            this.visitChildren(node);
            Map<MethodDescriptor, MethodNode> implementationMap = InterfaceUtil.getImplementationMap(node);
            for (Map.Entry<MethodDescriptor, MethodNode> e : implementationMap.entrySet()) {
                MethodDescriptor interfaceMethod = e.getKey();
                MethodNode implementedMethod = e.getValue();
                if (implementedMethod == null) continue;
                this.createInterfaceBridgeMethodIfNeed(interfaceMethod.getMethodNode(), implementedMethod);
            }
            if (!node.staticInitStmts.isEmpty()) {
                this.md = this.classWriter.visitMethod(8, "<clinit>", "()V", null, null);
                this.visitAll(node.staticInitStmts);
                this.md.visitInsn(177);
                this.md.visitMaxs(1, 1);
            }
            if (node.enclosingClass != null) {
                this.classWriter.visitInnerClass(this.internalName(node), this.internalName(node.enclosingClass), NameUtil.getSimpleClassName(node.name), node.modifier);
            }
            for (ClassNode ic : node.classes) {
                this.classWriter.visitInnerClass(this.internalName(ic), this.internalName(node), NameUtil.getSimpleClassName(ic.name), ic.modifier);
            }
            this.classWriter.visitEnd();
            if (this.outputManager != null) {
                try (OutputStream os = this.outputManager.createOutputStream(node.name);){
                    os.write(this.classWriter.toByteArray());
                    break block22;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            LOG.log(Level.WARNING, "outputManager is null");
        }
        this.clazz = oldClass;
        this.classInternalName = oldClassInternalName;
        this.classWriter = oldClassWriter;
        return null;
    }

    @Override
    public Object visitMethodNode(MethodNode node) {
        int access = node.getModifier();
        this.md = this.classWriter.visitMethod(access, this.internalName(node.getName()), this.getMethodDescriptor(node), this.methodSignature(node), this.internalName(node.getExceptionTypes()));
        if (node.getType() instanceof ObjectType) {
            this.annotationNullable(this.md, (ObjectType)node.getType());
        }
        this.annotation(this.md, node.getAnnotations());
        Label methodStartLabel = new Label();
        Label methodEndLabel = new Label();
        this.varIdCounter = AstUtil.isStatic(node.getModifier()) ? 0 : 1;
        BlockStmt body = node.getBody();
        ParameterNode[] parameters = node.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            String nullableAnnotation;
            ParameterNode p = parameters[i];
            this.visit(p);
            if (!(p.getType() instanceof ObjectType) || (nullableAnnotation = this.getNullableAnnotation((ObjectType)p.getType())) == null || !nullableAnnotation.isEmpty()) continue;
            this.md.visitParameterAnnotation(i, this.getClassDescriptor(nullableAnnotation), true).visitEnd();
        }
        this.md.visitLabel(methodStartLabel);
        if (body != null) {
            this.visit(body);
            if (node.getType().equals(Types.VOID_TYPE)) {
                this.md.visitInsn(177);
            }
            this.md.visitLabel(methodEndLabel);
            try {
                this.md.visitMaxs(0, 0);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        this.md.visitEnd();
        return null;
    }

    private void newFrame() {
        this.varStartIndexOfFrame.push(this.varIdCounter);
        this.varTables = this.varTables.newStack();
    }

    private void popFrame() {
        int startVarIdx;
        for (LocalVarNode v : this.varTables.values()) {
            this.destroyLocalVarNode(v);
        }
        this.varIdCounter = startVarIdx = this.varStartIndexOfFrame.pop().intValue();
        this.varTables = this.varTables.popStack();
    }

    private int declareNewVar(kalang.compiler.core.Type type) {
        int vid = this.varIdCounter;
        int vSize = this.asmType(type).getSize();
        this.varIdCounter += vSize;
        return vid;
    }

    private void declareNewVar(VarObject vo) {
        int vid = this.varIdCounter;
        int vSize = this.asmType(vo.getType()).getSize();
        if (vSize == 0) {
            throw Exceptions.unexceptedException("");
        }
        this.varIdCounter += vSize;
        this.varIds.put(vo, vid);
        Label startLabel = new Label();
        this.md.visitLabel(startLabel);
        this.varStartLabels.put(vo, startLabel);
        if (vo instanceof LocalVarNode) {
            this.varTables.put(vid, (LocalVarNode)vo);
        }
    }

    private void destroyLocalVarNode(LocalVarNode var) {
        Integer vid = this.varIds.get(var);
        Label endLabel = new Label();
        this.md.visitLabel(endLabel);
        this.varIds.remove(var);
        String name = var.getName();
        if (vid != null && name != null && !name.isEmpty()) {
            this.md.visitLocalVariable(name, this.getTypeDescriptor(var.getType()), null, this.varStartLabels.get(var), endLabel, vid.intValue());
        }
    }

    @Override
    public Object visitBlockStmt(BlockStmt node) {
        this.newFrame();
        this.visitChildren(node);
        this.popFrame();
        return null;
    }

    @Override
    public Object visitBreakStmt(BreakStmt node) {
        if (this.breakLabels.isEmpty()) {
            LOG.warning("redundant break statement:" + node.offset);
            return null;
        }
        this.md.visitJumpInsn(167, this.breakLabels.peek());
        return null;
    }

    @Override
    public Object visitContinueStmt(ContinueStmt node) {
        this.md.visitJumpInsn(167, this.continueLabels.peek());
        return null;
    }

    private void pop(kalang.compiler.core.Type type) {
        int size = this.asmType(type).getSize();
        if (size == 1) {
            this.md.visitInsn(87);
        } else if (size == 2) {
            this.md.visitInsn(88);
        } else {
            throw new UnsupportedOperationException("It is unsupported to pop for the type:" + type);
        }
    }

    @Override
    public Object visitExprStmt(ExprStmt node) {
        this.visitChildren(node);
        kalang.compiler.core.Type type = node.getExpr().getType();
        if (type != null && !Types.VOID_TYPE.equals(type)) {
            this.pop(type);
        }
        return null;
    }

    private void ifExpr(boolean jumpOnTrue, ExprNode condition, Label label) {
        if (condition instanceof LogicExpr) {
            String op;
            LogicExpr be = (LogicExpr)condition;
            ExprNode e1 = be.getExpr1();
            ExprNode e2 = be.getExpr2();
            switch (op = be.getOperation()) {
                case "&&": {
                    if (jumpOnTrue) {
                        Label stopLabel = new Label();
                        this.ifExpr(false, e1, stopLabel);
                        this.ifExpr(false, e2, stopLabel);
                        this.md.visitJumpInsn(167, label);
                        this.md.visitLabel(stopLabel);
                        break;
                    }
                    this.ifExpr(false, e1, label);
                    this.ifExpr(false, e2, label);
                    break;
                }
                case "||": {
                    if (jumpOnTrue) {
                        this.ifExpr(true, e1, label);
                        this.ifExpr(true, e2, label);
                        break;
                    }
                    Label stopLabel = new Label();
                    this.ifExpr(true, e1, stopLabel);
                    this.ifExpr(true, e2, stopLabel);
                    this.md.visitJumpInsn(167, label);
                    this.md.visitLabel(stopLabel);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported operation:" + op);
                }
            }
        } else if (condition instanceof CompareExpr) {
            this.ifCompare(jumpOnTrue, ((CompareExpr)condition).getExpr1(), ((CompareExpr)condition).getExpr2(), ((CompareExpr)condition).getOperation(), label);
        } else if (condition instanceof UnaryExpr && ((UnaryExpr)condition).getOperation().equals("!")) {
            this.ifExpr(!jumpOnTrue, ((UnaryExpr)condition).getExpr(), label);
        } else {
            this.visit(condition);
            this.md.visitJumpInsn(jumpOnTrue ? 154 : 153, label);
        }
    }

    @Override
    public Object visitIfStmt(IfStmt node) {
        Label stopLabel = new Label();
        Label falseLabel = new Label();
        ExprNode condition = node.getConditionExpr();
        BlockStmt trueBody = node.getTrueBody();
        BlockStmt falseBody = node.getFalseBody();
        this.ifExpr(false, condition, falseLabel);
        if (trueBody != null) {
            this.visit(trueBody);
        }
        if (falseBody == null) {
            this.md.visitLabel(falseLabel);
        } else {
            this.md.visitJumpInsn(167, stopLabel);
            this.md.visitLabel(falseLabel);
            this.visit(falseBody);
        }
        this.md.visitLabel(stopLabel);
        return null;
    }

    @Override
    public Object visitLoopStmt(LoopStmt node) {
        Label startLabel = new Label();
        Label continueLabel = new Label();
        Label stopLabel = new Label();
        this.continueLabels.push(continueLabel);
        this.breakLabels.push(stopLabel);
        this.md.visitLabel(startLabel);
        if (node.getPreConditionExpr() != null) {
            this.ifExpr(false, node.getPreConditionExpr(), stopLabel);
        }
        this.visit(node.getLoopBody());
        this.md.visitLabel(continueLabel);
        this.visit(node.getUpdateStmt());
        if (node.getPostConditionExpr() != null) {
            this.ifExpr(false, node.getPostConditionExpr(), stopLabel);
        }
        this.md.visitJumpInsn(167, startLabel);
        this.md.visitLabel(stopLabel);
        this.continueLabels.pop();
        this.breakLabels.pop();
        return null;
    }

    @Override
    public Object visitReturnStmt(ReturnStmt node) {
        int lnsn = 177;
        if (node.expr != null) {
            this.visit(node.expr);
            kalang.compiler.core.Type type = node.expr.getType();
            lnsn = this.asmType(type).getOpcode(172);
        }
        Stack<CatchContext> ccStack = new Stack<CatchContext>();
        while (!this.catchContextStack.isEmpty()) {
            CatchContext catchContext = this.catchContextStack.pop();
            ccStack.push(catchContext);
            Statement finallyStmt = catchContext.getFinallyStatement();
            if (finallyStmt == null) continue;
            this.newFrame();
            Label startLabel = new Label();
            Label endLabel = new Label();
            this.md.visitLabel(startLabel);
            this.visit(finallyStmt);
            this.md.visitLabel(endLabel);
            catchContext.addExclude(startLabel, endLabel);
        }
        while (!ccStack.isEmpty()) {
            this.catchContextStack.push((CatchContext)ccStack.pop());
        }
        this.md.visitInsn(lnsn);
        return null;
    }

    @Override
    public Object visitTryStmt(TryStmt node) {
        this.newFrame();
        Label tryStartLabel = new Label();
        Label tryEndLabel = new Label();
        Label exitLabel = new Label();
        Label finallyStartLabel = new Label();
        BlockStmt execStmt = node.getExecStmt();
        BlockStmt finallyStmt = node.getFinallyStmt();
        boolean hasFinallyStmt = finallyStmt != null && !finallyStmt.statements.isEmpty();
        CatchContext catchContextOfTry = new CatchContext(tryStartLabel, tryEndLabel, finallyStmt);
        this.catchContextStack.push(catchContextOfTry);
        this.md.visitLabel(tryStartLabel);
        this.visit(execStmt);
        this.md.visitLabel(tryEndLabel);
        this.popFrame();
        this.catchContextStack.pop();
        if (finallyStmt != null) {
            this.newFrame();
            this.visit(finallyStmt);
            this.popFrame();
        }
        this.md.visitJumpInsn(167, exitLabel);
        Label[] catchLabelsOfTry = catchContextOfTry.getCatchLabels();
        if (node.getCatchStmts() != null) {
            for (CatchBlock s : node.getCatchStmts()) {
                int j;
                this.newFrame();
                Label catchStartLabel = new Label();
                Label catchStopLabel = new Label();
                CatchContext catchContextOfCatch = new CatchContext(catchStartLabel, catchStopLabel, finallyStmt);
                this.catchContextStack.push(catchContextOfCatch);
                this.md.visitLabel(catchStartLabel);
                this.visit(s);
                this.md.visitLabel(catchStopLabel);
                this.popFrame();
                this.catchContextStack.pop();
                if (finallyStmt != null) {
                    this.newFrame();
                    this.visit(finallyStmt);
                    this.popFrame();
                }
                this.md.visitJumpInsn(167, exitLabel);
                Label[] catchLabelsOfCatch = catchContextOfCatch.getCatchLabels();
                String type = this.asmType(s.catchVar.getType()).getInternalName();
                for (j = 0; j < catchLabelsOfTry.length; j += 2) {
                    this.md.visitTryCatchBlock(catchLabelsOfTry[j], catchLabelsOfTry[j + 1], catchStartLabel, type);
                }
                if (!hasFinallyStmt) continue;
                for (j = 0; j < catchLabelsOfCatch.length; j += 2) {
                    this.md.visitTryCatchBlock(catchLabelsOfCatch[j], catchLabelsOfCatch[j + 1], finallyStartLabel, null);
                }
            }
        }
        if (hasFinallyStmt) {
            for (int i = 0; i < catchLabelsOfTry.length - 1; i += 2) {
                this.md.visitTryCatchBlock(catchLabelsOfTry[i], catchLabelsOfTry[i + 1], finallyStartLabel, null);
            }
            this.newFrame();
            this.md.visitLabel(finallyStartLabel);
            int exVarId = this.declareNewVar(Types.getRootType());
            this.md.visitVarInsn(58, exVarId);
            this.visit(finallyStmt);
            this.md.visitVarInsn(25, exVarId);
            this.md.visitInsn(191);
            this.popFrame();
        }
        this.md.visitLabel(exitLabel);
        this.md.visitInsn(0);
        return null;
    }

    @Override
    public Object visitCatchBlock(CatchBlock node) {
        this.visit(node.catchVar);
        int exVarId = this.getVarId(node.catchVar);
        this.md.visitVarInsn(58, exVarId);
        this.visit(node.execStmt);
        return null;
    }

    @Override
    public Object visitThrowStmt(ThrowStmt node) {
        this.visit(node.expr);
        this.md.visitInsn(191);
        return null;
    }

    private void assignVarObject(VarObject to, ExprNode from) {
        Type type = this.asmType(to.getType());
        this.visit(from);
        int vid = this.getVarId(to);
        this.md.visitVarInsn(type.getOpcode(54), vid);
    }

    private void assignField(FieldNode fn, ExprNode target, ExprNode expr) {
        int opc = 181;
        if (AstUtil.isStatic(fn.modifier)) {
            opc = 179;
        } else {
            this.visit(target);
        }
        this.visit(expr);
        this.md.visitFieldInsn(opc, this.asmType(Types.getClassType(fn.getClassNode())).getInternalName(), fn.getName(), this.getTypeDescriptor(fn.getType()));
    }

    private void assignField(FieldExpr fieldExpr, ExprNode expr) {
        if (fieldExpr instanceof StaticFieldExpr) {
            this.assignField(fieldExpr.getField().getFieldNode(), null, expr);
        } else if (fieldExpr instanceof ObjectFieldExpr) {
            this.assignField(fieldExpr.getField().getFieldNode(), ((ObjectFieldExpr)fieldExpr).getTarget(), expr);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void astore(ExprNode expr) {
        this.visit(expr);
        Type type = this.asmType(expr.getType());
        this.md.visitInsn(type.getOpcode(79));
    }

    private void assignArrayElement(ExprNode array, ExprNode key, ExprNode value) {
        Parameters.requireNonNull(array);
        Parameters.requireNonNull(key);
        Parameters.requireNonNull(value);
        this.visit(array);
        this.visit(key);
        this.astore(value);
    }

    private void assign(ExprNode to, ExprNode from) {
        if (to instanceof FieldExpr) {
            FieldExpr toField = (FieldExpr)to;
            this.assignField(toField, from);
        } else if (to instanceof VarExpr) {
            this.assignVarObject(((VarExpr)to).getVar(), from);
        } else if (to instanceof ElementExpr) {
            ElementExpr elementExpr = (ElementExpr)to;
            this.assignArrayElement(elementExpr.getArrayExpr(), elementExpr.getIndex(), from);
        } else if (to instanceof ParameterExpr) {
            this.assignVarObject(((ParameterExpr)to).getParameter(), from);
        } else {
            throw new UnknownError("unknown expression:" + to);
        }
    }

    @Override
    public Object visitAssignExpr(AssignExpr node) {
        this.assign(node.getTo(), node.getFrom());
        this.visit(node.getTo());
        return null;
    }

    @Override
    public Object visitBinaryExpr(BinaryExpr node) {
        int op;
        kalang.compiler.core.Type type2;
        ExprNode e1 = node.getExpr1();
        ExprNode e2 = node.getExpr2();
        kalang.compiler.core.Type type1 = e1.getType();
        if (!type1.equals(type2 = e2.getType())) {
            throw new IllegalArgumentException(String.format("invalid types:%s and %s", type1, type2));
        }
        Type at = this.asmType(node.getExpr1().getType());
        switch (node.getOperation()) {
            case "+": {
                op = 96;
                break;
            }
            case "-": {
                op = 100;
                break;
            }
            case "*": {
                op = 104;
                break;
            }
            case "/": {
                op = 108;
                break;
            }
            case "%": {
                op = 112;
                break;
            }
            case "&": {
                op = 126;
                break;
            }
            case "|": {
                op = 128;
                break;
            }
            case "^": {
                op = 130;
                break;
            }
            case "<<": {
                op = 120;
                break;
            }
            case ">>": {
                op = 122;
                break;
            }
            default: {
                Label trueLabel = new Label();
                Label stopLabel = new Label();
                this.ifExpr(true, node, trueLabel);
                this.constFalse();
                this.md.visitJumpInsn(167, stopLabel);
                this.md.visitLabel(trueLabel);
                this.constTrue();
                this.md.visitLabel(stopLabel);
                return null;
            }
        }
        this.visit(e1);
        this.visit(e2);
        this.md.visitInsn(at.getOpcode(op));
        return null;
    }

    protected Object getJavaConst(ConstExpr ce) {
        Object v = ce.getValue();
        if (v == null) {
            return null;
        }
        if (v instanceof ClassReference) {
            return this.asmType(Types.getClassType(((ClassReference)v).getReferencedClassNode()));
        }
        kalang.compiler.core.Type ct = ce.getType();
        if (Types.isNumber(ct) || Types.isBoolean(ct) || Types.isCharType(ct) || ct.equals(Types.getCharClassType()) || ct.equals(Types.getStringClassType())) {
            return ce.getValue();
        }
        throw Exceptions.unsupportedTypeException(ct);
    }

    @Override
    public Object visitConstExpr(ConstExpr node) {
        Object v = this.getJavaConst(node);
        if (v == null) {
            this.md.visitInsn(1);
        } else {
            this.md.visitLdcInsn(v);
        }
        return null;
    }

    @Override
    public Object visitElementExpr(ElementExpr node) {
        this.visit(node.getArrayExpr());
        this.visit(node.getIndex());
        Type t = this.asmType(node.getType());
        this.md.visitInsn(t.getOpcode(46));
        return null;
    }

    @Override
    public Object visitFieldExpr(FieldExpr node) {
        int opc;
        String owner = this.internalName(node.getField().getFieldNode().getClassNode());
        if (node instanceof ObjectFieldExpr) {
            ExprNode target = ((ObjectFieldExpr)node).getTarget();
            this.visit(target);
            opc = 180;
        } else if (node instanceof StaticFieldExpr) {
            opc = 178;
        } else {
            throw new UnsupportedOperationException("unsupported field type:" + node);
        }
        this.md.visitFieldInsn(opc, owner, node.getField().getName(), this.getTypeDescriptor(node.getType()));
        return null;
    }

    @Override
    public Object visitInvocationExpr(InvocationExpr node) {
        String ownerClass;
        int opc;
        MethodDescriptor method = node.getMethod();
        if (node instanceof StaticInvokeExpr) {
            opc = 184;
            ownerClass = this.internalName(((StaticInvokeExpr)node).getInvokeClass().getReferencedClassNode());
        } else if (node instanceof ObjectInvokeExpr) {
            ObjectInvokeExpr oie = (ObjectInvokeExpr)node;
            ObjectType targetType = (ObjectType)oie.getInvokeTarget().getType();
            ownerClass = this.internalName(targetType);
            ExprNode target = oie.getInvokeTarget();
            this.visit(target);
            opc = Modifier.isPrivate(method.getModifier()) || target instanceof SuperExpr || method.getName().equals("<init>") ? 183 : (ModifierUtil.isInterface(targetType.getClassNode().modifier) ? 185 : 182);
        } else {
            throw Exceptions.unsupportedTypeException(node);
        }
        this.visitAll(node.getArguments());
        this.md.visitMethodInsn(opc, ownerClass, method.getName(), this.getMethodDescriptor(method.getMethodNode()));
        String expectedReturnType = this.internalName(method.getReturnType());
        String actualReturnType = this.internalName(method.getMethodNode().getType());
        if (!expectedReturnType.equals(actualReturnType)) {
            this.md.visitTypeInsn(192, expectedReturnType);
        }
        return null;
    }

    @Override
    public Object visitUnaryExpr(UnaryExpr node) {
        kalang.compiler.core.Type exprType = node.getExpr().getType();
        Type t = this.asmType(exprType);
        this.visit(node.getExpr());
        switch (node.getOperation()) {
            case "+": {
                break;
            }
            case "-": {
                this.md.visitInsn(t.getOpcode(116));
                break;
            }
            case "~": {
                this.constX(exprType, -1);
                this.md.visitInsn(t.getOpcode(130));
                break;
            }
            case "!": {
                Label falseLabel = new Label();
                Label stopLabel = new Label();
                this.md.visitJumpInsn(153, falseLabel);
                this.constFalse();
                this.md.visitJumpInsn(167, stopLabel);
                this.md.visitLabel(falseLabel);
                this.constTrue();
                this.md.visitLabel(stopLabel);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported unary operation:" + node.getOperation());
            }
        }
        return null;
    }

    @Override
    public Object visitVarExpr(VarExpr node) {
        this.visitVarObject(node.getVar());
        return null;
    }

    @Override
    public Object visitParameterExpr(ParameterExpr node) {
        this.visitVarObject(node.getParameter());
        return null;
    }

    @Override
    public Object visitCastExpr(CastExpr node) {
        this.visit(node.getExpr());
        this.md.visitTypeInsn(192, this.internalName(node.getToType()));
        return null;
    }

    @Override
    public Object visitNewArrayExpr(NewArrayExpr node) {
        this.visit(node.getSize());
        kalang.compiler.core.Type t = node.getComponentType();
        int opr = -1;
        int op = 188;
        if (t.equals(Types.BOOLEAN_TYPE)) {
            opr = 4;
        } else if (t.equals(Types.CHAR_TYPE)) {
            opr = 5;
        } else if (t.equals(Types.SHORT_TYPE)) {
            opr = 9;
        } else if (t.equals(Types.INT_TYPE)) {
            opr = 10;
        } else if (t.equals(Types.LONG_TYPE)) {
            opr = 11;
        } else if (t.equals(Types.FLOAT_TYPE)) {
            opr = 6;
        } else if (t.equals(Types.DOUBLE_TYPE)) {
            opr = 7;
        } else if (t.equals(Types.BYTE_TYPE)) {
            opr = 8;
        } else {
            op = 189;
        }
        if (op == 188) {
            this.md.visitIntInsn(op, opr);
        } else {
            this.md.visitTypeInsn(189, this.internalName(t));
        }
        return null;
    }

    @Override
    public Object visitThisExpr(ThisExpr node) {
        this.md.visitVarInsn(25, 0);
        return null;
    }

    @Override
    public Object visitMultiStmtExpr(MultiStmtExpr node) {
        this.visitAll(node.getStatements());
        this.visit(node.reference);
        return null;
    }

    private String getTypeDescriptor(kalang.compiler.core.Type[] types) {
        if (types == null) {
            return null;
        }
        if (types.length == 0) {
            return null;
        }
        String ts = "";
        for (kalang.compiler.core.Type t : types) {
            ts = ts + this.getTypeDescriptor(t);
        }
        return ts;
    }

    private String getTypeDescriptor(kalang.compiler.core.Type t) {
        if (t instanceof PrimitiveType) {
            if (t.equals(Types.VOID_TYPE)) {
                return "V";
            }
            if (t.equals(Types.BOOLEAN_TYPE)) {
                return "Z";
            }
            if (t.equals(Types.LONG_TYPE)) {
                return "J";
            }
            if (t.equals(Types.INT_TYPE)) {
                return "I";
            }
            if (t.equals(Types.CHAR_TYPE)) {
                return "C";
            }
            if (t.equals(Types.SHORT_TYPE)) {
                return "S";
            }
            if (t.equals(Types.BYTE_TYPE)) {
                return "B";
            }
            if (t.equals(Types.FLOAT_TYPE)) {
                return "F";
            }
            if (t.equals(Types.DOUBLE_TYPE)) {
                return "D";
            }
            if (t.equals(Types.NULL_TYPE)) {
                return "Ljava/lang/Object;";
            }
            throw Exceptions.unsupportedTypeException(t);
        }
        if (t instanceof ArrayType) {
            return "[" + this.getTypeDescriptor(((ArrayType)t).getComponentType());
        }
        if (t instanceof GenericType) {
            return this.getTypeDescriptor(((GenericType)t).getSuperType());
        }
        if (t instanceof ClassType) {
            return "L" + this.internalName(((ClassType)t).getClassNode().name) + ";";
        }
        if (t instanceof WildcardType) {
            return this.getTypeDescriptor(((WildcardType)t).getSuperType());
        }
        throw Exceptions.unsupportedTypeException(t);
    }

    private String getClassDescriptor(String className) {
        return "L" + this.internalName(className) + ";";
    }

    private String getMethodDescriptor(kalang.compiler.core.Type returnType, kalang.compiler.core.Type[] parameterTypes) {
        String desc = "";
        String retTyp = this.getTypeDescriptor(returnType);
        if (parameterTypes != null) {
            for (kalang.compiler.core.Type t : parameterTypes) {
                desc = desc + this.getTypeDescriptor(t);
            }
        }
        return "(" + desc + ")" + retTyp;
    }

    private String getMethodDescriptor(MethodNode node) {
        return this.getMethodDescriptor(node.getType(), MethodUtil.getParameterTypes(node));
    }

    private Type asmType(kalang.compiler.core.Type type) {
        String typeDesc = this.getTypeDescriptor(type);
        return Type.getType((String)typeDesc);
    }

    private int getVarId(VarObject var) {
        Integer vid = this.varIds.get(var);
        if (vid == null) {
            throw new UnknownError("unknown var:" + var);
        }
        return vid;
    }

    private void visitVarObject(VarObject vo) {
        Type type = this.asmType(vo.getType());
        int vid = this.getVarId(vo);
        this.md.visitVarInsn(type.getOpcode(21), vid);
    }

    @Nonnull
    private String[] internalName(@Nonnull ClassNode[] clazz) {
        String[] names = new String[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            names[i] = this.internalName(clazz[i]);
        }
        return names;
    }

    private String internalName(ClassNode clazz) {
        return this.internalName(Types.getClassType(clazz));
    }

    private String internalName(kalang.compiler.core.Type t) {
        Type asmType = this.asmType(t);
        Objects.requireNonNull(asmType, "couldn't get asm type for " + t);
        try {
            return asmType.getInternalName();
        }
        catch (Exception ex) {
            throw new RuntimeException("couldn't get asm type for " + t);
        }
    }

    private String[] internalName(kalang.compiler.core.Type[] types) {
        String[] ts = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ts[i] = this.internalName(types[i]);
        }
        return ts;
    }

    @Override
    public void generate(ClassNode classNode) {
        this.visitClassNode(classNode);
    }

    @Override
    public Object visitVarDeclStmt(VarDeclStmt node) {
        return this.visitChildren(node);
    }

    private int getPrimitiveCastOpc(kalang.compiler.core.Type fromType, kalang.compiler.core.Type toType) {
        kalang.compiler.core.Type f = fromType;
        kalang.compiler.core.Type tt = toType;
        if (f.equals(Types.INT_TYPE)) {
            if (tt.equals(Types.LONG_TYPE)) {
                return 133;
            }
            if (tt.equals(Types.FLOAT_TYPE)) {
                return 134;
            }
            if (tt.equals(Types.DOUBLE_TYPE)) {
                return 135;
            }
            if (tt.equals(Types.SHORT_TYPE)) {
                return 147;
            }
            if (tt.equals(Types.BYTE_TYPE)) {
                return 145;
            }
            if (tt.equals(Types.CHAR_TYPE)) {
                return 146;
            }
        } else if (f.equals(Types.FLOAT_TYPE)) {
            if (tt.equals(Types.INT_TYPE)) {
                return 139;
            }
            if (tt.equals(Types.LONG_TYPE)) {
                return 140;
            }
            if (tt.equals(Types.DOUBLE_TYPE)) {
                return 141;
            }
        } else if (f.equals(Types.LONG_TYPE)) {
            if (tt.equals(Types.INT_TYPE)) {
                return 136;
            }
            if (tt.equals(Types.FLOAT_TYPE)) {
                return 137;
            }
            if (tt.equals(Types.DOUBLE_TYPE)) {
                return 138;
            }
        } else if (f.equals(Types.DOUBLE_TYPE)) {
            if (tt.equals(Types.INT_TYPE)) {
                return 142;
            }
            if (tt.equals(Types.LONG_TYPE)) {
                return 143;
            }
            if (tt.equals(Types.FLOAT_TYPE)) {
                return 144;
            }
        } else if (f.equals(Types.BYTE_TYPE)) {
            if (tt.equals(Types.SHORT_TYPE)) {
                return 0;
            }
            if (tt.equals(Types.INT_TYPE)) {
                return 0;
            }
            if (tt.equals(Types.LONG_TYPE)) {
                return 133;
            }
            if (tt.equals(Types.FLOAT_TYPE)) {
                return 134;
            }
            if (tt.equals(Types.DOUBLE_TYPE)) {
                return 135;
            }
        } else if (f.equals(Types.CHAR_TYPE) || f.equals(Types.SHORT_TYPE)) {
            if (tt.equals(Types.INT_TYPE)) {
                return 0;
            }
            if (tt.equals(Types.LONG_TYPE)) {
                return 133;
            }
            if (tt.equals(Types.FLOAT_TYPE)) {
                return 134;
            }
            if (tt.equals(Types.DOUBLE_TYPE)) {
                return 135;
            }
        }
        throw Exceptions.unexceptedException("It is unable to cast " + fromType + " to " + toType);
    }

    @Override
    public Object visitPrimitiveCastExpr(PrimitiveCastExpr node) {
        ExprNode expr = node.getExpr();
        this.visit(expr);
        kalang.compiler.core.Type ft = expr.getType();
        PrimitiveType tt = node.getToType();
        int opc = this.getPrimitiveCastOpc(ft, tt);
        if (opc > 0) {
            this.md.visitInsn(opc);
        }
        return null;
    }

    @Override
    public Object visitLocalVarNode(LocalVarNode localVarNode) {
        this.declareNewVar(localVarNode);
        return null;
    }

    @Override
    public Object visitParameterNode(ParameterNode parameterNode) {
        this.md.visitParameter(parameterNode.getName(), parameterNode.modifier);
        this.declareNewVar(parameterNode);
        return null;
    }

    @Override
    public Object visitFieldNode(FieldNode fieldNode) {
        this.classWriter.visitField(fieldNode.modifier, fieldNode.getName(), this.getTypeDescriptor(fieldNode.getType()), null, null);
        return null;
    }

    @Override
    public Object visitNewObjectExpr(NewObjectExpr node) {
        Type t = this.asmType(node.getObjectType());
        this.md.visitTypeInsn(187, t.getInternalName());
        this.md.visitInsn(89);
        this.visitAll(node.getConstructor().getArguments());
        this.md.visitMethodInsn(183, t.getInternalName(), "<init>", this.getMethodDescriptor(node.getConstructor().getMethod().getMethodNode()), false);
        return null;
    }

    private void dupX(kalang.compiler.core.Type type) {
        int size = this.asmType(type).getSize();
        if (size == 1) {
            this.md.visitInsn(89);
        } else if (size == 2) {
            this.md.visitInsn(92);
        } else {
            throw new UnsupportedOperationException("unsupported type:" + type);
        }
    }

    @Override
    public Object visitIncrementExpr(IncrementExpr node) {
        if (!node.isIsPrefix()) {
            this.visit(node.getExpr());
        }
        kalang.compiler.core.Type exprType = node.getExpr().getType();
        ConstExpr ce = this.getConstX(exprType, node.isIsDesc() ? -1 : 1);
        MathExpr be = new MathExpr(node.getExpr(), ce, "+");
        AssignExpr addOne = new AssignExpr(node.getExpr(), be);
        this.visit(addOne);
        this.pop(exprType);
        if (node.isIsPrefix()) {
            this.visit(node.getExpr());
        }
        return null;
    }

    private ConstExpr getConstX(kalang.compiler.core.Type type, int i) {
        Number obj;
        int t = this.getT(type);
        switch (t) {
            case 0: {
                obj = new Integer(i);
                break;
            }
            case 1: {
                obj = new Long(i);
                break;
            }
            case 2: {
                obj = new Float(i);
                break;
            }
            case 3: {
                obj = new Double(i);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported type:" + type);
            }
        }
        return new ConstExpr(obj);
    }

    private void constX(Object x) {
        this.md.visitLdcInsn(x);
    }

    private void constX(kalang.compiler.core.Type type, int i) {
        this.constX(this.getConstX(type, i).getValue());
    }

    @Override
    public Object visit(AstNode node) {
        int lineNum = node.offset.startLine;
        if (lineNum > 0 && (node instanceof Statement || node instanceof ExprNode) && !this.lineLabels.containsKey(lineNum)) {
            Label lb = new Label();
            this.md.visitLabel(lb);
            this.md.visitLineNumber(lineNum, lb);
            this.lineLabels.put(lineNum, lb);
        }
        return super.visit(node);
    }

    @Override
    public Object visitArrayLengthExpr(ArrayLengthExpr node) {
        this.visit(node.getArrayExpr());
        this.md.visitInsn(190);
        return null;
    }

    private void constTrue() {
        this.constX(1);
    }

    private void constFalse() {
        this.constX(0);
    }

    @Override
    public Object visitUnknownFieldExpr(UnknownFieldExpr node) {
        throw new UnsupportedOperationException("BUG:invoking unknown method:" + node.getFieldName());
    }

    @Override
    public Object visitUnknownInvocationExpr(UnknownInvocationExpr node) {
        throw new UnsupportedOperationException("BUG:invoking unknown method:" + node.getMethodName());
    }

    @Override
    public Object visitClassReference(ClassReference node) {
        return null;
    }

    @Override
    public Object visitSuperExpr(SuperExpr node) {
        this.md.visitVarInsn(25, 0);
        return null;
    }

    @Override
    public Object visitErrorousExpr(ErrorousExpr node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object visitInstanceOfExpr(InstanceOfExpr node) {
        this.visit(node.getExpr());
        this.md.visitTypeInsn(193, this.internalName(node.getTarget().getReferencedClassNode()));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ifCompare(boolean jumpOnTrue, ExprNode expr1, ExprNode expr2, String op, Label label) {
        kalang.compiler.core.Type type = expr1.getType();
        this.visit(expr1);
        this.visit(expr2);
        int t = this.getT(type);
        if (0 == t) {
            int opc = -1;
            switch (op) {
                case "==": {
                    opc = jumpOnTrue ? 159 : 160;
                    break;
                }
                case ">": {
                    opc = jumpOnTrue ? 163 : 164;
                    break;
                }
                case ">=": {
                    opc = jumpOnTrue ? 162 : 161;
                    break;
                }
                case "<": {
                    opc = jumpOnTrue ? 161 : 162;
                    break;
                }
                case "<=": {
                    opc = jumpOnTrue ? 164 : 163;
                    break;
                }
                case "!=": {
                    opc = jumpOnTrue ? 160 : 159;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported operation:" + op);
                }
            }
            this.md.visitJumpInsn(opc, label);
            return;
        } else if (4 == t) {
            if (op.equals("==")) {
                this.md.visitJumpInsn(jumpOnTrue ? 165 : 166, label);
                return;
            } else {
                if (!op.equals("!=")) throw new UnsupportedOperationException("It is unsupported to compare object type:" + type);
                this.md.visitJumpInsn(jumpOnTrue ? 166 : 165, label);
            }
            return;
        } else {
            if (1 == t) {
                this.md.visitInsn(148);
            } else if (2 == t) {
                this.md.visitInsn(149);
            } else {
                if (3 != t) throw new UnsupportedOperationException("It is unsupported to compare object type:" + type);
                this.md.visitInsn(151);
            }
            int opc = -1;
            switch (op) {
                case "==": {
                    opc = jumpOnTrue ? 153 : 154;
                    break;
                }
                case ">": {
                    opc = jumpOnTrue ? 157 : 158;
                    break;
                }
                case ">=": {
                    opc = jumpOnTrue ? 156 : 155;
                    break;
                }
                case "<": {
                    opc = jumpOnTrue ? 155 : 156;
                    break;
                }
                case "<=": {
                    opc = jumpOnTrue ? 158 : 157;
                    break;
                }
                case "!=": {
                    opc = jumpOnTrue ? 154 : 153;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported operation:" + op);
                }
            }
            this.md.visitJumpInsn(opc, label);
        }
    }

    @Override
    public Object visitMultiStmt(MultiStmt node) {
        this.visitAll(node.statements);
        return null;
    }

    @Override
    public Object visitStoreArrayElementExpr(StoreArrayElementExpr node) {
        this.md.visitVarInsn(25, this.getVarId(node.getArray()));
        this.visit(node.getIndex());
        this.astore(node.getValueExpr());
        return null;
    }

    private void createInterfaceBridgeMethodIfNeed(MethodNode interfaceMethod, MethodNode implementMethod) {
        ParameterNode[] params;
        String implementDesc;
        String desc = this.getMethodDescriptor(interfaceMethod);
        if (desc.equals(implementDesc = this.getMethodDescriptor(implementMethod))) {
            return;
        }
        int access = interfaceMethod.getModifier() & 0xFFFFFBFF;
        String name = interfaceMethod.getName();
        MethodVisitor methodVisitor = this.classWriter.visitMethod(access, name, desc, this.methodSignature(interfaceMethod), null);
        for (ParameterNode p : params = interfaceMethod.getParameters()) {
            methodVisitor.visitParameter(p.getName(), p.modifier);
        }
        ParameterNode[] implementedParams = implementMethod.getParameters();
        methodVisitor.visitVarInsn(25, 0);
        int varIdx = 1;
        for (int i = 0; i < params.length; ++i) {
            kalang.compiler.core.Type implementedParamType = implementedParams[i].getType();
            kalang.compiler.core.Type interfaceParamType = params[i].getType();
            Type interfaceParamAsmType = this.asmType(interfaceParamType);
            methodVisitor.visitVarInsn(interfaceParamAsmType.getOpcode(21), varIdx);
            if (!implementedParamType.isAssignableFrom(interfaceParamType)) {
                methodVisitor.visitTypeInsn(192, this.internalName(implementedParamType));
            }
            varIdx += interfaceParamAsmType.getSize();
        }
        String owner = this.internalName(implementMethod.getClassNode());
        methodVisitor.visitMethodInsn(182, owner, implementMethod.getName(), implementDesc, false);
        kalang.compiler.core.Type returnType = interfaceMethod.getType();
        if (!Types.VOID_TYPE.equals(returnType)) {
            methodVisitor.visitInsn(this.asmType(returnType).getOpcode(172));
        }
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private String methodSignature(MethodDescriptor m) {
        String ptype = "";
        for (kalang.compiler.core.Type p : m.getParameterTypes()) {
            ptype = ptype + this.typeSignature(p);
        }
        return "(" + ptype + ")" + this.typeSignature(m.getReturnType());
    }
}

