/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.compile.codegen;

import java.util.LinkedList;
import java.util.List;
import kalang.compiler.ast.Statement;
import org.objectweb.asm.Label;

public class CatchContext {
    private final Label startLabel;
    private final Label stopLabel;
    private final Statement finallyStatement;
    private final List<Label> excludeLabels = new LinkedList<Label>();

    public CatchContext(Label startLabel, Label stopLabel, Statement finallyStatement) {
        this.startLabel = startLabel;
        this.stopLabel = stopLabel;
        this.finallyStatement = finallyStatement;
    }

    public void addExclude(Label startLabel, Label stopLabel) {
        this.excludeLabels.add(startLabel);
        this.excludeLabels.add(stopLabel);
    }

    public Label[] getCatchLabels() {
        int size = this.excludeLabels.size();
        Label[] labels = new Label[size + 2];
        for (int i = 1; i < labels.length - 1; ++i) {
            labels[i] = this.excludeLabels.get(i - 1);
        }
        labels[0] = this.startLabel;
        labels[labels.length - 1] = this.stopLabel;
        return labels;
    }

    public Statement getFinallyStatement() {
        return this.finallyStatement;
    }
}

