/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.core;

import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.util.AstUtil;

public class ArrayType
extends ObjectType {
    private Type componentType;

    public ArrayType(Type componentType, NullableKind nullable) {
        super(AstUtil.createArrayAst("java.lang.Object"), nullable);
        this.componentType = componentType;
    }

    @Override
    public String getName() {
        return this.componentType.getName() + "[]";
    }

    public Type getComponentType() {
        return this.componentType;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        if (this.equalAndNullAssignChecked(type)) {
            return true;
        }
        if (!(type instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)type;
        if (!this.nullable.isAssignableFrom(other.getNullable())) {
            return false;
        }
        return this.componentType.isAssignableFrom(other.getComponentType());
    }
}

