/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.PrimitiveType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.core.WildcardType;
import kalang.compiler.exception.Exceptions;

public class ClassType
extends ObjectType {
    Type[] typeArguments;

    protected ClassType(ClassNode clazz, Type[] typeArguments, NullableKind nullable) {
        super(clazz, nullable);
        this.typeArguments = typeArguments;
    }

    public Type[] getTypeArguments() {
        return this.typeArguments;
    }

    public Map<GenericType, Type> getTypeArgumentsMap() {
        ClassNode clz = this.getClassNode();
        GenericType[] gts = clz.getGenericTypes();
        HashMap<GenericType, Type> ret = new HashMap<GenericType, Type>();
        if (this.typeArguments.length > 0) {
            for (int i = 0; i < gts.length; ++i) {
                ret.put(gts[i], this.typeArguments[i]);
            }
        }
        return ret;
    }

    @Override
    public String getDeclarationKey() {
        return this.clazz.name;
    }

    @Override
    public String getName() {
        String suffix;
        Type[] pTypes = this.getTypeArguments();
        ArrayList<String> paramTypes = new ArrayList<String>(pTypes.length);
        for (Type t : pTypes) {
            paramTypes.add(t.getName());
        }
        String string = suffix = paramTypes.isEmpty() ? "" : "<" + String.join((CharSequence)",", paramTypes) + ">";
        if (this.nullable.equals((Object)NullableKind.NULLABLE)) {
            suffix = suffix + "?";
        }
        return this.clazz.name + suffix;
    }

    public boolean equals(Object obj) {
        Object[] otherPts;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassType other = (ClassType)obj;
        if (!Objects.equals(this.clazz, other.clazz)) {
            return false;
        }
        Object[] thisPts = this.getTypeArguments();
        if (!Arrays.deepEquals(thisPts, otherPts = other.getTypeArguments())) {
            return false;
        }
        return this.nullable.equals((Object)other.getNullable());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Arrays.deepHashCode(this.typeArguments);
        return hash;
    }

    private static Type[] parseGenericType(Type[] types, Map<GenericType, Type> genericTypes) {
        Type[] actTypes = new Type[types.length];
        for (int i = 0; i < actTypes.length; ++i) {
            actTypes[i] = ClassType.parseGenericType(types[i], genericTypes);
        }
        return actTypes;
    }

    private static Type parseGenericType(Type type, Map<GenericType, Type> genericTypes) {
        if (type instanceof GenericType) {
            Type actualType = genericTypes.get((GenericType)type);
            return actualType == null ? type : actualType;
        }
        if (type instanceof ClassType) {
            ClassType pt = (ClassType)type;
            Object[] ptTypeArguments = pt.getTypeArguments();
            Object[] parsedTypeArguments = ClassType.parseGenericType((Type[])ptTypeArguments, genericTypes);
            if (Arrays.equals(parsedTypeArguments, ptTypeArguments)) {
                return type;
            }
            return Types.getClassType(pt.getClassNode(), (Type[])parsedTypeArguments);
        }
        if (type instanceof PrimitiveType) {
            return type;
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] ubs = wt.getUpperBounds();
            Type[] lbs = wt.getLowerBounds();
            Type[] parsedUBs = ClassType.parseGenericType(ubs, genericTypes);
            Type[] parsedLBs = ClassType.parseGenericType(lbs, genericTypes);
            return new WildcardType(parsedUBs, parsedLBs);
        }
        if (type instanceof ArrayType) {
            Type ct = ((ArrayType)type).getComponentType();
            Type parsedCt = ClassType.parseGenericType(ct, genericTypes);
            if (parsedCt.equals(ct)) {
                return type;
            }
            return Types.getArrayType(parsedCt, ((ArrayType)type).getNullable());
        }
        Exception ex = new Exception("unknown type:" + type);
        ex.printStackTrace(System.err);
        return type;
    }

    private Type eraseGenericType(Type type) {
        if (type instanceof PrimitiveType) {
            return type;
        }
        if (type instanceof GenericType) {
            GenericType gt = (GenericType)type;
            ObjectType superType = gt.getSuperType();
            if (superType != null) {
                return superType;
            }
            ObjectType[] bs = gt.getInterfaces();
            if (bs.length > 0) {
                return bs[0];
            }
            return Types.getRootType();
        }
        if (type instanceof ClassType) {
            ClassType ct = (ClassType)type;
            Type[] typeArgs = ct.getTypeArguments();
            if (typeArgs.length == 0) {
                return ct;
            }
            return Types.getClassType(ct.getClassNode(), new Type[0]);
        }
        if (type instanceof WildcardType) {
            return this.eraseGenericType(((WildcardType)type).getSuperType());
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            return Types.getArrayType(this.eraseGenericType(at.getComponentType()));
        }
        throw Exceptions.unsupportedTypeException(type);
    }

    @Override
    protected Type parseType(Type type) {
        Map<GenericType, Type> genericTypes = this.getTypeArgumentsMap();
        return genericTypes.isEmpty() && this.clazz.getGenericTypes().length > 0 ? this.eraseGenericType(type) : ClassType.parseGenericType(type, genericTypes);
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        if (super.isAssignableFrom(type)) {
            return true;
        }
        if (type instanceof ClassType) {
            ClassType other = (ClassType)type;
            if (!this.nullable.isAssignableFrom(other.getNullable())) {
                return false;
            }
            if (Types.getFunctionType().equals(type) && Types.getFunctionType().isAssignableFrom(this)) {
                return true;
            }
            ClassNode otherClazz = other.getClassNode();
            if (!this.clazz.equals(otherClazz)) {
                return false;
            }
            GenericType[] gts = this.clazz.getGenericTypes();
            if (gts.length == 0) {
                return true;
            }
            Type[] typeArgs = this.getTypeArguments();
            Type[] otherTypeArgs = other.getTypeArguments();
            if (typeArgs.length == 0 || otherTypeArgs.length == 0) {
                return true;
            }
            if (typeArgs.length != otherTypeArgs.length) {
                return false;
            }
            for (int i = 0; i < typeArgs.length; ++i) {
                WildcardType wt;
                Type a = typeArgs[i];
                Type oa = otherTypeArgs[i];
                if (a.equals(oa) || !(a instanceof WildcardType) || (wt = (WildcardType)a).containsType((ObjectType)oa)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public ObjectType getSuperType() {
        ObjectType superType = super.getSuperType();
        if (superType != null) {
            superType = (ObjectType)this.parseType(superType);
        }
        return superType;
    }

    public ClassType toParameterized(Map<GenericType, Type> genericTypeTypeMap) {
        GenericType[] gts = this.clazz.getGenericTypes();
        Type[] typeArgs = new Type[gts.length];
        for (int i = 0; i < typeArgs.length; ++i) {
            Type aType = genericTypeTypeMap.get(gts[i]);
            typeArgs[i] = aType == null ? gts[i] : aType;
        }
        return Types.getClassType(this.clazz, typeArgs);
    }
}

