/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.core;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.core.ParameterDescriptor;
import kalang.compiler.core.Type;
import kalang.compiler.util.MethodUtil;

public abstract class ExecutableDescriptor {
    protected final Type[] parameterTypes;
    protected final int modifier;
    protected final MethodNode methodNode;
    protected final ParameterDescriptor[] parameterDescriptors;
    protected final Type returnType;
    protected final String name;
    protected final Type[] exceptionTypes;

    public ExecutableDescriptor(MethodNode method, ParameterDescriptor[] parameterDescriptors, Type returnType, Type[] exceptionTypes) {
        this.modifier = method.getModifier();
        this.methodNode = method;
        this.name = method.getName();
        this.parameterDescriptors = parameterDescriptors;
        Type[] ptypes = new Type[parameterDescriptors.length];
        for (int i = 0; i < this.parameterDescriptors.length; ++i) {
            ptypes[i] = parameterDescriptors[i].getType();
        }
        this.parameterTypes = ptypes;
        this.returnType = returnType;
        this.exceptionTypes = exceptionTypes;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int getModifier() {
        return this.modifier;
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclarationKey() {
        return MethodUtil.getDeclarationKey(this.name, this.parameterTypes);
    }

    public String toString() {
        ArrayList<String> params = new ArrayList<String>();
        for (ParameterDescriptor p : this.getParameterDescriptors()) {
            params.add(String.format("%s %s", p.getType(), p.getName()));
        }
        return String.format("%s %s(%s)", Modifier.toString(this.modifier), this.name, String.join((CharSequence)",", params));
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type[] getExceptionTypes() {
        return this.exceptionTypes;
    }
}

