/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.core;

import java.util.Objects;
import javax.annotation.Nullable;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.util.AstUtil;

public class GenericType
extends ObjectType {
    protected String name;

    private static ClassNode getClassNode(String name, @Nullable ObjectType superType, @Nullable ObjectType[] interfaces) {
        return AstUtil.createClassNodeWithInterfaces(name, superType, interfaces);
    }

    public GenericType(String name, ObjectType superType, @Nullable ObjectType[] interfaces, NullableKind nullable) {
        super(GenericType.getClassNode(name, superType, interfaces), nullable);
        Objects.requireNonNull(name);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        ObjectType superType = this.getSuperType();
        Objects.requireNonNull(superType);
        return superType.isAssignableFrom(type);
    }
}

