/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.core;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kalang.annotation.Nullable;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.core.ArrayType;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.ExecutableDescriptor;
import kalang.compiler.core.GenericType;
import kalang.compiler.core.ParameterDescriptor;
import kalang.compiler.core.PrimitiveType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.core.WildcardType;

public class MethodDescriptor
extends ExecutableDescriptor {
    public MethodDescriptor(MethodNode method, ParameterDescriptor[] parameterDescriptors, Type returnType, Type[] exceptionTypes) {
        super(method, parameterDescriptors, returnType, exceptionTypes);
    }

    @Override
    public String toString() {
        ArrayList<String> params = new ArrayList<String>();
        for (ParameterDescriptor p : this.getParameterDescriptors()) {
            params.add(String.format("%s %s", p.getType(), p.getName()));
        }
        return String.format("%s %s %s(%s)", Modifier.toString(this.modifier), this.returnType.toString(), this.name, String.join((CharSequence)",", params));
    }

    public MethodDescriptor toParameterized(Map<GenericType, Type> genericTypeMap, @Nullable Type[] actualArgumentTypes) {
        if (actualArgumentTypes != null && actualArgumentTypes.length > 0) {
            HashMap<GenericType, Type> gtMap = new HashMap<GenericType, Type>(genericTypeMap);
            MethodDescriptor.inferGeneric(this.parameterTypes, actualArgumentTypes, gtMap);
            genericTypeMap = gtMap;
        }
        ParameterDescriptor[] pds = new ParameterDescriptor[this.parameterDescriptors.length];
        for (int i = 0; i < pds.length; ++i) {
            ParameterDescriptor originalPd = this.parameterDescriptors[i];
            pds[i] = new ParameterDescriptor(originalPd.getName(), MethodDescriptor.parseGenericType(originalPd.getType(), genericTypeMap), originalPd.getModifier());
        }
        return new MethodDescriptor(this.methodNode, pds, MethodDescriptor.parseGenericType(this.returnType, genericTypeMap), MethodDescriptor.parseGenericType(this.exceptionTypes, genericTypeMap));
    }

    private static void inferGeneric(Type declaredType, Type actualArgType, Map<GenericType, Type> resultMap) {
        if (declaredType.equals(actualArgType)) {
            return;
        }
        if (declaredType instanceof GenericType) {
            resultMap.put((GenericType)declaredType, actualArgType);
        } else if (declaredType instanceof ClassType && actualArgType instanceof ClassType) {
            ClassType actualPt = (ClassType)actualArgType;
            ClassType declaredPt = (ClassType)declaredType;
            Type[] actualPtArguments = actualPt.getTypeArguments();
            Type[] declaredPtArguments = declaredPt.getTypeArguments();
            MethodDescriptor.inferGeneric(declaredPtArguments, actualPtArguments, resultMap);
        } else if (declaredType instanceof WildcardType && actualArgType instanceof ClassType) {
            WildcardType declWt = (WildcardType)declaredType;
            ClassType actualWt = (ClassType)actualArgType;
            Type[] declUbs = declWt.getUpperBounds();
            Type[] declLbs = declWt.getLowerBounds();
            for (Type ub : declUbs) {
                MethodDescriptor.inferGeneric(ub, actualWt, resultMap);
            }
            for (Type lb : declLbs) {
                MethodDescriptor.inferGeneric(lb, actualWt, resultMap);
            }
        } else if (declaredType instanceof ArrayType && actualArgType instanceof ArrayType) {
            Type declComponentType = ((ArrayType)declaredType).getComponentType();
            Type actualComponentType = ((ArrayType)actualArgType).getComponentType();
            MethodDescriptor.inferGeneric(declComponentType, actualComponentType, resultMap);
        }
    }

    private static void inferGeneric(Type[] declaredTypes, Type[] actualTypes, Map<GenericType, Type> resultMap) {
        int min = Math.min(declaredTypes.length, actualTypes.length);
        for (int i = 0; i < min; ++i) {
            MethodDescriptor.inferGeneric(declaredTypes[i], actualTypes[i], resultMap);
        }
    }

    private static Type parseGenericType(Type type, Map<GenericType, Type> genericTypes) {
        if (type instanceof GenericType) {
            Type actualType = genericTypes.get((GenericType)type);
            return actualType == null ? type : actualType;
        }
        if (type instanceof ClassType) {
            ClassType pt = (ClassType)type;
            Object[] ptTypeArguments = pt.getTypeArguments();
            Object[] parsedTypeArguments = MethodDescriptor.parseGenericType((Type[])ptTypeArguments, genericTypes);
            if (Arrays.equals(parsedTypeArguments, ptTypeArguments)) {
                return type;
            }
            return Types.getClassType(pt.getClassNode(), (Type[])parsedTypeArguments);
        }
        if (type instanceof PrimitiveType) {
            return type;
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] ubs = wt.getUpperBounds();
            Type[] lbs = wt.getLowerBounds();
            Type[] parsedUBs = MethodDescriptor.parseGenericType(ubs, genericTypes);
            Type[] parsedLBs = MethodDescriptor.parseGenericType(lbs, genericTypes);
            return new WildcardType(parsedUBs, parsedLBs);
        }
        if (type instanceof ArrayType) {
            Type ct = ((ArrayType)type).getComponentType();
            Type parsedCt = MethodDescriptor.parseGenericType(ct, genericTypes);
            if (parsedCt.equals(ct)) {
                return type;
            }
            return Types.getArrayType(parsedCt, ((ArrayType)type).getNullable());
        }
        Exception ex = new Exception("unknown type:" + type);
        ex.printStackTrace(System.err);
        return type;
    }

    private static Type[] parseGenericType(Type[] types, Map<GenericType, Type> genericTypes) {
        Type[] actTypes = new Type[types.length];
        for (int i = 0; i < actTypes.length; ++i) {
            actTypes[i] = MethodDescriptor.parseGenericType(types[i], genericTypes);
        }
        return actTypes;
    }
}

