/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.core;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import javax.annotation.Nullable;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.FieldNode;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.core.FieldDescriptor;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.ParameterDescriptor;
import kalang.compiler.core.StandardFieldDescriptor;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.util.AccessUtil;
import kalang.compiler.util.MethodUtil;
import kalang.compiler.util.ModifierUtil;

public abstract class ObjectType
extends Type {
    protected final ClassNode clazz;
    protected NullableKind nullable;

    public ObjectType(ClassNode clazz, NullableKind nullable) {
        this.clazz = clazz;
        this.nullable = nullable;
    }

    @Override
    public String getName() {
        return this.clazz.name;
    }

    public ClassNode getClassNode() {
        return this.clazz;
    }

    public boolean isSubTypeOf(Type targetType) {
        if (targetType instanceof ObjectType) {
            ObjectType[] interfaces;
            ObjectType other = (ObjectType)targetType;
            ObjectType superType = this.getSuperType();
            if (superType != null) {
                if (superType.equals(other)) {
                    return true;
                }
                if (superType.isSubTypeOf(other)) {
                    return true;
                }
            }
            for (ObjectType i : interfaces = this.getInterfaces()) {
                if (i.equals(targetType)) {
                    return true;
                }
                if (!i.isSubTypeOf(targetType)) continue;
                return true;
            }
        }
        return false;
    }

    private ParameterDescriptor[] getParameterDescriptors(MethodNode method) {
        ParameterNode[] pms = method.getParameters();
        Type[] ptypes = this.parseTypes(MethodUtil.getParameterTypes(method));
        ParameterDescriptor[] pds = new ParameterDescriptor[ptypes.length];
        for (int j = 0; j < pds.length; ++j) {
            ParameterNode p = pms[j];
            pds[j] = new ParameterDescriptor(p.getName(), ptypes[j], p.modifier);
        }
        return pds;
    }

    protected Type parseType(Type type) {
        return type;
    }

    protected final Type[] parseTypes(Type[] types) {
        Type[] ret = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            ret[i] = this.parseType(types[i]);
        }
        return ret;
    }

    public MethodDescriptor[] getMethodDescriptors(@Nullable ClassNode caller, boolean includeSuperType, boolean includeInterfaces) {
        return this.getMethodDescriptors(caller, null, includeSuperType, includeInterfaces);
    }

    public MethodDescriptor[] getMethodDescriptors(@Nullable ClassNode caller, @Nullable String name, boolean includeSuperType, boolean includeInterfaces) {
        HashMap<String, MethodDescriptor> descs = new HashMap<String, MethodDescriptor>();
        LinkedList<ObjectType> superList = new LinkedList<ObjectType>();
        if (includeSuperType) {
            ObjectType superType = this.getSuperType();
            if (superType == null && ModifierUtil.isInterface(this.getModifier())) {
                superType = Types.getRootType();
            }
            if (superType != null) {
                superList.add(superType);
            }
        }
        if (includeInterfaces) {
            ObjectType[] itfs = this.getInterfaces();
            superList.addAll(Arrays.asList(itfs));
        }
        for (ObjectType st : superList) {
            MethodDescriptor[] ms;
            for (MethodDescriptor m : ms = st.getMethodDescriptors(caller, name, includeSuperType, includeInterfaces)) {
                descs.put(m.getDeclarationKey(), m);
            }
        }
        MethodNode[] mds = this.clazz.getDeclaredMethodNodes();
        for (int i = 0; i < mds.length; ++i) {
            if (!AccessUtil.isAccessible(mds[i].getModifier(), this.clazz, caller) || name != null && !name.isEmpty() && !name.equals(mds[i].getName())) continue;
            MethodDescriptor md = new MethodDescriptor(mds[i], this.getParameterDescriptors(mds[i]), this.parseType(mds[i].getType()), this.parseTypes(mds[i].getExceptionTypes()));
            descs.put(md.getDeclarationKey(), md);
        }
        return descs.values().toArray(new MethodDescriptor[descs.size()]);
    }

    public MethodDescriptor[] getConstructorDescriptors(@Nullable ClassNode caller) {
        return this.getMethodDescriptors(caller, "<init>", false, false);
    }

    @Nullable
    public FieldDescriptor getFieldDescriptor(ClassNode caller, String name) {
        FieldDescriptor[] fds;
        for (FieldDescriptor f : fds = this.getFieldDescriptors(caller)) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public FieldDescriptor[] getFieldDescriptors(ClassNode caller) {
        FieldNode[] fields = this.clazz.getFields();
        LinkedList<FieldDescriptor> ret = new LinkedList<FieldDescriptor>();
        for (int i = 0; i < fields.length; ++i) {
            FieldNode f = fields[i];
            if (!AccessUtil.isAccessible(f.modifier, this.clazz, caller)) continue;
            ret.add(new StandardFieldDescriptor(f, this.parseType(f.getType())));
        }
        ObjectType superType = this.clazz.getSuperType();
        if (superType != null) {
            FieldDescriptor[] superFields = superType.getFieldDescriptors(caller);
            ret.addAll(Arrays.asList(superFields));
        }
        return ret.toArray(new FieldDescriptor[ret.size()]);
    }

    @Nullable
    public ObjectType getSuperType() {
        return this.clazz.getSuperType();
    }

    public NullableKind getNullable() {
        return this.nullable;
    }

    protected boolean equalAndNullAssignChecked(Type type) {
        if (type.equals(this)) {
            return true;
        }
        if (type.equals(Types.NULL_TYPE)) {
            return this.nullable == NullableKind.NULLABLE || this.nullable == NullableKind.UNKNOWN || Types.getVoidClassType().equals(this);
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        if (this.equalAndNullAssignChecked(type)) {
            return true;
        }
        if (!(type instanceof ObjectType)) {
            return false;
        }
        ObjectType other = (ObjectType)type;
        NullableKind otherNullable = other.getNullable();
        if (!this.nullable.isAssignableFrom(otherNullable)) {
            return false;
        }
        ObjectType superType = other.getSuperType();
        if (superType == null && Modifier.isInterface(other.getModifier())) {
            superType = Types.getRootType();
        }
        if (superType != null && this.isAssignableFrom(superType)) {
            return true;
        }
        for (ObjectType itf : other.getInterfaces()) {
            if (!this.isAssignableFrom(itf)) continue;
            return true;
        }
        return false;
    }

    public ObjectType[] getInterfaces() {
        ObjectType[] itfs = this.clazz.getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            itfs[i] = (ObjectType)this.parseType(itfs[i]);
        }
        return itfs;
    }

    public int getModifier() {
        return this.clazz.modifier;
    }
}

