/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.dependency;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kalang.compiler.dependency.Artifact;
import kalang.compiler.dependency.NoMessageLogger;
import kalang.compiler.dependency.ResolveException;
import kalang.compiler.dependency.ResolveResult;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.StartArtifactDownloadEvent;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;

public class DependencyResolver {
    private final List<String> repositories;

    public DependencyResolver() {
        this.repositories = Collections.EMPTY_LIST;
    }

    public DependencyResolver(List<String> repositories) {
        this.repositories = new LinkedList<String>(repositories);
    }

    public ResolveResult resolve(Artifact[] artifacts) {
        try {
            return this.doResolve(artifacts);
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private ResolveResult doResolve(Artifact[] artifacts) throws IOException, ParseException {
        ArtifactDownloadReport[] reports;
        Message.setDefaultLogger((MessageLogger)new NoMessageLogger());
        IvySettings settings = new IvySettings();
        if (!this.repositories.isEmpty()) {
            int repoSize = this.repositories.size();
            for (int i = 0; i < repoSize; ++i) {
                IBiblioResolver dr = new IBiblioResolver();
                dr.setName("user-repo" + (i + 1));
                dr.setM2compatible(true);
                dr.setRoot(this.repositories.get(i));
                settings.addResolver((org.apache.ivy.plugins.resolver.DependencyResolver)dr);
            }
        }
        settings.loadDefault();
        if (!this.repositories.isEmpty()) {
            settings.setDefaultResolver("user-repo1");
        }
        EventManager eventManager = new EventManager();
        eventManager.addIvyListener(event -> {
            if (event instanceof StartArtifactDownloadEvent) {
                ArtifactOrigin origin = ((StartArtifactDownloadEvent)event).getOrigin();
                System.out.println("Downloading:" + origin.getLocation());
            }
        });
        Collection resolvers = settings.getResolvers();
        for (org.apache.ivy.plugins.resolver.DependencyResolver r : resolvers) {
            if (!(r instanceof AbstractResolver)) continue;
            ((AbstractResolver)r).setEventManager(eventManager);
        }
        Ivy ivy = Ivy.newInstance((IvySettings)settings);
        ResolveOptions ops = new ResolveOptions();
        ops.setConfs(new String[]{"default"});
        ModuleRevisionId[] mrids = new ModuleRevisionId[artifacts.length];
        HashMap<ModuleRevisionId, Artifact> revisionId2Artifact = new HashMap<ModuleRevisionId, Artifact>();
        for (int i = 0; i < artifacts.length; ++i) {
            Artifact art = artifacts[i];
            mrids[i] = ModuleRevisionId.newInstance((String)art.getGroup(), (String)art.getName(), (String)art.getVersion());
            revisionId2Artifact.put(mrids[i], art);
        }
        DefaultModuleDescriptor moduleDescriptor = DefaultModuleDescriptor.newCallerInstance((ModuleRevisionId[])mrids, (boolean)true, (boolean)false);
        ResolveReport res = ivy.resolve((ModuleDescriptor)moduleDescriptor, ops);
        ResolveResult result = new ResolveResult();
        for (ArtifactDownloadReport r : reports = res.getAllArtifactsReports()) {
            result.addLocalFile(r.getLocalFile());
        }
        IvyNode[] uds = res.getUnresolvedDependencies();
        if (uds != null && uds.length > 0) {
            throw new ResolveException("failed to resolve artifact:" + uds[0].getId().toString());
        }
        return result;
    }
}

