/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.function;

import javax.annotation.Nullable;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.type.FunctionClasses;

public class FunctionType
extends ClassType {
    private Type[] parameterTypes;
    private Type returnType;

    public FunctionType(Type returnType, @Nullable Type[] parameterTypes, NullableKind nullable) {
        super(FunctionType.buildClassNode(parameterTypes), FunctionType.buildArgumentTypes(returnType, parameterTypes), nullable);
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        if (super.isAssignableFrom(type)) {
            return true;
        }
        if (!(type instanceof ClassType)) {
            return false;
        }
        ClassType classType = (ClassType)type;
        return classType.equals(Types.requireClassType(Types.FUNCTION_CLASS_NAME));
    }

    private static Type[] buildArgumentTypes(Type returnType, Type[] parameterTypes) {
        int paramCount;
        if (parameterTypes == null) {
            parameterTypes = new Type[]{};
        }
        if ((paramCount = parameterTypes.length) > FunctionClasses.CLASSES.length - 1) {
            throw new IllegalArgumentException("");
        }
        Type[] types = new Type[paramCount + 1];
        types[0] = returnType;
        for (int i = 1; i < types.length; ++i) {
            types[i] = parameterTypes[i - 1];
        }
        return types;
    }

    private static ClassNode buildClassNode(@Nullable Type[] parameterTypes) {
        int pcount;
        int n = pcount = parameterTypes == null ? 0 : parameterTypes.length;
        if (pcount > FunctionClasses.CLASSES.length - 1) {
            throw new IllegalArgumentException("");
        }
        return Types.requireClassType(FunctionClasses.CLASSES[pcount].getName()).getClassNode();
    }
}

