/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kalang.annotation.Nullable;
import kalang.compiler.ast.AssignExpr;
import kalang.compiler.ast.AstNode;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.ExprStmt;
import kalang.compiler.ast.LocalVarNode;
import kalang.compiler.ast.MultiStmtExpr;
import kalang.compiler.ast.Statement;
import kalang.compiler.ast.VarDeclStmt;
import kalang.compiler.ast.VarExpr;
import kalang.compiler.ast.VarObject;
import kalang.compiler.function.FunctionType;

public class LambdaExpr
extends MultiStmtExpr {
    private final VarExpr referenceVarExpr;
    private final Map<String, VarObject> accessibleVarObjects = new HashMap<String, VarObject>();
    private final Statement varDeclStmt;
    private ExprNode initExpr;
    private final LocalVarNode tmpVar;
    private FunctionType functionType;

    public LambdaExpr(LocalVarNode tmpVar, @Nullable FunctionType functionType) {
        super(new LinkedList<Statement>(), new VarExpr(tmpVar));
        this.referenceVarExpr = new VarExpr(tmpVar);
        this.varDeclStmt = new VarDeclStmt(tmpVar);
        this.tmpVar = tmpVar;
        this.functionType = functionType;
    }

    public VarExpr getReferenceExpr() {
        return this.referenceVarExpr;
    }

    public LocalVarNode getReferenceVar() {
        return this.referenceVarExpr.getVar();
    }

    public void setInitExpr(ExprNode initExpr) {
        this.initExpr = initExpr;
    }

    public ExprNode getInitExpr() {
        return this.initExpr;
    }

    public void putAccessibleVarObject(String name, VarObject var) {
        this.accessibleVarObjects.put(name, var);
    }

    @Nullable
    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public Map<String, VarObject> getAccessibleVarObjects() {
        return new HashMap<String, VarObject>(this.accessibleVarObjects);
    }

    @Override
    public List<AstNode> getChildren() {
        LinkedList<AstNode> list = new LinkedList<AstNode>();
        list.addAll(this.getStatements());
        return list;
    }

    @Override
    public List<Statement> getStatements() {
        List<Statement> statements = super.getStatements();
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.add(this.varDeclStmt);
        list.add(new ExprStmt(new AssignExpr(new VarExpr(this.tmpVar), this.initExpr)));
        list.addAll(statements);
        return list;
    }
}

