/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import kalang.compiler.shell.Kalangeditor;

public class Editor
extends JFrame {
    private final Kalangeditor controller;
    private JTextArea codeArea;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextArea logArea;
    private JMenuItem menuExit;
    private JMenuItem menuLargerFont;
    private JMenuItem menuRun;
    private JMenuItem menuSmallerFont;
    private JMenu menuTopFIle;
    private JMenu menuTopRun;
    private JMenu menuTopView;

    public Editor(Kalangeditor controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.codeArea = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.logArea = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.menuTopFIle = new JMenu();
        this.menuExit = new JMenuItem();
        this.menuTopRun = new JMenu();
        this.menuRun = new JMenuItem();
        this.menuTopView = new JMenu();
        this.menuLargerFont = new JMenuItem();
        this.menuSmallerFont = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Kalang Editor");
        this.setLocationByPlatform(true);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(420);
        this.jSplitPane1.setOrientation(0);
        this.codeArea.setColumns(20);
        this.codeArea.setRows(5);
        this.codeArea.setCaretColor(new Color(255, 255, 255));
        this.codeArea.setCursor(new Cursor(2));
        this.codeArea.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane1.setViewportView(this.codeArea);
        this.codeArea.setBackground(Color.BLACK);
        this.codeArea.setForeground(new Color(249, 249, 249));
        this.logArea.setBackground(new Color(18, 18, 18));
        this.logArea.setForeground(new Color(249, 249, 249));
        this.setFontSize(18.0f);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.logArea.setEditable(false);
        this.logArea.setColumns(20);
        this.logArea.setRows(5);
        this.jScrollPane2.setViewportView(this.logArea);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jMenuBar1.setFont(new Font("Dialog", 0, 14));
        this.menuTopFIle.setText("File");
        this.menuExit.setText("Exit");
        this.menuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.menuExitActionPerformed(evt);
            }
        });
        this.menuTopFIle.add(this.menuExit);
        this.jMenuBar1.add(this.menuTopFIle);
        this.menuTopRun.setText("Run");
        this.menuRun.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.menuRun.setText("Run");
        this.menuRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.menuRunActionPerformed(evt);
            }
        });
        this.menuTopRun.add(this.menuRun);
        this.jMenuBar1.add(this.menuTopRun);
        this.menuTopView.setText("View");
        this.menuLargerFont.setAccelerator(KeyStroke.getKeyStroke(76, 3));
        this.menuLargerFont.setText("Larger font");
        this.menuLargerFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.menuLargerFontActionPerformed(evt);
            }
        });
        this.menuTopView.add(this.menuLargerFont);
        this.menuSmallerFont.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.menuSmallerFont.setText("Smaller font");
        this.menuSmallerFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.menuSmallerFontActionPerformed(evt);
            }
        });
        this.menuTopView.add(this.menuSmallerFont);
        this.jMenuBar1.add(this.menuTopView);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 876, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 527, Short.MAX_VALUE));
        this.pack();
    }

    private void menuExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void menuSmallerFontActionPerformed(ActionEvent evt) {
        this.enlargeFontSize(-2);
    }

    private void enlargeFontSize(int increment) {
        this.enlargeFontSize(this.codeArea, increment);
        this.enlargeFontSize(this.logArea, increment);
    }

    private void setFontSize(float newSize) {
        this.setFontSize(this.codeArea, newSize);
        this.setFontSize(this.logArea, newSize);
    }

    private void setFontSize(JTextArea area, float newSize) {
        if (newSize < 8.0f) {
            newSize = 8.0f;
        }
        Font f = area.getFont();
        Font newFont = f.deriveFont(newSize);
        area.setFont(newFont);
    }

    private void enlargeFontSize(JTextArea area, int increment) {
        Font f = area.getFont();
        float newSize = f.getSize() + increment;
        this.setFontSize(area, newSize);
    }

    private void menuLargerFontActionPerformed(ActionEvent evt) {
        this.enlargeFontSize(2);
    }

    private void menuRunActionPerformed(ActionEvent evt) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        System.setErr(ps);
        System.setOut(ps);
        String code = this.codeArea.getText();
        String className = "Code" + new Date().getTime();
        try {
            this.controller.eval(className, code);
        }
        catch (Throwable ex) {
            ex.printStackTrace(ps);
        }
        this.logArea.setText(os.toString());
    }

    public static void main(final Kalangeditor controller) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Editor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Editor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Editor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Editor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Editor(controller).setVisible(true);
            }
        });
    }
}

