/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.java;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.tools.JavaFileObject;
import kalang.compiler.java.MemoryJavaSource;
import kalang.compiler.util.ClassNameUtil;
import org.apache.commons.io.FileUtils;

public class StringJavaSource
extends MemoryJavaSource {
    private final String content;

    public StringJavaSource(String className, String content) {
        super(URI.create(className.replace(".", "/") + ".java"), JavaFileObject.Kind.SOURCE, className);
        this.content = content;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.content;
    }

    public static StringJavaSource loadFromFile(File root, File file) throws IOException {
        String clsName = ClassNameUtil.getClassName(root, file);
        return new StringJavaSource(clsName, FileUtils.readFileToString((File)file, (String)"utf-8"));
    }
}

