/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.script;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kalang.compiler.script.Input;
import kalang.compiler.script.Output;

public class Proc {
    private final Process process;

    public Proc(Process process) throws IOException {
        this.process = process;
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        return this.process.waitFor(timeout, unit);
    }

    public boolean waitFor(long timeout) throws InterruptedException {
        return this.waitFor(timeout, TimeUnit.MILLISECONDS);
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public boolean exitsWith(int exitValue) {
        return this.process.exitValue() == exitValue;
    }

    public void destroy() {
        this.process.destroy();
    }

    public Process destroyForcibly() {
        return this.process.destroyForcibly();
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    public Input input() {
        return new Input(this.process.getOutputStream());
    }

    public Output output() {
        return new Output(this.process.getInputStream());
    }

    public Output error() {
        return new Output(this.process.getErrorStream());
    }

    @Deprecated
    public String out() throws IOException {
        return this.inputStreamToString(this.process.getInputStream(), Charset.defaultCharset().name());
    }

    @Deprecated
    public String err() throws IOException {
        return this.inputStreamToString(this.process.getErrorStream(), Charset.defaultCharset().name());
    }

    private String inputStreamToString(InputStream is, String charset) throws IOException {
        int rlen;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((rlen = is.read(buffer)) > 0) {
            bos.write(buffer, 0, rlen);
        }
        return bos.toString(charset);
    }
}

