/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.shell;

import java.io.File;
import java.io.IOException;
import kalang.compiler.compile.StandardDiagnosisHandler;
import kalang.compiler.shell.ShellBase;
import kalang.compiler.tool.FileSystemCompiler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Kalangc
extends ShellBase {
    public static final String APP_NAME = "kalangc";
    public static final String SYNTAX = "kalangc";

    public static void main(String[] args) {
        System.exit(new Kalangc().run(args));
    }

    @Override
    protected int execute(CommandLine cli) {
        String[] srcs;
        FileSystemCompiler fsc = new FileSystemCompiler();
        StandardDiagnosisHandler diagnosisHandler = StandardDiagnosisHandler.INSTANCE;
        fsc.setDiagnosisHandler(diagnosisHandler);
        fsc.setClassLoader(this.createClassLoader(cli));
        fsc.setConfiguration(this.createConfiguration(cli));
        if (cli.hasOption("sourcepath")) {
            String srcPath = cli.getOptionValue("sourcepath");
            fsc.addSourcePath(new File(srcPath));
        }
        fsc.setOutputDir(new File(cli.getOptionValue("output-dir", ".")));
        File currentDir = new File(".");
        fsc.addSourcePath(currentDir);
        for (String s : srcs = cli.getArgs()) {
            File srcFile = new File(s);
            if (srcFile.isDirectory()) {
                try {
                    fsc.addSourceDir(srcFile);
                    continue;
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                    return 3;
                }
            }
            try {
                fsc.addSource(currentDir, srcFile);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        try {
            fsc.compile();
            return diagnosisHandler.hasError() ? 2 : 0;
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return 3;
        }
    }

    public Kalangc() {
        super("kalangc", "kalangc", Kalangc.createOptions());
    }

    private static Options createOptions() {
        Options ops = new Options();
        ops.addOption("o", "output-dir", true, "output directory");
        return ops;
    }
}

