/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.shell;

import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import kalang.compiler.CompileException;
import kalang.compiler.compile.Configuration;
import kalang.compiler.shell.ShellBase;
import kalang.compiler.tool.KalangShell;
import kalang.compiler.util.ClassExecutor;
import kalang.lang.Script;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Kalangsh
extends ShellBase {
    private static final String APP_NAME = "kalangsh";
    private static final String SYNTAX = "kalangsh [options] FILE [options]";

    public Kalangsh() {
        super(APP_NAME, SYNTAX, Kalangsh.createOptions());
    }

    public static void main(String[] args) {
        System.exit(new Kalangsh().run(args));
    }

    @Override
    protected int execute(CommandLine cli) {
        Configuration config = this.createConfiguration(cli);
        ClassLoader classLoader = this.createClassLoader(cli);
        String[] args = cli.getArgs();
        try {
            Class clazz;
            String[] scriptArgs;
            if (cli.hasOption("code")) {
                String code = cli.getOptionValue("code");
                KalangShell sh = this.createKalangShell(config, classLoader, new StringReader(code));
                scriptArgs = new String[]{};
                clazz = sh.parse("Temp", code, "Tmp.kl");
            } else {
                if (args.length == 0) {
                    this.printUsage();
                    return 1;
                }
                File file = new File(args[0]);
                scriptArgs = new String[args.length - 1];
                if (args.length > 1) {
                    System.arraycopy(args, 1, scriptArgs, 0, scriptArgs.length);
                }
                FileReader fileReader = new FileReader(file);
                KalangShell sh = this.createKalangShell(config, classLoader, fileReader);
                fileReader.close();
                sh.addSourcePath(file.getAbsoluteFile().getParentFile());
                clazz = sh.parse(file);
            }
            if (!cli.hasOption("check")) {
                if (Script.class.isAssignableFrom(clazz)) {
                    Script scriptInstance = (Script)clazz.newInstance();
                    return scriptInstance.run(scriptArgs);
                }
                ClassExecutor.executeMain(clazz, scriptArgs);
            }
            return 0;
        }
        catch (CompileException ex) {
            System.err.println(ex.getMessage());
            return 2;
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            return 4;
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption("c", "code", true, "run code from code option");
        options.addOption(null, "check", false, "don't run,just check");
        return options;
    }
}

