/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.tool;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kalang.compiler.compile.AstLoader;
import kalang.compiler.compile.CodeGenerator;
import kalang.compiler.compile.CompilationUnit;
import kalang.compiler.compile.Configuration;
import kalang.compiler.compile.DiagnosisHandler;
import kalang.compiler.compile.JavaAstLoader;
import kalang.compiler.compile.KalangCompiler;
import kalang.compiler.tool.ClassWriter;
import kalang.compiler.tool.FileSystemOutputManager;
import kalang.compiler.tool.FileSystemSourceLoader;
import kalang.compiler.util.ClassNameUtil;
import org.apache.commons.io.FileUtils;

public class FileSystemCompiler {
    private final Map<String, File> sourceFiles = new HashMap<String, File>();
    private final List<URL> classPaths = new LinkedList<URL>();
    private final List<File> sourcePaths = new LinkedList<File>();
    private AstLoader parentAstLoader = AstLoader.BASE_AST_LOADER;
    private String extension = "class";
    private File outputDir;
    private DiagnosisHandler diagnosisHandler;
    private ClassLoader classLoader = FileSystemCompiler.class.getClassLoader();
    private Configuration configuration = new Configuration();

    public void compile() throws IOException {
        if (this.outputDir == null) {
            throw new IllegalStateException("output diretory is null");
        }
        URLClassLoader pathClassLoader = new URLClassLoader(this.classPaths.toArray(new URL[this.classPaths.size()]), this.classLoader);
        JavaAstLoader astLoader = new JavaAstLoader(this.parentAstLoader, pathClassLoader);
        KalangCompiler compiler = new KalangCompiler(astLoader){

            @Override
            public CodeGenerator createCodeGenerator(CompilationUnit compilationUnit) {
                FileSystemOutputManager om = new FileSystemOutputManager(FileSystemCompiler.this.outputDir, FileSystemCompiler.this.extension);
                return new ClassWriter(om);
            }
        };
        compiler.setConfiguration(this.configuration);
        if (this.diagnosisHandler != null) {
            compiler.setDiagnosisHandler(this.diagnosisHandler);
        }
        for (Map.Entry<String, File> e : this.sourceFiles.entrySet()) {
            String className = e.getKey();
            File file = e.getValue();
            compiler.addSource(className, FileUtils.readFileToString((File)file), file.getName());
        }
        FileSystemSourceLoader sourceLoader = new FileSystemSourceLoader(this.sourcePaths.toArray(new File[this.sourcePaths.size()]), new String[]{"kl", "kalang"});
        compiler.setSourceLoader(sourceLoader);
        compiler.compile();
    }

    public void addSource(File srcDir, File file) throws IOException {
        String className = ClassNameUtil.getClassName(srcDir, file);
        this.sourceFiles.put(className, file);
    }

    public void addSourceDir(File sourceDir) throws IOException {
        Collection files = FileUtils.listFiles((File)sourceDir, (String[])new String[]{"kl"}, (boolean)true);
        for (File f : files) {
            this.addSource(sourceDir, f);
        }
    }

    public void addClassPath(File path) {
        try {
            this.classPaths.add(path.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(FileSystemCompiler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addSourcePath(File path) {
        this.sourcePaths.add(path);
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public DiagnosisHandler getDiagnosisHandler() {
        return this.diagnosisHandler;
    }

    public void setDiagnosisHandler(DiagnosisHandler diagnosisHandler) {
        this.diagnosisHandler = diagnosisHandler;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

