/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.tool;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import kalang.compiler.KalangClassLoader;
import kalang.compiler.compile.Configuration;
import kalang.compiler.exception.Exceptions;
import kalang.compiler.tool.NonScriptFileException;
import kalang.lang.Script;
import org.apache.commons.io.FileUtils;

public class KalangShell {
    private Configuration configuration;
    private ClassLoader parentClassLoader;
    private final List<File> sourcePaths = new LinkedList<File>();

    public KalangShell(Configuration configuration, @Nullable ClassLoader parentClassLoader) {
        this.configuration = configuration;
        this.parentClassLoader = parentClassLoader == null ? KalangShell.class.getClassLoader() : parentClassLoader;
    }

    public KalangShell() {
        this(new Configuration(), null);
    }

    public void addSourcePath(File path) {
        this.sourcePaths.add(path);
    }

    public Class parse(String className, String code, String fileName) {
        KalangClassLoader classLoader = this.createClassLoader();
        return classLoader.parseSource(className, code, fileName);
    }

    public Class parse(File file) throws IOException {
        String className = file.getName().split("\\.")[0];
        return this.parse(className, FileUtils.readFileToString((File)file, (String)this.configuration.getEncoding()), file.getName());
    }

    public Script parseScript(File file) throws IOException {
        String className = file.getName().split("\\.")[0];
        return this.parseScript(className, file);
    }

    public Script parseScript(String className, File file) throws IOException {
        KalangClassLoader classLoader = this.createClassLoader();
        Class clazz = classLoader.parseFile(className, file);
        return this.createScriptInstance(clazz);
    }

    public Script parseScript(String className, String code, String fileName) {
        KalangClassLoader classLoader = this.createClassLoader();
        Class clazz = classLoader.parseSource(className, code, fileName);
        return this.createScriptInstance(clazz);
    }

    private KalangClassLoader createClassLoader() {
        return new KalangClassLoader(this.sourcePaths.toArray(new File[0]), this.configuration, this.parentClassLoader);
    }

    private Script createScriptInstance(Class scriptClass) {
        if (Script.class.isAssignableFrom(scriptClass)) {
            try {
                return (Script)scriptClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw Exceptions.unexceptedException(ex);
            }
        }
        throw new NonScriptFileException();
    }
}

