/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.util;

import java.util.ArrayList;
import java.util.Arrays;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.core.ObjectType;

public class InheritanceUtil {
    public static boolean isSubclassOf(ClassNode childClass, ClassNode parentClass) {
        ObjectType[] interfaces = childClass.getInterfaces();
        ObjectType superType = childClass.getSuperType();
        ArrayList<ObjectType> list = new ArrayList<ObjectType>(interfaces.length + 1);
        list.addAll(Arrays.asList(interfaces));
        if (superType != null) {
            list.add(superType);
        }
        for (ObjectType it : list) {
            ClassNode clz = it.getClassNode();
            if (clz.equals(parentClass)) {
                return true;
            }
            if (!InheritanceUtil.isSubclassOf(clz, parentClass)) continue;
            return true;
        }
        return false;
    }
}

