/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.util;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kalang.compiler.ast.AssignExpr;
import kalang.compiler.ast.BlockStmt;
import kalang.compiler.ast.CastExpr;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.ExprStmt;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.ObjectInvokeExpr;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.ReturnStmt;
import kalang.compiler.ast.ThisExpr;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.MethodDescriptor;
import kalang.compiler.core.ObjectType;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.util.MethodUtil;

public class InterfaceUtil {
    @Deprecated
    public static List<MethodDescriptor> checkAndBuildInterfaceMethods(ClassNode clazz) {
        ObjectType[] interfaces = clazz.getInterfaces();
        LinkedList<MethodDescriptor> unimplements = new LinkedList<MethodDescriptor>();
        for (ObjectType itf : interfaces) {
            unimplements.addAll(InterfaceUtil.checkAndBuildInterfaceMethods(clazz, itf));
        }
        return unimplements;
    }

    @Deprecated
    public static List<MethodDescriptor> checkAndBuildInterfaceMethods(ClassNode clazz, ObjectType interfaceType) {
        MethodDescriptor[] interfaceMethods = interfaceType.getMethodDescriptors(interfaceType.getClassNode(), true, true);
        ClassType clazzType = Types.getClassType(clazz, new Type[0]);
        MethodDescriptor[] clazzMethods = clazzType.getMethodDescriptors(null, true, false);
        LinkedList<MethodDescriptor> unimplements = new LinkedList<MethodDescriptor>();
        for (MethodDescriptor im : interfaceMethods) {
            MethodNode imMethodNode;
            Object[] interfaceMethodParamsTypes;
            String imDeclKey = im.getDeclarationKey();
            MethodDescriptor cm = MethodUtil.getMethodDescriptor(clazzMethods, imDeclKey);
            if (cm == null) {
                if (!Modifier.isAbstract(im.getModifier())) continue;
                unimplements.add(im);
                continue;
            }
            Object[] descriptorParamsTypes = im.getParameterTypes();
            if (Arrays.equals(descriptorParamsTypes, interfaceMethodParamsTypes = MethodUtil.getParameterTypes(imMethodNode = im.getMethodNode()))) continue;
            InterfaceUtil.createBridgeMethod(clazz, imMethodNode.getType(), (Type[])interfaceMethodParamsTypes, cm);
        }
        return unimplements;
    }

    public static Map<MethodDescriptor, MethodNode> getImplementationMap(ClassNode clazz) {
        ObjectType[] interfaces = clazz.getInterfaces();
        HashMap<MethodDescriptor, MethodNode> result = new HashMap<MethodDescriptor, MethodNode>();
        for (ObjectType itf : interfaces) {
            InterfaceUtil.doGetImplementationMap(clazz, itf, result);
        }
        return result;
    }

    private static void doGetImplementationMap(ClassNode clazz, ObjectType interfaceType, Map<MethodDescriptor, MethodNode> map) {
        MethodDescriptor[] interfaceMethods = interfaceType.getMethodDescriptors(null, true, true);
        ClassType clazzType = Types.getClassType(clazz, new Type[0]);
        MethodDescriptor[] clazzMethods = clazzType.getMethodDescriptors(null, true, false);
        MethodDescriptor[] methodDescriptorArray = interfaceMethods;
        int n = methodDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            MethodDescriptor im;
            String imDeclKey = (im = methodDescriptorArray[i]).getDeclarationKey();
            MethodDescriptor cm = MethodUtil.getMethodDescriptor(clazzMethods, imDeclKey);
            map.put(im, cm == null ? null : cm.getMethodNode());
        }
    }

    private static void createBridgeMethod(ClassNode clazz, Type returnType, Type[] paramTypes, MethodDescriptor targetMethod) {
        Type[] oldParamTypes = targetMethod.getParameterTypes();
        MethodNode m = clazz.createMethodNode(returnType, targetMethod.getName(), targetMethod.getModifier());
        ParameterNode[] paramNodes = new ParameterNode[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNodes[i] = m.createParameter(paramTypes[i], "p" + i);
        }
        BlockStmt mb = m.getBody();
        ExprNode[] params = new ExprNode[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!paramTypes[i].equals(oldParamTypes[i])) {
                CastExpr castExpr = new CastExpr(oldParamTypes[i], new ParameterExpr(paramNodes[i]));
                AssignExpr assignExpr = new AssignExpr(new ParameterExpr(paramNodes[i]), castExpr);
                mb.statements.add(new ExprStmt(assignExpr));
            }
            params[i] = new ParameterExpr(paramNodes[i]);
        }
        ObjectInvokeExpr invokeExpr = new ObjectInvokeExpr(new ThisExpr(clazz), targetMethod, params);
        if (!Types.VOID_TYPE.equals(returnType)) {
            mb.statements.add(new ReturnStmt(invokeExpr));
        } else {
            mb.statements.add(new ExprStmt(invokeExpr));
            mb.statements.add(new ReturnStmt());
        }
    }
}

