/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.util;

import kalang.compiler.AmbiguousMethodException;
import kalang.compiler.MethodNotFoundException;
import kalang.compiler.ast.ClassNode;
import kalang.compiler.ast.ExprNode;
import kalang.compiler.ast.MethodNode;
import kalang.compiler.ast.ObjectInvokeExpr;
import kalang.compiler.ast.ParameterExpr;
import kalang.compiler.ast.ParameterNode;
import kalang.compiler.ast.ReturnStmt;
import kalang.compiler.ast.ThisExpr;
import kalang.compiler.core.ClassType;
import kalang.compiler.core.NullableKind;
import kalang.compiler.core.Type;
import kalang.compiler.core.Types;
import kalang.compiler.exception.Exceptions;

public class LambdaUtil {
    public static void createBridgeRunMethod(ClassNode classNode, MethodNode targetMethod, Type[] expectedTypes, int paramCount) {
        ObjectInvokeExpr invokeExpr;
        Type returnType = targetMethod.getType();
        int methodParamCount = targetMethod.getParameters().length;
        Type[] paramTypes = new Type[paramCount];
        System.arraycopy(expectedTypes, 0, paramTypes, 0, Math.min(expectedTypes.length, paramTypes.length));
        for (int j = expectedTypes.length; j < paramCount; ++j) {
            paramTypes[j] = Types.getRootType();
        }
        ClassType funcType = Types.getFunctionType(returnType, paramTypes, NullableKind.NONNULL);
        classNode.addInterface(funcType);
        MethodNode pmethod = classNode.createMethodNode(returnType, "call", 1);
        ParameterNode[] pNodes = new ParameterNode[paramCount];
        for (int j = 0; j < paramCount; ++j) {
            pNodes[j] = pmethod.createParameter(paramTypes[j], "p" + (j + 1));
        }
        ExprNode[] argExprs = new ExprNode[methodParamCount];
        for (int j = 0; j < argExprs.length; ++j) {
            argExprs[j] = new ParameterExpr(pNodes[j]);
        }
        try {
            invokeExpr = ObjectInvokeExpr.create(new ThisExpr(classNode), "call", argExprs, classNode);
        }
        catch (AmbiguousMethodException | MethodNotFoundException ex) {
            throw Exceptions.unexceptedException(ex);
        }
        pmethod.getBody().statements.add(new ReturnStmt(invokeExpr));
    }
}

