/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.util;

import java.lang.reflect.Modifier;
import kalang.compiler.util.InvalidModifierException;

public class ModifierUtil {
    public static int setPrivate(int modifier) {
        return modifier & 0xFFFFFFFE & 0xFFFFFFFB | 2;
    }

    public static int setProtected(int modifier) {
        return modifier & 0xFFFFFFFE & 0xFFFFFFFD | 4;
    }

    public static int setPublic(int modifier) {
        return modifier & 0xFFFFFFFD & 0xFFFFFFFB | 1;
    }

    public static boolean isDefault(int modifier) {
        return Modifier.isPublic(modifier) && !Modifier.isAbstract(modifier);
    }

    public static boolean isInterface(int modifier) {
        return Modifier.isInterface(modifier);
    }

    public static int parse(String modifierString, int defaultAccess) throws InvalidModifierException {
        if (modifierString.isEmpty()) {
            throw new InvalidModifierException("modifier could not be empty");
        }
        int m = 0;
        for (String s : modifierString.split(" ")) {
            m = ModifierUtil.addModifier(m, ModifierUtil.parseSingleModfier(s));
        }
        boolean isPublic = Modifier.isPublic(m);
        boolean isPrivate = Modifier.isPrivate(m);
        boolean isProtected = Modifier.isProtected(m);
        if (!(isPrivate || isProtected || isPublic)) {
            m |= defaultAccess;
        }
        return m;
    }

    public static int parse(String modifierString) throws InvalidModifierException {
        return ModifierUtil.parse(modifierString, 1);
    }

    private static int parseSingleModfier(String s) throws InvalidModifierException {
        switch (s) {
            case "public": {
                return 1;
            }
            case "protected": {
                return 4;
            }
            case "private": {
                return 2;
            }
            case "static": {
                return 8;
            }
            case "final": {
                return 16;
            }
            case "abstract": {
                return 1024;
            }
            case "native": {
                return 256;
            }
            case "synchronized": {
                return 32;
            }
            case "transient": {
                return 128;
            }
            case "volatile": {
                return 64;
            }
        }
        throw new InvalidModifierException("unrecognized modifier:" + s);
    }

    private static int addModifier(int modifiers, int singleModifier) throws InvalidModifierException {
        if ((modifiers & singleModifier) > 0) {
            throw new InvalidModifierException("repeat modifiers:" + Modifier.toString(singleModifier));
        }
        int result = modifiers | singleModifier;
        boolean isPublic = Modifier.isPublic(result);
        boolean isPrivate = Modifier.isPrivate(result);
        boolean isProtected = Modifier.isProtected(result);
        if (isPublic && isPrivate) {
            throw new InvalidModifierException("invalid combination of modifiers:public private");
        }
        if (isPublic && isProtected) {
            throw new InvalidModifierException("invalid combination of modifiers:public protected");
        }
        if (isProtected && isPrivate) {
            throw new InvalidModifierException("invalid combination of modifiers:protected private");
        }
        return result;
    }
}

