/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.util;

public class StringLiteralUtil {
    public static String parse(String literal) {
        char[] cs = literal.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < cs.length) {
            char c;
            if ((c = cs[i++]) == '\\') {
                char nc = cs[i++];
                switch (nc) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        sb.append('\\');
                        --i;
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static long parseLong(String longLiteral) throws NumberFormatException {
        if (longLiteral.startsWith("0x") || longLiteral.startsWith("0X")) {
            return Long.parseLong(longLiteral.substring(2).replace("_", ""), 16);
        }
        if (longLiteral.length() > 1 && longLiteral.startsWith("0")) {
            return Long.parseLong(longLiteral.substring(1).replace("_", ""), 8);
        }
        return Long.parseLong(longLiteral);
    }

    public static Number parseInteger(String longLiteral) {
        if (longLiteral.startsWith("0x") || longLiteral.startsWith("0X")) {
            return StringLiteralUtil.parseIntergerInternal(longLiteral.substring(2).replace("_", ""), 16);
        }
        if (longLiteral.length() > 1 && longLiteral.startsWith("0")) {
            return StringLiteralUtil.parseIntergerInternal(longLiteral.substring(1).replace("_", ""), 8);
        }
        return StringLiteralUtil.parseIntergerInternal(longLiteral, 10);
    }

    public static Number parseFloatPoint(String value) {
        if (value.endsWith("f") || value.endsWith("F")) {
            return Float.valueOf(Float.parseFloat(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("d") || value.endsWith("D")) {
            return Double.parseDouble(value.substring(0, value.length() - 1));
        }
        return Double.parseDouble(value);
    }

    private static Number parseIntergerInternal(String value, int radix) {
        if (value.endsWith("L") || value.endsWith("l")) {
            return Long.parseLong(value.substring(0, value.length() - 1), radix);
        }
        if (value.endsWith("i") || value.endsWith("I")) {
            return Integer.parseInt(value.substring(0, value.length() - 1), radix);
        }
        return Integer.parseInt(value, radix);
    }
}

