/*
 * Decompiled with CFR 0.152.
 */
package kalang.compiler.util;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.Token;

public class TokenNavigator {
    Token[] tokens;
    int caretOffset;
    int maxCaretOffset = -1;
    private final int[] startOffset;
    private int currentTokenIndex = 0;

    public TokenNavigator(@Nonnull List<Token> tokens) {
        this(tokens.toArray(new Token[0]));
    }

    public TokenNavigator(@Nonnull Token[] tokens) {
        this.tokens = tokens;
        this.startOffset = new int[tokens.length];
        if (tokens.length > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                this.startOffset[i] = tokens[i].getStartIndex();
            }
            this.maxCaretOffset = tokens[tokens.length - 1].getStopIndex();
        }
    }

    public int move(int caretOffset) {
        if (caretOffset < 0 || caretOffset > this.maxCaretOffset) {
            throw new IndexOutOfBoundsException();
        }
        this.currentTokenIndex = this.getTokenIndexByCaretOffset(caretOffset);
        int oldCaret = this.caretOffset;
        this.caretOffset = caretOffset;
        return oldCaret;
    }

    protected void nextIndex(Integer channel, int increment) {
        int nextId = -1;
        int newIdx = this.currentTokenIndex;
        while (nextId == -1) {
            if ((newIdx += increment) >= this.tokens.length) {
                throw new IndexOutOfBoundsException("index out of bouds:" + newIdx);
            }
            if (channel != null && !channel.equals(this.tokens[newIdx].getChannel())) continue;
        }
        this.currentTokenIndex = newIdx;
    }

    public void next() {
        this.nextIndex(null, 1);
    }

    public void next(int channel) {
        this.nextIndex(channel, 1);
    }

    public void previous() {
        this.nextIndex(null, -1);
    }

    public void previous(int channel) {
        this.nextIndex(channel, -1);
    }

    public Token getCurrentToken() {
        return this.tokens[this.currentTokenIndex];
    }

    public int getCurrentTokenIndex() {
        return this.currentTokenIndex;
    }

    private int getTokenIndexByCaretOffset(int caretOffset) {
        int idx = Arrays.binarySearch(this.startOffset, caretOffset);
        if (idx < 0 && caretOffset > this.tokens[idx = -idx - 2].getStopIndex()) {
            return -1;
        }
        return idx;
    }

    public boolean hasNext() {
        return this.currentTokenIndex < this.tokens.length - 1;
    }

    public boolean hasPrevious() {
        return this.currentTokenIndex > 0;
    }
}

