/*
 * Decompiled with CFR 0.152.
 */
package site.kason.klex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import site.kason.klex.CharStream;
import site.kason.klex.LexException;
import site.kason.klex.OffsetRange;
import site.kason.klex.TokenFactory;
import site.kason.klex.TokenRule;
import site.kason.klex.dfa.DFA;
import site.kason.klex.dfa.DFASimulator;
import site.kason.klex.nfa.NFA;
import site.kason.klex.util.DFAUtil;

public class Klexer<TOKEN, TOKEN_RULE extends TokenRule> {
    private Map<DFA, TOKEN_RULE> dfa2TokenRule = new HashMap<DFA, TOKEN_RULE>();
    private CharStream charStream;
    private TokenFactory<TOKEN, TOKEN_RULE> tokenFactory;

    public Klexer(CharStream charStream, TOKEN_RULE[] tokenRules, TokenFactory<TOKEN, TOKEN_RULE> tokenFactory) {
        this.charStream = charStream;
        for (int i = 0; i < tokenRules.length; ++i) {
            this.addTokenRule(tokenRules[i]);
        }
        this.tokenFactory = tokenFactory;
    }

    private void addTokenRule(TOKEN_RULE rule) {
        NFA nfa = rule.getNFA();
        if (nfa != null) {
            DFA dfa = DFAUtil.buildFromNFA(nfa);
            this.dfa2TokenRule.put(dfa, rule);
        }
    }

    private boolean hasNextToken() {
        return this.charStream.lookAhead(1) != -1;
    }

    public TOKEN nextToken() throws LexException {
        if (!this.hasNextToken()) {
            return this.tokenFactory.createEOFToken(new OffsetRange(this.charStream.getCurrentOffset(), this.charStream.getCurrentOffset() + 1, this.charStream.getCurrentLine(), this.charStream.getCurrentColumn(), this.charStream.getCurrentLine(), this.charStream.getCurrentColumn() + 1));
        }
        int startOffset = this.charStream.getCurrentOffset();
        int startLine = this.charStream.getCurrentLine();
        int startColumn = this.charStream.getCurrentColumn();
        Set<DFA> dfaList = this.dfa2TokenRule.keySet();
        ArrayList<DFASimulator> nextableSimulators = new ArrayList<DFASimulator>(dfaList.size());
        for (DFA dfa : dfaList) {
            nextableSimulators.add(new DFASimulator(dfa));
        }
        DFASimulator[] simulatorsBuffer = new DFASimulator[nextableSimulators.size()];
        int matchedLen = 0;
        Object matchedRule = null;
        int matchedCharCount = 0;
        while (!nextableSimulators.isEmpty()) {
            int nextableSize = nextableSimulators.size();
            nextableSimulators.toArray(simulatorsBuffer);
            nextableSimulators.clear();
            int ch = this.charStream.lookAhead(++matchedCharCount);
            for (int i = 0; i < nextableSize; ++i) {
                DFASimulator sm = simulatorsBuffer[i];
                sm.next(ch);
                if (!sm.nextable()) continue;
                nextableSimulators.add(sm);
            }
            TOKEN_RULE bestMatchedRule = this.selectBestMatchedTokenRule(simulatorsBuffer, 0, nextableSize);
            if (bestMatchedRule == null) continue;
            matchedRule = bestMatchedRule;
            matchedLen = matchedCharCount;
        }
        if (matchedRule == null) {
            throw new LexException(new OffsetRange(startOffset, startOffset, startLine, startColumn, startLine, startColumn), "unexcepted input");
        }
        int[] matchedChars = this.charStream.consume(matchedLen);
        int stopOffset = this.charStream.getCurrentOffset() - 1;
        int stopLine = this.charStream.getCurrentLine();
        int stopColumn = this.charStream.getCurrentColumn() - 1;
        TOKEN tk = this.tokenFactory.createToken(matchedRule, new OffsetRange(startOffset, stopOffset, startLine, startColumn, stopLine, stopColumn), matchedChars);
        return tk;
    }

    public List<TOKEN> nextTokens() throws LexException {
        LinkedList<TOKEN> resultTokens = new LinkedList<TOKEN>();
        while (this.hasNextToken()) {
            TOKEN token = this.nextToken();
            resultTokens.add(token);
        }
        return resultTokens;
    }

    public int getRecognizedLength() {
        return this.charStream.getCurrentOffset();
    }

    public void skip(int count) {
        this.charStream.consume(count);
    }

    public int getCaret() {
        return this.charStream.getCurrentOffset();
    }

    @Nullable
    private TOKEN_RULE selectBestMatchedTokenRule(DFASimulator[] simulators, int offset, int count) {
        TokenRule result = null;
        for (int i = offset; i < offset + count; ++i) {
            DFASimulator s = simulators[i];
            if (!s.isAccepted()) continue;
            DFA dfa = s.getDFA();
            TokenRule rule = (TokenRule)this.dfa2TokenRule.get(dfa);
            if (result != null && rule.getPriority() >= result.getPriority()) continue;
            result = rule;
        }
        return (TOKEN_RULE)result;
    }
}

