/*
 * Decompiled with CFR 0.152.
 */
package site.kason.klex.dfa;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import site.kason.klex.dfa.DFA;
import site.kason.klex.dfa.DFAState;

public class DFASimulator {
    private DFAState currentState;
    private Set<DFAState> acceptedStates;
    private final DFA dfa;

    public DFASimulator(DFA dfa) {
        this.dfa = dfa;
        this.currentState = dfa.getStartState();
        this.acceptedStates = new HashSet<DFAState>(Arrays.asList(dfa.getAcceptedStates()));
    }

    public void next(int input) {
        this.currentState = this.currentState.getNextState(input);
    }

    public boolean isAccepted() {
        return this.acceptedStates.contains(this.currentState);
    }

    public DFAState getCurrentState() {
        return this.currentState;
    }

    public boolean nextable() {
        return this.currentState != null;
    }

    public DFA getDFA() {
        return this.dfa;
    }
}

