/*
 * Decompiled with CFR 0.152.
 */
package site.kason.klex.nfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import site.kason.klex.nfa.NFAState;

public class NFA {
    private NFAState startState;
    private List<NFAState> acceptedStates;

    public NFA(NFAState startState, List<NFAState> acceptedStates) {
        this.startState = startState;
        this.acceptedStates = acceptedStates;
    }

    public NFAState[] getAcceptedStates() {
        return this.acceptedStates.toArray(new NFAState[this.acceptedStates.size()]);
    }

    public NFAState getStartState() {
        return this.startState;
    }

    public NFA or(NFA nfa2) {
        NFAState newStartState = new NFAState();
        newStartState.pushLambdaClosureState(this.getStartState());
        newStartState.pushLambdaClosureState(nfa2.getStartState());
        NFAState[] acList1 = this.getAcceptedStates();
        NFAState[] acList2 = nfa2.getAcceptedStates();
        ArrayList<NFAState> newAcceptedStates = new ArrayList<NFAState>(acList1.length + acList2.length);
        newAcceptedStates.addAll(Arrays.asList(acList1));
        newAcceptedStates.addAll(Arrays.asList(acList2));
        this.startState = newStartState;
        this.acceptedStates = newAcceptedStates;
        return this;
    }

    public NFA concat(NFA nfa2) {
        NFAState[] accpetedState;
        NFAState newStartState = this.getStartState();
        for (NFAState ac : accpetedState = this.getAcceptedStates()) {
            ac.pushLambdaClosureState(nfa2.getStartState());
        }
        this.startState = newStartState;
        this.acceptedStates = Arrays.asList(nfa2.getAcceptedStates());
        return this;
    }

    public NFA closure() {
        NFAState[] acList;
        for (NFAState s : acList = this.getAcceptedStates()) {
            s.pushLambdaClosureState(this.startState);
            this.startState.pushLambdaClosureState(s);
        }
        return this;
    }
}

