/*
 * Decompiled with CFR 0.152.
 */
package site.kason.klex.nfa;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import site.kason.klex.nfa.NFA;
import site.kason.klex.nfa.NFAState;
import site.kason.klex.util.NFAStateUtil;

public class NFASimulator {
    private final NFA nfa;
    private Set<NFAState> currentStates = new HashSet<NFAState>();
    private final Set<NFAState> nextStates;
    private final Set<NFAState> nfaAcceptedStates;

    public NFASimulator(NFA nfa) {
        this.nfa = nfa;
        this.currentStates.addAll(NFAStateUtil.getLambdaClosureStates(Collections.singleton(nfa.getStartState())));
        this.nfaAcceptedStates = new HashSet<NFAState>(Arrays.asList(nfa.getAcceptedStates()));
        this.nextStates = new HashSet<NFAState>();
    }

    public boolean nextable() {
        return !this.currentStates.isEmpty();
    }

    public void next(int input) {
        if (this.currentStates.isEmpty()) {
            throw new IllegalStateException("Current states is empty.");
        }
        for (NFAState s : this.currentStates) {
            NFAState[] ns = s.getNextStates(input);
            this.nextStates.addAll(Arrays.asList(ns));
        }
        this.currentStates = NFAStateUtil.getLambdaClosureStates(this.nextStates);
        this.nextStates.clear();
    }

    public Set<NFAState> getAcceptedStates() {
        HashSet<NFAState> results = new HashSet<NFAState>();
        for (NFAState s : this.currentStates) {
            if (!this.nfaAcceptedStates.contains(s)) continue;
            results.add(s);
        }
        return results;
    }
}

