/*
 * Decompiled with CFR 0.152.
 */
package site.kason.klex.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import site.kason.klex.dfa.DFA;
import site.kason.klex.dfa.DFAState;
import site.kason.klex.match.Matcher;
import site.kason.klex.nfa.NFA;
import site.kason.klex.nfa.NFAState;
import site.kason.klex.util.NFAStateUtil;

public class DFAUtil {
    public static DFA buildFromNFA(NFA nfa) {
        NFAState startState = nfa.getStartState();
        HashSet<NFAState> nfaStates = new HashSet<NFAState>();
        nfaStates.add(startState);
        HashMap<Set<NFAState>, DFAState> nfaStatesToDFAState = new HashMap<Set<NFAState>, DFAState>();
        NFAState[] acceptedNfaStates = nfa.getAcceptedStates();
        HashSet<DFAState> acceptedDFAStates = new HashSet<DFAState>();
        DFAState dfaState = DFAUtil.getOrCreateDFAState(nfaStates, nfaStatesToDFAState, acceptedNfaStates, acceptedDFAStates);
        return new DFA(dfaState, acceptedDFAStates);
    }

    /*
     * WARNING - void declaration
     */
    private static DFAState getOrCreateDFAState(Set<NFAState> nfaStates, Map<Set<NFAState>, DFAState> nfaStatesToDFAState, NFAState[] acceptedNfaStates, Set<DFAState> acceptedDFAStates) {
        DFAState dfaState = nfaStatesToDFAState.get(nfaStates = NFAStateUtil.getLambdaClosureStates(nfaStates));
        if (dfaState == null) {
            void var7_9;
            dfaState = new DFAState();
            nfaStatesToDFAState.put(nfaStates, dfaState);
            NFAState[] nFAStateArray = acceptedNfaStates;
            int n = nFAStateArray.length;
            boolean bl = false;
            while (var7_9 < n) {
                NFAState s = nFAStateArray[var7_9];
                if (nfaStates.contains(s)) {
                    acceptedDFAStates.add(dfaState);
                    break;
                }
                ++var7_9;
            }
            HashMap nextStatesByMatcher = new HashMap();
            for (NFAState nFAState : nfaStates) {
                for (Map.Entry<Matcher, Set<NFAState>> e : nFAState.getNextStates().entrySet()) {
                    Matcher matcher = e.getKey();
                    HashSet nextStates = (HashSet)nextStatesByMatcher.get(matcher);
                    if (nextStates == null) {
                        nextStates = new HashSet();
                        nextStatesByMatcher.put(matcher, nextStates);
                    }
                    nextStates.addAll(e.getValue());
                }
            }
            for (Map.Entry entry : nextStatesByMatcher.entrySet()) {
                dfaState.pushNextState((Matcher)entry.getKey(), DFAUtil.getOrCreateDFAState((Set)entry.getValue(), nfaStatesToDFAState, acceptedNfaStates, acceptedDFAStates));
            }
        }
        return dfaState;
    }
}

