/*
 * Decompiled with CFR 0.152.
 */
package site.kason.klex.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import site.kason.klex.match.AnyCharMatcher;
import site.kason.klex.match.ExcludeCharMatcher;
import site.kason.klex.match.Matcher;
import site.kason.klex.match.RangeCharMatcher;
import site.kason.klex.nfa.NFA;
import site.kason.klex.nfa.NFAState;

public class NFAUtil {
    public static NFA range(int firstAcceptedChar, int lastAcceptedChar) {
        NFAState startState = new NFAState();
        NFAState acceptedState = new NFAState();
        startState.pushNextState(new RangeCharMatcher(firstAcceptedChar, lastAcceptedChar), acceptedState);
        return new NFA(startState, Arrays.asList(acceptedState));
    }

    public static NFA oneOfString(String ... str) {
        NFA nfa = null;
        for (int i = 0; i < str.length; ++i) {
            NFA theNfa = NFAUtil.ofString(str[i]);
            nfa = nfa == null ? theNfa : nfa.or(theNfa);
        }
        return nfa;
    }

    public static NFA ofString(String str) {
        NFAState startState;
        NFAState currentState = startState = new NFAState();
        int strLen = str.length();
        int offset = 0;
        while (offset < strLen) {
            char nextInput = str.charAt(offset++);
            NFAState nextState = new NFAState();
            currentState.pushNextState(nextInput, nextState);
            currentState = nextState;
        }
        return new NFA(startState, Arrays.asList(currentState));
    }

    public static NFA exclude(int ... excludes) {
        NFAState startState = new NFAState();
        NFAState acceptedState = new NFAState();
        startState.pushNextState(new ExcludeCharMatcher(excludes), acceptedState);
        return new NFA(startState, Arrays.asList(acceptedState));
    }

    public static NFA oneOf(int ... chars) {
        NFAState startState = new NFAState();
        NFAState acceptedState = new NFAState();
        for (int i = 0; i < chars.length; ++i) {
            startState.pushNextState(chars[i], acceptedState);
        }
        return new NFA(startState, Arrays.asList(acceptedState));
    }

    public static NFA anyChar() {
        NFAState startState = new NFAState();
        NFAState acceptedState = new NFAState();
        startState.pushNextState(new AnyCharMatcher(), acceptedState);
        return new NFA(startState, Arrays.asList(acceptedState));
    }

    public static NFA copy(NFA nfa) {
        HashMap<NFAState, NFAState> old2new = new HashMap<NFAState, NFAState>();
        NFAState startState = NFAUtil.getOrCopyState(nfa.getStartState(), old2new);
        LinkedList<NFAState> acceptedStates = new LinkedList<NFAState>();
        for (NFAState s : nfa.getAcceptedStates()) {
            NFAState newACState = (NFAState)old2new.get(s);
            if (newACState == null) continue;
            acceptedStates.add(newACState);
        }
        return new NFA(startState, acceptedStates);
    }

    private static NFAState getOrCopyState(NFAState oldState, Map<NFAState, NFAState> old2new) {
        NFAState newState = old2new.get(oldState);
        if (newState == null) {
            newState = new NFAState();
            old2new.put(oldState, newState);
            for (NFAState ls : oldState.getLambdaClosureStates()) {
                newState.pushLambdaClosureState(NFAUtil.getOrCopyState(ls, old2new));
            }
            for (Map.Entry entry : oldState.getNextStates().entrySet()) {
                for (NFAState s : (Set)entry.getValue()) {
                    newState.pushNextState((Matcher)entry.getKey(), NFAUtil.getOrCopyState(s, old2new));
                }
            }
        }
        return newState;
    }
}

