/*
 * Decompiled with CFR 0.152.
 */
package kamons.string;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kamons.string.InvalidLiteralFormat;

public class LiteralParser {
    private Map<Character, String> escapeMap = new HashMap<Character, String>();

    public static LiteralParser createDefault() {
        LiteralParser p = new LiteralParser();
        p.addEscapeChar('\\', "\\");
        p.addEscapeChar('b', "\b");
        p.addEscapeChar('t', "\t");
        p.addEscapeChar('n', "\n");
        p.addEscapeChar('r', "\r");
        p.addEscapeChar('f', "\f");
        p.addEscapeChar('\"', "\"");
        p.addEscapeChar('\'', "'");
        return p;
    }

    private void addEscapeChar(char ch, String value) {
        this.escapeMap.put(Character.valueOf(ch), value);
    }

    public char[] getSupportedEscapeChars() {
        Set<Character> ks = this.escapeMap.keySet();
        char[] res = new char[ks.size()];
        int i = 0;
        Iterator<Character> iterator = ks.iterator();
        while (iterator.hasNext()) {
            res[i++] = iterator.next().charValue();
        }
        return res;
    }

    public String parse(String literal) {
        char[] chars = literal.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            char c;
            if ((c = chars[i++]) == '\\') {
                char nextChar;
                String value;
                if (i >= chars.length) {
                    throw new InvalidLiteralFormat("illegal end of string literal");
                }
                if ((value = this.escapeMap.get(Character.valueOf(nextChar = chars[i++]))) == null) {
                    throw new InvalidLiteralFormat("illegal escape character \\" + nextChar);
                }
                sb.append(value);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

