/*
 * Decompiled with CFR 0.152.
 */
package site.qiuyuan.library.mvc.exceptionhandle;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.lang.reflect.Method;
import javax.security.auth.login.LoginException;
import org.apache.catalina.connector.ClientAbortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import site.qiuyuan.library.common.exception.QiuyuanException;
import site.qiuyuan.library.common.exception.RemoteMethodException;
import site.qiuyuan.library.common.exception.ServiceException;
import site.qiuyuan.library.common.rest.Result;

@RestControllerAdvice
public class ServiceExceptionHandle {
    private static final Logger log = LoggerFactory.getLogger(ServiceExceptionHandle.class);

    @ExceptionHandler(value={QiuyuanException.class})
    public ResponseEntity<?> handleControllerException(QiuyuanException ex) {
        log.error("\u4e1a\u52a1\u5f02\u5e38:", (Throwable)ex);
        return ResponseEntity.ok().body((Object)Result.fail((int)1, (String)ex.getLocalizedMessage()));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<?> handleControllerException(Exception ex) {
        log.error("\u9884\u6599\u4e4b\u5916\u7684\u5f02\u5e38:", (Throwable)ex);
        return ResponseEntity.ok().body((Object)Result.fail((String)ex.getLocalizedMessage()));
    }

    @ExceptionHandler(value={LoginException.class})
    public ResponseEntity<?> loginException(LoginException ex) {
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)Result.fail((int)-5, (String)"\u6743\u9650\u8ba4\u8bc1\u5931\u8d25"));
    }

    @ExceptionHandler(value={ServiceException.class})
    public ResponseEntity<?> serviceException(ServiceException ex) {
        log.error("\u670d\u52a1\u8c03\u7528\u5f02\u5e38:", (Throwable)ex);
        return ResponseEntity.status((int)500).body((Object)Result.fail((String)ex.getMessage()));
    }

    @ExceptionHandler(value={ClientAbortException.class})
    public ResponseEntity<?> clientAbortException(ClientAbortException ex) {
        log.warn("\u8c03\u7528\u8d85\u65f6\u5bfc\u81f4\u5ba2\u6237\u7aef\u4e2d\u65ad\u94fe\u63a5:", (Throwable)ex);
        return ResponseEntity.ok().build();
    }

    @ExceptionHandler(value={RemoteMethodException.class})
    public ResponseEntity<?> remoteException(RemoteMethodException ex) {
        log.warn("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0ckey:{},\u53c2\u6570:{},\u8fd4\u56de:{}", new Object[]{ex.getMethodKey(), ex.getParam(), ex.getResult()});
        return ResponseEntity.ok((Object)Result.fail((int)2, (String)ex.getMsg()));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<?> requestMethodNotSupport(HttpRequestMethodNotSupportedException e) {
        log.error("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u6cd5:", (Throwable)e);
        return ResponseEntity.ok((Object)Result.fail((String)e.getLocalizedMessage()));
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<?> bindException(BindException e) {
        FieldError fieldError = e.getFieldError();
        if (fieldError == null) {
            return ResponseEntity.ok((Object)Result.fail((String)("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25," + e.getMessage())));
        }
        log.warn("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25,\u5b57\u6bb5\u540d:{},\u503c:{}", (Object)fieldError.getField(), fieldError.getRejectedValue());
        return ResponseEntity.ok((Object)Result.fail((String)("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25,\u5b57\u6bb5\u540d:" + fieldError.getField() + ",\u503c:" + fieldError.getRejectedValue())));
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    public ResponseEntity<?> invalidException(InvalidFormatException e) {
        Object value = e.getValue();
        Class targetType = e.getTargetType();
        log.warn("\u53c2\u6570\u7c7b\u578b\u89e3\u6790\u5931\u8d25\uff0c\u503c:{},\u7c7b\u578b:{}", (Object)value.toString(), (Object)targetType);
        return ResponseEntity.ok((Object)Result.fail((String)(value.toString() + "\u65e0\u6cd5\u8f6c\u6362\u4e3a" + targetType + "\u7c7b\u578b")));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<?> argumentException(MethodArgumentTypeMismatchException e) {
        MethodParameter parameter = e.getParameter();
        Object value = e.getValue();
        Method method = parameter.getMethod();
        log.info("method:{} \u89e3\u6790\u53c2\u6570\u51fa\u9519,\u6240\u5728\u7c7b:{}\uff0c\u53c2\u6570\u540d:{}\uff0c\u503c:{}", new Object[]{method == null ? "" : method.getName(), parameter.getContainingClass().getName(), parameter.getParameterName(), value == null ? null : value.toString()});
        return ResponseEntity.ok((Object)Result.fail((String)e.getLocalizedMessage()));
    }
}

