/*
 * Decompiled with CFR 0.152.
 */
package site.qiuyuan.library.mvc.factory;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class JacksonConverterFactory {
    private ObjectMapper mapper = new ObjectMapper();

    public JacksonConverterFactory() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        this.mapper.setTimeZone(TimeZone.getDefault());
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        this.mapper.enable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS});
    }

    private JacksonConverterFactory useAnnotation(boolean flag) {
        this.mapper.configure(MapperFeature.USE_ANNOTATIONS, flag);
        return this;
    }

    public MappingJackson2HttpMessageConverter build() {
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setObjectMapper(this.mapper);
        return mappingJackson2HttpMessageConverter;
    }
}

