/*
 * Decompiled with CFR 0.152.
 */
package site.sorghum.join.entity;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.lang.func.LambdaUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import site.sorghum.join.aop.EasyJoin;
import site.sorghum.join.aop.JoinResMap;
import site.sorghum.join.exception.JoinAnnoException;
import site.sorghum.join.util.AssertUtil;
import site.sorghum.join.util.InvokeUtil;

public class JoinParam<S, R> {
    String sourceName;
    String valueKey;
    String tableName;
    String uniqueKey;
    String[] field;
    String extraWhere;
    String sql;
    Class<R> targetClass;
    Boolean flat = false;
    Boolean continueJoin = false;
    Integer continueJoinMode = 0;

    public JoinParam<S, R> valueKey(Func1<S, ?> valueKey) {
        this.valueKey = LambdaUtil.getFieldName(valueKey);
        return this;
    }

    public JoinParam<S, R> valueKey(String valueKey) {
        this.valueKey = valueKey;
        return this;
    }

    public JoinParam<S, R> tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public JoinParam<S, R> sourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    public JoinParam<S, R> tableName(Class<?> tableName) {
        String simpleName = StrUtil.toUnderlineCase((CharSequence)tableName.getSimpleName());
        TableName annotation = tableName.getAnnotation(TableName.class);
        if (annotation != null) {
            simpleName = annotation.value();
        }
        this.tableName = simpleName;
        return this;
    }

    public JoinParam<S, R> uniqueKey(Func1<R, ?> uniqueKey) {
        String uniqueFieldName = LambdaUtil.getFieldName(uniqueKey);
        this.uniqueKey = JoinParam.getSqlFieldName(uniqueKey);
        return this;
    }

    public JoinParam<S, R> uniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public JoinParam<S, R> field(String ... field) {
        this.field = field;
        return this;
    }

    @SafeVarargs
    public final JoinParam<S, R> field(Func1<R, ?> ... field) {
        String[] tempField = new String[field.length];
        for (int i = 0; i < field.length; ++i) {
            tempField[i] = JoinParam.getSqlFieldName(field[i]);
        }
        this.field = tempField;
        return this;
    }

    public JoinParam<S, R> extraWhere(String extraWhere) {
        this.extraWhere = extraWhere;
        return this;
    }

    public JoinParam<S, R> sql(String sql) {
        this.sql = sql;
        return this;
    }

    public JoinParam<S, R> targetClass(Class<R> targetClass) {
        this.targetClass = targetClass;
        if (StrUtil.isBlank((CharSequence)this.tableName)) {
            this.tableName(targetClass);
        }
        if (StrUtil.isBlank((CharSequence)this.sourceName)) {
            this.sourceName(StrUtil.lowerFirst((CharSequence)targetClass.getSimpleName()));
        }
        if (StrUtil.isBlank((CharSequence)this.uniqueKey)) {
            this.uniqueKey("id");
        }
        return this;
    }

    private static String getSqlFieldName(Func1<?, ?> func) {
        String returnValue = null;
        String uniqueFieldName = LambdaUtil.getFieldName(func);
        Field valueField = null;
        for (Class realClass = LambdaUtil.getRealClass(func); realClass != null && (valueField = ReflectUtil.getField((Class)realClass, (String)uniqueFieldName)) == null; realClass = realClass.getSuperclass()) {
        }
        AssertUtil.isNull((Object)valueField, "\u672a\u627e\u5230\u5b57\u6bb5" + uniqueFieldName);
        TableField fieldAnnotation = valueField.getAnnotation(TableField.class);
        TableId idAnnotation = valueField.getAnnotation(TableId.class);
        if (idAnnotation == null && fieldAnnotation == null) {
            returnValue = StrUtil.toUnderlineCase((CharSequence)uniqueFieldName);
        }
        if (idAnnotation != null) {
            returnValue = Optional.of(idAnnotation.value()).filter(CharSequenceUtil::isNotBlank).orElse(valueField.getName());
        }
        if (fieldAnnotation != null) {
            returnValue = Optional.of(fieldAnnotation.value()).filter(CharSequenceUtil::isNotBlank).orElse(valueField.getName());
        }
        return returnValue;
    }

    public JoinParam flat(boolean flat) {
        this.flat = flat;
        return this;
    }

    public JoinParam continueJoin(boolean continueJoin) {
        this.continueJoin = continueJoin;
        return this;
    }

    public JoinParam continueJoinMode(Integer continueJoinMode) {
        this.continueJoinMode = continueJoinMode;
        return this;
    }

    public static JoinParam easyJoin2JoinParam(EasyJoin easyJoin, String valueKey) {
        return new JoinParam().sourceName(easyJoin.sourceName()).valueKey(valueKey).tableName(easyJoin.tableName()).uniqueKey(easyJoin.uniqueKey()).field(easyJoin.field()).extraWhere(easyJoin.extraWhere()).sql(easyJoin.sql()).targetClass(easyJoin.targetClass()).flat(easyJoin.flat()).continueJoin(easyJoin.continueJoin()).continueJoinMode(easyJoin.continueJoinMode());
    }

    public static Map<Object, Object> getJoinResMap(Object obj) {
        Class<?> clazz = obj.getClass();
        boolean inject = false;
        Field[] fields = ReflectUtil.getFields(clazz, field -> AnnotationUtil.hasAnnotation((AnnotatedElement)field, JoinResMap.class));
        if (fields.length == 0) {
            throw new JoinAnnoException("EasyJoin target's joinResMap is not exist, please add @JoinResMap annotation", new Object[0]);
        }
        Field joinResMapField = fields[0];
        joinResMapField.setAccessible(true);
        Object value = InvokeUtil.invokeGetter(obj, joinResMapField);
        if (value == null) {
            try {
                value = joinResMapField.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                inject = true;
            }
            catch (Exception ex) {
                throw new JoinAnnoException("EasyJoin target's joinResMap's type can not find a instance", new Object[0]).withCause((Throwable)ex);
            }
        }
        if (inject) {
            InvokeUtil.invokeSetter(obj, joinResMapField, value);
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new JoinAnnoException("EasyJoin target's joinResMap is not a Map, please check @TransitionMap annotation", new Object[0]);
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setValueKey(String valueKey) {
        this.valueKey = valueKey;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public void setField(String[] field) {
        this.field = field;
    }

    public void setExtraWhere(String extraWhere) {
        this.extraWhere = extraWhere;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setTargetClass(Class<R> targetClass) {
        this.targetClass = targetClass;
    }

    public void setFlat(Boolean flat) {
        this.flat = flat;
    }

    public void setContinueJoin(Boolean continueJoin) {
        this.continueJoin = continueJoin;
    }

    public void setContinueJoinMode(Integer continueJoinMode) {
        this.continueJoinMode = continueJoinMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinParam)) {
            return false;
        }
        JoinParam other = (JoinParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$flat = this.getFlat();
        Boolean other$flat = other.getFlat();
        if (this$flat == null ? other$flat != null : !((Object)this$flat).equals(other$flat)) {
            return false;
        }
        Boolean this$continueJoin = this.getContinueJoin();
        Boolean other$continueJoin = other.getContinueJoin();
        if (this$continueJoin == null ? other$continueJoin != null : !((Object)this$continueJoin).equals(other$continueJoin)) {
            return false;
        }
        Integer this$continueJoinMode = this.getContinueJoinMode();
        Integer other$continueJoinMode = other.getContinueJoinMode();
        if (this$continueJoinMode == null ? other$continueJoinMode != null : !((Object)this$continueJoinMode).equals(other$continueJoinMode)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        String this$valueKey = this.getValueKey();
        String other$valueKey = other.getValueKey();
        if (this$valueKey == null ? other$valueKey != null : !this$valueKey.equals(other$valueKey)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$uniqueKey = this.getUniqueKey();
        String other$uniqueKey = other.getUniqueKey();
        if (this$uniqueKey == null ? other$uniqueKey != null : !this$uniqueKey.equals(other$uniqueKey)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getField(), other.getField())) {
            return false;
        }
        String this$extraWhere = this.getExtraWhere();
        String other$extraWhere = other.getExtraWhere();
        if (this$extraWhere == null ? other$extraWhere != null : !this$extraWhere.equals(other$extraWhere)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        Class<R> this$targetClass = this.getTargetClass();
        Class<R> other$targetClass = other.getTargetClass();
        return !(this$targetClass == null ? other$targetClass != null : !this$targetClass.equals(other$targetClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $flat = this.getFlat();
        result = result * 59 + ($flat == null ? 43 : ((Object)$flat).hashCode());
        Boolean $continueJoin = this.getContinueJoin();
        result = result * 59 + ($continueJoin == null ? 43 : ((Object)$continueJoin).hashCode());
        Integer $continueJoinMode = this.getContinueJoinMode();
        result = result * 59 + ($continueJoinMode == null ? 43 : ((Object)$continueJoinMode).hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        String $valueKey = this.getValueKey();
        result = result * 59 + ($valueKey == null ? 43 : $valueKey.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $uniqueKey = this.getUniqueKey();
        result = result * 59 + ($uniqueKey == null ? 43 : $uniqueKey.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getField());
        String $extraWhere = this.getExtraWhere();
        result = result * 59 + ($extraWhere == null ? 43 : $extraWhere.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        Class<R> $targetClass = this.getTargetClass();
        result = result * 59 + ($targetClass == null ? 43 : $targetClass.hashCode());
        return result;
    }

    public String toString() {
        return "JoinParam(sourceName=" + this.getSourceName() + ", valueKey=" + this.getValueKey() + ", tableName=" + this.getTableName() + ", uniqueKey=" + this.getUniqueKey() + ", field=" + Arrays.deepToString(this.getField()) + ", extraWhere=" + this.getExtraWhere() + ", sql=" + this.getSql() + ", targetClass=" + this.getTargetClass() + ", flat=" + this.getFlat() + ", continueJoin=" + this.getContinueJoin() + ", continueJoinMode=" + this.getContinueJoinMode() + ")";
    }

    public JoinParam() {
    }

    public JoinParam(String sourceName, String valueKey, String tableName, String uniqueKey, String[] field, String extraWhere, String sql, Class<R> targetClass, Boolean flat, Boolean continueJoin, Integer continueJoinMode) {
        this.sourceName = sourceName;
        this.valueKey = valueKey;
        this.tableName = tableName;
        this.uniqueKey = uniqueKey;
        this.field = field;
        this.extraWhere = extraWhere;
        this.sql = sql;
        this.targetClass = targetClass;
        this.flat = flat;
        this.continueJoin = continueJoin;
        this.continueJoinMode = continueJoinMode;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getValueKey() {
        return this.valueKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public String[] getField() {
        return this.field;
    }

    public String getExtraWhere() {
        return this.extraWhere;
    }

    public String getSql() {
        return this.sql;
    }

    public Class<R> getTargetClass() {
        return this.targetClass;
    }

    public Boolean getFlat() {
        return this.flat;
    }

    public Boolean getContinueJoin() {
        return this.continueJoin;
    }

    public Integer getContinueJoinMode() {
        return this.continueJoinMode;
    }
}

