/*
 * Decompiled with CFR 0.152.
 */
package site.sorghum.join.operator.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.date.StopWatch;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.noear.wood.DbContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import site.sorghum.join.entity.JoinParam;
import site.sorghum.join.exception.JoinAnnoException;
import site.sorghum.join.operator.JoinOperator;
import site.sorghum.join.operator.JoinService;

@Component
public class JoinOperatorImpl
implements JoinOperator {
    private static final Logger log = LoggerFactory.getLogger(JoinOperatorImpl.class);
    DbContext dbContext;
    TimedCache<String, String> timedCache = CacheUtil.newTimedCache((long)30000L);

    @Autowired
    public void setDbContext(DbContext dbContext) {
        this.dbContext = dbContext;
    }

    private <R> R getOne(String sql, Class<R> clazz, Object ... param) {
        List<R> query = this.getList(sql, clazz, param);
        if (query.size() > 0) {
            return query.get(0);
        }
        return null;
    }

    private synchronized <R> List<R> getList(String sql, Class<R> clazz, Object ... param) {
        String keySql = StrUtil.format((CharSequence)sql.replaceAll("\\?", "{}"), (Object[])param);
        String key = keySql.replaceAll("\\s", "").replaceAll("(select|from|,|where)", "");
        try {
            if (this.timedCache.containsKey((Object)key)) {
                return JSONArray.parseArray((String)((String)this.timedCache.get((Object)key)), clazz);
            }
            log.debug("EasyJoin\u67e5\u8be2, sql: {} , param: {}", (Object)sql, (Object)param);
            List query = Collections.emptyList();
            query = Map.class.isAssignableFrom(clazz) ? this.dbContext.sql(sql, param).getMapList() : this.dbContext.sql(sql, param).getList(clazz);
            this.timedCache.put((Object)key, (Object)JSONObject.toJSONString((Object)query, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            return query;
        }
        catch (SQLException e) {
            log.error("EasyJoin\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\uff1a{} sql: {}", (Object)e.getMessage(), (Object)sql);
            throw new JoinAnnoException("EasyJoin\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\uff1a" + e.getMessage() + "sql: " + sql, new Object[0]);
        }
    }

    private String ano2sql(JoinParam joinParam, int batchSize) {
        if (StrUtil.isNotBlank((CharSequence)joinParam.getSql())) {
            if (batchSize > 1) {
                String regex = "=\\s*#\\{uniqueKey\\}";
                String repeatAndJoin = "in (" + StrUtil.repeatAndJoin((CharSequence)"?", (int)batchSize, (CharSequence)",") + " )";
                joinParam.setSql(joinParam.getSql().replaceAll(regex, repeatAndJoin));
                return joinParam.getSql();
            }
            return joinParam.getSql().replace("#{uniqueKey}", "?");
        }
        StringBuilder sql = new StringBuilder("select ");
        String[] field = joinParam.getField();
        if (field == null || field.length == 0) {
            sql.append("*");
        } else {
            for (String s : field) {
                if (s.equals(joinParam.getUniqueKey())) continue;
                sql.append(s).append(",");
            }
            sql.append(joinParam.getUniqueKey());
        }
        StringBuilder inSql = new StringBuilder();
        if (batchSize > 1) {
            inSql.append(" in (");
            for (int i = 0; i < batchSize; ++i) {
                inSql.append("?").append(",");
            }
            inSql.deleteCharAt(inSql.length() - 1);
            inSql.append(") ");
        } else {
            inSql.append(" = ? ");
        }
        sql.append(" from ").append(joinParam.getTableName()).append(" where ").append(joinParam.getUniqueKey()).append((CharSequence)inSql);
        if (StrUtil.isNotBlank((CharSequence)joinParam.getExtraWhere())) {
            sql.append(" and ").append(joinParam.getExtraWhere());
        }
        return sql.toString();
    }

    private <T, R> R childQueryOne(JoinParam<T, R> joinParam, T entity) {
        String valueKey = joinParam.getValueKey();
        Object param = ReflectUtil.getFieldValue(entity, (String)valueKey);
        String sql = this.ano2sql(joinParam, 1);
        return this.getOne(sql, joinParam.getTargetClass(), param);
    }

    private <T, R> List<R> childQueryList(JoinParam<T, R> joinParam, T entity) {
        String valueKey = joinParam.getValueKey();
        Object param = ReflectUtil.getFieldValue(entity, (String)valueKey);
        String sql = this.ano2sql(joinParam, 1);
        return this.getList(sql, joinParam.getTargetClass(), param);
    }

    private <T, R> List<R> childQueryList(JoinParam<T, R> joinParam, List<T> entity) {
        String valueKey = joinParam.getValueKey();
        Object[] params = entity.stream().map(e -> ReflectUtil.getFieldValue((Object)e, (String)valueKey)).distinct().toArray();
        String sql = this.ano2sql(joinParam, params.length);
        return this.getList(sql, joinParam.getTargetClass(), params);
    }

    private <T> void variableInject(Object entity, Map<String, Object> variableMap, JoinParam joinParam) {
        Map<Object, Object> resMap = JoinParam.getJoinResMap(entity);
        if (joinParam.getFlat().booleanValue()) {
            for (Object value : variableMap.values()) {
                if (value instanceof Map) {
                    Map mapValue = (Map)value;
                    resMap.putAll(mapValue);
                    continue;
                }
                throw new JoinAnnoException("EasyJoin\u6241\u5e73\u5316\u6ce8\u5165\u5931\u8d25\uff0c\u6241\u5e73\u5316\u6ce8\u5165\u7684@EasyJoin\u65e0\u9700\u586b\u5199targetClass\u53c2\u6570\u3002", new Object[0]);
            }
        } else {
            variableMap.forEach((k, v) -> {
                if (!(v instanceof Map) && joinParam.getContinueJoin().booleanValue()) {
                    ((JoinService)SpringUtil.getBean(JoinService.class)).join(v, (int)joinParam.getContinueJoinMode());
                }
            });
            resMap.putAll(variableMap);
        }
    }

    @Override
    public <T, R> T joinOne(JoinParam<T, R> joinParam, T entity) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u3010joinOne\u3011\u5f00\u59cb\u6570\u636e\u5e93\u67e5\u8be2\u5b57\u5178\u503c");
        R queryOne = this.childQueryOne(joinParam, entity);
        stopWatch.stop();
        stopWatch.start("\u3010joinOne\u3011\u5f00\u59cb\u6ce8\u5165\u5b57\u5178\u503c");
        String sourceName = joinParam.getSourceName();
        this.variableInject(entity, MapUtil.of((Object)sourceName, queryOne), joinParam);
        stopWatch.stop();
        log.debug(stopWatch.prettyPrint(TimeUnit.MILLISECONDS));
        return entity;
    }

    @Override
    public <T, R> T joinList(JoinParam<T, R> joinParam, T entity) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u3010joinList\u3011\u5f00\u59cb\u6570\u636e\u5e93\u67e5\u8be2\u5b57\u5178\u503c");
        List<R> queryList = this.childQueryList(joinParam, entity);
        stopWatch.stop();
        stopWatch.start("\u3010joinList\u3011\u5f00\u59cb\u6ce8\u5165\u5b57\u5178\u503c");
        String sourceName = joinParam.getSourceName();
        this.variableInject(entity, MapUtil.of((Object)sourceName, queryList), joinParam);
        stopWatch.stop();
        log.debug(stopWatch.prettyPrint(TimeUnit.MILLISECONDS));
        return entity;
    }

    @Override
    public <T, R> List<T> batchJoinOne(JoinParam<T, R> joinParam, List<T> entitys) {
        return this.batchJoin(joinParam, entitys, e -> e.size() > 0 ? e.get(0) : null);
    }

    @Override
    public <T, R> List<T> batchJoinList(JoinParam<T, R> joinParam, List<T> entityList) {
        return this.batchJoin(joinParam, entityList, e -> e);
    }

    private <T, R> List<T> batchJoin(JoinParam<T, R> joinParam, List<T> entitys, Function<List<R>, Object> function) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u3010batchJoin\u3011\u5f00\u59cb\u6570\u636e\u5e93\u67e5\u8be2\u5b57\u5178\u503c");
        List<R> queryOne = this.childQueryList(joinParam, entitys);
        Map<Object, List<Object>> listMap = queryOne.stream().collect(Collectors.groupingBy(e -> {
            if (e instanceof Map) {
                Map map = (Map)e;
                return map.get(joinParam.getUniqueKey());
            }
            return ReflectUtil.getFieldValue((Object)e, (String)joinParam.getUniqueKey());
        }));
        stopWatch.stop();
        stopWatch.start("\u3010batchJoin\u3011\u5f00\u59cb\u6ce8\u5165\u5b57\u5178\u503c");
        String sourceName = joinParam.getSourceName();
        listMap.forEach((k, vList) -> entitys.stream().filter(e -> k.equals(ReflectUtil.getFieldValue((Object)e, (String)joinParam.getValueKey()))).forEach(e -> this.variableInject(e, MapUtil.of((Object)sourceName, function.apply((List)vList)), joinParam)));
        stopWatch.stop();
        log.debug(stopWatch.prettyPrint(TimeUnit.MILLISECONDS));
        return entitys;
    }
}

