/*
 * Decompiled with CFR 0.152.
 */
package site.sorghum.join.operator.impl;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import site.sorghum.join.aop.EasyJoin;
import site.sorghum.join.aop.EasyJoins;
import site.sorghum.join.entity.JoinParam;
import site.sorghum.join.operator.JoinOperator;
import site.sorghum.join.operator.JoinService;
import site.sorghum.join.util.BaseTypeUtil;

@Service
public class JoinServiceImpl
implements JoinService {
    JoinOperator joinOperator;

    @Autowired
    public void setJoinOperator(JoinOperator joinOperator) {
        this.joinOperator = joinOperator;
    }

    @Override
    public <T> List<T> join(List<?> paramList, int mode) {
        return (List)this.batchAutoJoinAfter(paramList, mode);
    }

    @Override
    public <T> T join(Object param, int mode) {
        return (T)this.autoJoinAfter(param, mode);
    }

    @Override
    public <T> List<T> join(List<?> paramList) {
        return this.join(paramList, 0);
    }

    @Override
    public <T> T join(Object param) {
        return this.join(param, 0);
    }

    private Object autoJoinAfter(Object result, int mode) {
        Field[] fields;
        if (result instanceof Collection) {
            List list = (List)result;
            this.batchAutoJoinAfter(list, mode);
            return result;
        }
        for (Field field : fields = ReflectUtil.getFields(result.getClass())) {
            if (!AnnotationUtil.hasAnnotation((AnnotatedElement)field, EasyJoins.class) && !AnnotationUtil.hasAnnotation((AnnotatedElement)field, EasyJoin.class)) continue;
            Class<?> type = field.getType();
            Object fieldValue = ReflectUtil.getFieldValue((Object)result, (Field)field);
            if (ClassUtil.isAssignable(Collection.class, type)) {
                List list = (List)fieldValue;
                this.batchAutoJoinAfter(list, mode);
                continue;
            }
            if (BaseTypeUtil.isBaseDataType(type)) {
                EasyJoins easyJoins = (EasyJoins)AnnotationUtil.getAnnotation((AnnotatedElement)field, EasyJoins.class);
                EasyJoin[] annotations = easyJoins != null ? easyJoins.value() : new EasyJoin[]{(EasyJoin)AnnotationUtil.getAnnotation((AnnotatedElement)field, EasyJoin.class)};
                EasyJoin annotation = null;
                for (EasyJoin easyJoin : annotations) {
                    if (easyJoin.mode() != mode) continue;
                    annotation = easyJoin;
                    break;
                }
                if (annotation == null) {
                    annotation = annotations[0];
                }
                if (annotation.isList()) {
                    this.joinOperator.joinList(JoinParam.easyJoin2JoinParam(annotation, field.getName()), result);
                    continue;
                }
                this.joinOperator.joinOne(JoinParam.easyJoin2JoinParam(annotation, field.getName()), result);
                continue;
            }
            if (!ClassUtil.isAssignable(Object.class, type)) continue;
            this.autoJoinAfter(fieldValue, mode);
        }
        return result;
    }

    private Object batchAutoJoinAfter(Collection<?> results, int mode) {
        Field[] fields;
        if (results == null || results.size() == 0) {
            return results;
        }
        Object next = results.iterator().next();
        JoinParam.getJoinResMap(next);
        List resultList = (List)results;
        for (Field field : fields = ReflectUtil.getFields(next.getClass())) {
            if (!AnnotationUtil.hasAnnotation((AnnotatedElement)field, EasyJoins.class) && !AnnotationUtil.hasAnnotation((AnnotatedElement)field, EasyJoin.class)) continue;
            Class<?> type = field.getType();
            if (ClassUtil.isAssignable(Collection.class, type)) {
                this.batchAutoJoinAfter((Collection)ReflectUtil.getFieldValue(next, (Field)field), mode);
            }
            if (BaseTypeUtil.isBaseDataType(type)) {
                EasyJoins easyJoins = (EasyJoins)AnnotationUtil.getAnnotation((AnnotatedElement)field, EasyJoins.class);
                EasyJoin[] annotations = easyJoins != null ? easyJoins.value() : new EasyJoin[]{(EasyJoin)AnnotationUtil.getAnnotation((AnnotatedElement)field, EasyJoin.class)};
                EasyJoin annotation = null;
                for (EasyJoin easyJoin : annotations) {
                    if (easyJoin.mode() != mode) continue;
                    annotation = easyJoin;
                    break;
                }
                if (annotation == null) {
                    annotation = annotations[0];
                }
                if (annotation.isList()) {
                    this.joinOperator.batchJoinList(JoinParam.easyJoin2JoinParam(annotation, field.getName()), resultList);
                } else {
                    this.joinOperator.batchJoinOne(JoinParam.easyJoin2JoinParam(annotation, field.getName()), resultList);
                }
            }
            if (!ClassUtil.isAssignable(Object.class, type)) continue;
            this.autoJoinAfter(ReflectUtil.getFieldValue(next, (Field)field), mode);
        }
        return results;
    }
}

