package com.yim.manager

import com.yim.core._YIMCore
import com.yim.model.YIMConversation
import com.yim.model.YIMEnum_ConversationType
import com.yim.model._YIMEnum_ConversatypeUnRead
import com.yim.model._YIMSDK
import com.yim.utils._YIMTable_Conversation
import com.yim.utils._YIMTable_Conversation_
import com.yim.utils._YIMTable_Message
import com.yim.utils._YIMTable_Message_

class YIMConversationManager private constructor() {
    init {
        if (_YIMSDK.option == null || _YIMSDK.context == null) _YIMSDK.utils.yimLog("${javaClass.simpleName}:Please init First!")
    }

    companion object {
        internal val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) { YIMConversationManager() }
    }

    fun queryRecentConversation(
        callback: (conversations: List<YIMConversation>?) -> (Unit),
    ) {
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                callback.invoke(null)
            }
            return
        }
        val results = _YIMSDK.db.query<_YIMTable_Conversation>(
            order = _YIMTable_Conversation_._time,
            asc = false,
            limit = 100,
        )
        if (results == null) {
            _YIMSDK.utils.runOnUIThread {
                callback.invoke(null)
            }
            return
        }
        _YIMSDK.utils.runOnUIThread {
            callback.invoke(results.map { YIMConversation(it) })
        }
    }

    fun clearUnreadCount(
        conversationType: YIMEnum_ConversationType,
        conversationID: String,
        deleteServer: Boolean = true,
        callback: ((isSuccess: Boolean) -> Unit)? = null,
    ) {
        fun clearUnreadCount_local() {
            val isSuccess_update = _YIMSDK.db.update<_YIMTable_Conversation>(
                queryCondition = when (conversationType) {
                    YIMEnum_ConversationType.P2P -> {
                        ((_YIMTable_Conversation_._from.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._to.equal(conversationID))).or(_YIMTable_Conversation_._to.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._from.equal(conversationID)))).and(_YIMTable_Conversation_._conversationType.equal(conversationType.rawValue))
                    }

                    YIMEnum_ConversationType.Team -> {
                        _YIMTable_Conversation_._to.equal(conversationID).and(_YIMTable_Conversation_._conversationType.equal(conversationType.rawValue))
                    }

                    else -> _YIMTable_Conversation_.t_id.isNull
                },
                onQueryFinish = {
                    it?.firstOrNull()?.unRead = 0
                    return@update it
                },
            )
            if (!isSuccess_update) {
                _YIMSDK.utils.runOnUIThread {
                    callback?.invoke(false)
                }
                return
            }
            _YIMSDK.utils.runOnUIThread {
                _YIMCore.listenerManager.callback_recentConversation?.invoke()
            }
            _YIMSDK.utils.runOnUIThread {
                callback?.invoke(true)
            }
        }
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                callback?.invoke(false)
            }
            return
        }
        if (deleteServer) _YIMSDK.server.emit(
            "clearUnreadCount", mapOf(
                "conversationID" to conversationID,
                "conversationType" to conversationType.rawValue,
            )
        ) { isSuccess, results, code, msg ->
            if (!isSuccess) {
                _YIMSDK.utils.runOnUIThread {
                    callback?.invoke(false)
                }
                return@emit
            }
            clearUnreadCount_local()
        }
        else clearUnreadCount_local()
    }

    fun clearAllUnreadCount(
        deleteServer: Boolean = true,
        callback: ((isSuccess: Boolean) -> Unit)? = null,
    ) {
        fun clearAllUnreadCount_local() {
            val isSuccess_update = _YIMSDK.db.update<_YIMTable_Conversation>(
                onQueryFinish = {
                    it?.forEach { it.unRead = 0 }
                    return@update it
                },
            )
            if (!isSuccess_update) {
                _YIMSDK.utils.runOnUIThread {
                    callback?.invoke(false)
                }
                return
            }
            _YIMSDK.utils.runOnUIThread {
                _YIMCore.listenerManager.callback_recentConversation?.invoke()
            }
            _YIMSDK.utils.runOnUIThread {
                callback?.invoke(true)
            }
        }
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                callback?.invoke(false)
            }
            return
        }
        if (deleteServer) _YIMSDK.server.emit("clearAllUnreadCount") { isSuccess, results, code, msg ->
            if (!isSuccess) {
                _YIMSDK.utils.runOnUIThread {
                    callback?.invoke(true)
                }
                return@emit
            }
            clearAllUnreadCount_local()
        }
        else clearAllUnreadCount_local()
    }

    fun delete(
        conversationType: YIMEnum_ConversationType,
        conversationID: String,
        deleteServer: Boolean = true,
        callback: ((isSuccess: Boolean) -> Unit)? = null,
    ) {
        fun delete_local() {
            val isSuccess_delete = _YIMSDK.db.delete<_YIMTable_Conversation>(
                when (conversationType) {
                    YIMEnum_ConversationType.P2P -> {
                        ((_YIMTable_Conversation_._from.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._to.equal(conversationID))).or(_YIMTable_Conversation_._to.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._from.equal(conversationID)))).and(_YIMTable_Conversation_._conversationType.equal(conversationType.rawValue))
                    }

                    YIMEnum_ConversationType.Team -> {
                        _YIMTable_Conversation_._to.equal(conversationID).and(_YIMTable_Conversation_._conversationType.equal(conversationType.rawValue))
                    }

                    else -> _YIMTable_Conversation_.t_id.isNull
                }
            )
            if (!isSuccess_delete) {
                _YIMSDK.utils.runOnUIThread {
                    callback?.invoke(false)
                }
                return
            }
            _YIMSDK.utils.runOnUIThread {
                _YIMCore.listenerManager.callback_recentConversation?.invoke()
            }
            _YIMSDK.utils.runOnUIThread {
                callback?.invoke(true)
            }
        }
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                callback?.invoke(false)
            }
            return
        }
        if (deleteServer) _YIMSDK.server.emit(
            "deleteConversation", mapOf(
                "conversationID" to conversationID,
                "conversationType" to conversationType.rawValue,
            )
        ) { isSuccess, results, code, msg ->
            if (!isSuccess) {
                _YIMSDK.utils.runOnUIThread {
                    callback?.invoke(false)
                }
                return@emit
            }
            delete_local()
        }
        else delete_local()
    }

    internal fun _updateLastMessage(
        conversationType: YIMEnum_ConversationType,
        conversationID: String,
        unRead: _YIMEnum_ConversatypeUnRead = _YIMEnum_ConversatypeUnRead.Nothing,
    ): Boolean {
        val results = _YIMSDK.db.query<_YIMTable_Message>(
            queryCondition = when (conversationType) {
                YIMEnum_ConversationType.P2P -> {
                    ((_YIMTable_Message_.from.equal(_YIMSDK.currentUser).and(_YIMTable_Message_.to.equal(conversationID))).or(_YIMTable_Message_.to.equal(_YIMSDK.currentUser).and(_YIMTable_Message_.from.equal(conversationID)))).and(_YIMTable_Message_.conversationType.equal(conversationType.rawValue))
                }

                YIMEnum_ConversationType.Team -> {
                    _YIMTable_Message_.to.equal(conversationID).and(_YIMTable_Message_.conversationType.equal(conversationType.rawValue))
                }

                else -> null
            },
            limit = 1,
            order = _YIMTable_Message_.time,
            asc = false,
        ) ?: return false
        if (results.isEmpty()) return false
        val isSuccess_updateOrInsert = _YIMSDK.db.updateOrInsert<_YIMTable_Conversation>(
            queryCondition = when (conversationType) {
                YIMEnum_ConversationType.P2P -> {
                    ((_YIMTable_Conversation_._from.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._to.equal(conversationID))).or(_YIMTable_Conversation_._to.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._from.equal(conversationID)))).and(_YIMTable_Conversation_._conversationType.equal(conversationType.rawValue))
                }

                YIMEnum_ConversationType.Team -> {
                    _YIMTable_Conversation_._to.equal(conversationID).and(_YIMTable_Conversation_._conversationType.equal(conversationType.rawValue))
                }

                else -> _YIMTable_Conversation_.t_id.isNull
            },
            onQueryFinish = { oldData ->
                val conversation = oldData ?: _YIMTable_Conversation()
                if (results.first().from != _YIMSDK.currentUser) when (unRead) {
                    _YIMEnum_ConversatypeUnRead.Plus -> conversation.unRead++
                    _YIMEnum_ConversatypeUnRead.Minus -> conversation.unRead--
                    _YIMEnum_ConversatypeUnRead.Zero -> conversation.unRead = 0
                    else -> {}
                }
                conversation.lastMessage = results.first()
                conversation._from = conversation.lastMessage.from
                conversation._to = conversation.lastMessage.to
                conversation._time = conversation.lastMessage.time
                conversation._conversationType = conversation.lastMessage.conversationType
                return@updateOrInsert conversation
            },
        )
        if (!isSuccess_updateOrInsert) return false
        return true
    }
}
