package com.yim.manager

import com.yim.core._YIMCore
import com.yim.model.YIMEnum_EventOnline
import com.yim.model._YIMSDK

class YIMEventManager private constructor() {
    init {
        if (_YIMSDK.option == null || _YIMSDK.context == null) _YIMSDK.utils.yimLog("${javaClass.simpleName}:Please init First!")
    }

    companion object {
        internal val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) { YIMEventManager() }
    }

    fun register_online(
        user: String,
        onRegister: ((isSuccess: Boolean) -> Unit)? = null,
        onEvent: ((event: YIMEnum_EventOnline) -> Unit),
    ) {
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                onRegister?.invoke(false)
            }
            return
        }
        //todo
    }

    fun unRegister_online(
        user: String,
        onUnRegister: ((isSuccess: Boolean) -> Unit)? = null,
    ) {
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                onUnRegister?.invoke(false)
            }
            return
        }
        //todo
    }
}
