package com.yim.utils

import com.alibaba.fastjson.annotation.JSONField
import com.google.gson.Gson
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import com.google.gson.JsonSerializationContext
import com.google.gson.JsonSerializer
import com.google.gson.annotations.Expose
import com.google.gson.annotations.JsonAdapter
import com.yim.core._YIMCore
import com.yim.model.YIMAttachment
import com.yim.model.YIMConversation
import com.yim.model.YIMEnum_ConversationType
import com.yim.model.YIMEnum_MessageState
import com.yim.model.YIMEnum_MessageType
import com.yim.model.YIMMessage
import com.yim.model._YIMSDK
import io.objectbox.Box
import io.objectbox.Property
import io.objectbox.annotation.BaseEntity
import io.objectbox.annotation.Convert
import io.objectbox.annotation.Entity
import io.objectbox.annotation.Id
import io.objectbox.annotation.Index
import io.objectbox.converter.PropertyConverter
import io.objectbox.query.QueryBuilder
import io.objectbox.query.QueryCondition
import java.io.File
import java.lang.reflect.Type
import java.util.Locale
import java.util.concurrent.ConcurrentHashMap

internal class _YIMDB {
    private val databaseClients = ConcurrentHashMap<String, Any>()

    @Synchronized
    private inline fun <reified T : _YIMTable> getDatabaseClient(): Box<T>? {
        if (_YIMSDK.option == null || _YIMSDK.context == null) {
            _YIMSDK.utils.yimLog("DB: Please init First!")
            return null
        }
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.yimLog("DB: Please login first!")
            return null
        }
        val dbName = T::class.java.simpleName.lowercase()
        if (!databaseClients.containsKey(dbName)) {
            val folderPath = File("${_YIMSDK.context!!.getFileStreamPath("yim")}/${_YIMSDK.option!!.appKey}/${_YIMSDK.currentUser}")
            if (!folderPath.exists()) folderPath.mkdirs()
            val dbFile = File("${folderPath.absolutePath}/${dbName}")
            val store = MyObjectBox.builder().directory(dbFile).build()
            try {
                if (_YIMSDK.config.debug) _YIMSDK.utils.yimLog("DebugObjectBrowserUrl:${store.startObjectBrowser(8080)}")
            } catch (e: Exception) {
            }
            databaseClients[dbName] = store.boxFor(T::class.java)
        }
        return databaseClients[dbName] as? Box<T>
    }

    inline fun <reified T : _YIMTable> count(queryCondition: QueryCondition<T>? = null): Long? {
        try {
            val databaseClient = getDatabaseClient<T>() ?: return null
            val query =
                if (queryCondition == null) databaseClient.query()
                else databaseClient.query(queryCondition)
            val build = query?.build()
            val count = build?.count()
            build?.close()
            return count
        } catch (e: Exception) {
            _YIMSDK.utils.yimLog("DB_c: ${e.localizedMessage}")
            return null
        }
    }

    inline fun <reified T : _YIMTable> query(queryCondition: QueryCondition<T>? = null, order: Property<T>? = null, asc: Boolean = true, offset: Long = 0, limit: Int = 0): List<T>? {
        try {
            val databaseClient = getDatabaseClient<T>() ?: return null
            var query: QueryBuilder<T>? = if (queryCondition == null) databaseClient.query()
            else databaseClient.query(queryCondition)
            if (order != null) query = if (asc) query?.order(order)
            else query?.orderDesc(order)
            val build = query?.build()
            val results = build?.find(offset, limit.toLong())
            build?.close()
            return results
        } catch (e: Exception) {
            _YIMSDK.utils.yimLog("DB_q: ${e.localizedMessage}")
            return null
        }
    }

    inline fun <reified T : _YIMTable> insert(data: T? = null, datas: List<T>? = null): Boolean {
        try {
            if (data == null && datas.isNullOrEmpty()) {
                _YIMSDK.utils.yimLog("DB_i: No Data")
                return false
            }
            val databaseClient = getDatabaseClient<T>() ?: return false
            return if (data != null) {
                databaseClient.put(data) > 0
            } else {
                databaseClient.put(datas)
                true
            }
        } catch (e: Exception) {
            _YIMSDK.utils.yimLog("DB_i: ${e.localizedMessage}")
            return false
        }
    }

    inline fun <reified T : _YIMTable> update(queryCondition: QueryCondition<T>? = null, onQueryFinish: (List<T>?) -> (List<T>?)): Boolean {
        try {
            val databaseClient = getDatabaseClient<T>() ?: return false
            val results = query(queryCondition) ?: return false
            onQueryFinish(results)?.forEachIndexed { i, item ->
                item.t_id = results[i].t_id
                databaseClient.put(item)
            }
            return true
        } catch (e: Exception) {
            _YIMSDK.utils.yimLog("DB_u: ${e.localizedMessage}")
            return false
        }
    }

    inline fun <reified T : _YIMTable> delete(queryCondition: QueryCondition<T>? = null, order: Property<T>? = null, asc: Boolean = true, offset: Long = 0, limit: Int = 0): Boolean {
        try {
            val databaseClient = getDatabaseClient<T>() ?: return false
            val results = query(queryCondition, order, asc, offset, limit)
            databaseClient.remove(results)
            return true
        } catch (e: Exception) {
            _YIMSDK.utils.yimLog("DB_d: ${e.localizedMessage}")
            return false
        }
    }

    inline fun <reified T : _YIMTable> updateOrInsert(queryCondition: QueryCondition<T>, onQueryFinish: (T?) -> (T)): Boolean {
        try {
            val results = query(queryCondition) ?: return false
            if (results.isEmpty()) {
                insert(onQueryFinish(null))
            } else {
                update(queryCondition) {
                    return@update listOf(onQueryFinish(results.first()))
                }
            }
            return true
        } catch (e: Exception) {
            _YIMSDK.utils.yimLog("DB_uoi: ${e.localizedMessage}")
            return false
        }
    }

    fun dispose() {
        databaseClients.forEach { (it.value as Box<*>).store.close() }
        databaseClients.clear()
    }
}

@BaseEntity
internal open class _YIMTable {
    @Id
    @JSONField(serialize = false, deserialize = false)
    @Expose(serialize = false, deserialize = false)
    var t_id: Long = 0
}

@Entity
internal class _YIMTable_Message() : _YIMTable() {
    internal constructor(message: YIMMessage) : this() {
        this.id = message.id
        this.content = message.content
        this.from = message.from
        this.to = message.to
        this.conversationType = message.conversationType
        this.messageType = message.messageType
        this.messageState = message.messageState
        this.time = message.time
        this.localExt = message.localExt
        this.isRevoke = message.isRevoke
        this.attachment = message.attachment
    }

    @Index
    var id: String = ""
    var content: String? = null
    var from: String = ""
    var to: String = ""

    @Convert(converter = YIMEnum_ConversationType_Converter::class, dbType = String::class)
    var conversationType: YIMEnum_ConversationType = YIMEnum_ConversationType.UnKnown

    @Convert(converter = YIMEnum_MessageType_Converter::class, dbType = String::class)
    var messageType: YIMEnum_MessageType = YIMEnum_MessageType.UnKnown

    @Convert(converter = YIMEnum_MessageState_Converter::class, dbType = String::class)
    var messageState: YIMEnum_MessageState = YIMEnum_MessageState.UnKnown
    var time: Long = 0

    @Convert(converter = YIMEnum_LocalExt_Converter::class, dbType = String::class)
    var localExt: Map<String, Any>? = null

    @JsonAdapter(value = IsRevokeJsonAdapter::class)
    var isRevoke: Boolean = false

    @Convert(converter = YIMAttachment_Converter::class, dbType = String::class)
    var attachment: YIMAttachment? = null

    internal class IsRevokeJsonAdapter : JsonDeserializer<Boolean>, JsonSerializer<Boolean> {
        override fun deserialize(json: JsonElement, typeOfT: Type?, context: JsonDeserializationContext?): Boolean {
            val jsonPrimitive = json.asJsonPrimitive
            return if (jsonPrimitive.isBoolean) {
                jsonPrimitive.asBoolean
            } else if (jsonPrimitive.isNumber) {
                jsonPrimitive.asNumber.toInt() == 1
            } else if (jsonPrimitive.isString) {
                listOf("true", "1", "yes").contains(jsonPrimitive.asString.lowercase(Locale.getDefault()))
            } else false
        }

        override fun serialize(src: Boolean, typeOfSrc: Type?, context: JsonSerializationContext?): JsonElement {
            return JsonPrimitive(if (src) "1" else "0")
        }
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is _YIMTable_Message) return false
        if (id != other.id) return false
        return true
    }

    override fun hashCode() = id.hashCode()

    internal class YIMEnum_ConversationType_Converter : PropertyConverter<YIMEnum_ConversationType?, String?> {
        override fun convertToEntityProperty(databaseValue: String?) = if (databaseValue == null) YIMEnum_ConversationType.UnKnown else YIMEnum_ConversationType.values().first { it.rawValue == databaseValue }
        override fun convertToDatabaseValue(entityProperty: YIMEnum_ConversationType?) = entityProperty?.rawValue
    }

    internal class YIMAttachment_Converter : PropertyConverter<YIMAttachment?, String?> {
        override fun convertToEntityProperty(databaseValue: String?) = if (databaseValue == null) null else Gson().fromJson(databaseValue, YIMAttachment::class.java)
        override fun convertToDatabaseValue(entityProperty: YIMAttachment?) = if (entityProperty == null) null else _YIMSDK.utils.toJson(entityProperty)
    }

    internal class YIMEnum_MessageType_Converter : PropertyConverter<YIMEnum_MessageType?, String?> {
        override fun convertToEntityProperty(databaseValue: String?) = if (databaseValue == null) YIMEnum_MessageType.UnKnown else YIMEnum_MessageType.values().first { it.rawValue == databaseValue }
        override fun convertToDatabaseValue(entityProperty: YIMEnum_MessageType?) = entityProperty?.rawValue
    }

    internal class YIMEnum_MessageState_Converter : PropertyConverter<YIMEnum_MessageState?, String?> {
        override fun convertToEntityProperty(databaseValue: String?) = if (databaseValue == null) YIMEnum_MessageState.UnKnown else YIMEnum_MessageState.values().first { it.rawValue == databaseValue }
        override fun convertToDatabaseValue(entityProperty: YIMEnum_MessageState?) = entityProperty?.rawValue
    }

    internal class YIMEnum_LocalExt_Converter : PropertyConverter<Map<*, *>?, String?> {
        override fun convertToEntityProperty(databaseValue: String?): Map<*, *>? = if (databaseValue == null) null else Gson().fromJson(databaseValue, Map::class.java)
        override fun convertToDatabaseValue(entityProperty: Map<*, *>?) = if (entityProperty == null) null else _YIMSDK.utils.toJson(entityProperty)
    }
}

@Entity
internal class _YIMTable_Conversation : _YIMTable {
    internal constructor()

    internal constructor(conversation: YIMConversation) {
        this.lastMessage = _YIMTable_Message(conversation.lastMessage)
        this.unRead = conversation.unRead
    }

    @Convert(converter = YIMMessage_Converter::class, dbType = String::class)
    lateinit var lastMessage: _YIMTable_Message
    var unRead: Int = 0

    //子类型字段查询使用
    var _from: String = ""
    var _to: String = ""
    var _time: Long = 0

    @Convert(converter = _YIMTable_Message.YIMEnum_ConversationType_Converter::class, dbType = String::class)
    var _conversationType: YIMEnum_ConversationType = YIMEnum_ConversationType.UnKnown

    internal class YIMMessage_Converter : PropertyConverter<_YIMTable_Message, String> {
        override fun convertToEntityProperty(databaseValue: String): _YIMTable_Message {
            return Gson().fromJson(databaseValue, _YIMTable_Message::class.java)
        }

        override fun convertToDatabaseValue(entityProperty: _YIMTable_Message): String {
            return Gson().toJson(entityProperty)
        }
    }
}