package com.yim.utils

import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.yim.core._YIMCore
import com.yim.model.YIMBroadcastMessage
import com.yim.model.YIMEnum_ConversationType
import com.yim.model.YIMEnum_LoginResult
import com.yim.model.YIMEnum_MessageState
import com.yim.model.YIMEnum_OnlineState
import com.yim.model.YIMMessage
import com.yim.model.YIMNotificationMessage
import com.yim.model.YIMResult
import com.yim.model.YIMRevokeMessage
import com.yim.model._YIMEnum_ConversatypeUnRead
import com.yim.model._YIMSDK
import io.socket.client.Ack
import io.socket.client.IO
import io.socket.client.Socket
import okhttp3.OkHttpClient
import org.json.JSONObject
import java.security.cert.X509Certificate
import java.util.Timer
import java.util.TimerTask
import java.util.concurrent.TimeUnit
import javax.net.ssl.HostnameVerifier
import javax.net.ssl.SSLSocketFactory
import javax.net.ssl.X509TrustManager


internal class _YIMServer {
    var callback_login: ((YIMResult<YIMEnum_LoginResult>) -> Unit)? = null
    var socket: Socket? = null
    var timer_checkConnect: Timer? = null
    var timer_login: Timer? = null
    var isLoginDone = false
    var currentToken: String? = null
    var isReconnecting = false
    var _lastMessageID = ""

    fun init(user: String, token: String, callback: ((YIMResult<YIMEnum_LoginResult>) -> Unit)? = null) {
        isLoginDone = false
        isReconnecting = false
        this.callback_login = callback
        _YIMSDK.currentUser = user
        currentToken = token
        dispose(false)
        connect(false)
        timer_login = Timer()
        timer_login!!.schedule(object : TimerTask() {
            override fun run() {
                onServer("loginFailed", mapOf("msg" to "time out"))
            }
        }, _YIMSDK.config.socketServerConnectTimeout)
    }

    private fun connect(isReconnect: Boolean) {
        val option = IO.Options()
//        option.transports = arrayOf(WebSocket.NAME)
        option.timeout = _YIMSDK.config.socketServerConnectTimeout
        option.reconnection = false
        option.query = "accid=${_YIMSDK.currentUser}&token=${currentToken}&appKey=${_YIMSDK.option?.appKey ?: ""}&device=android&isReconnect=${if (isReconnect) "1" else "0"}"
        val okHttpClient = OkHttpClient.Builder()
            .hostnameVerifier(HostnameVerifier { hostname, session -> return@HostnameVerifier true })
            .sslSocketFactory(SSLSocketFactory.getDefault() as SSLSocketFactory, object : X509TrustManager {
                override fun checkClientTrusted(chain: Array<out X509Certificate>?, authType: String?) {}
                override fun checkServerTrusted(chain: Array<out X509Certificate>?, authType: String?) {}
                override fun getAcceptedIssuers() = arrayOf<X509Certificate>()
            })
            .connectTimeout(_YIMSDK.config.socketServerConnectTimeout, TimeUnit.MILLISECONDS)
            .writeTimeout(_YIMSDK.config.socketServerConnectTimeout, TimeUnit.MILLISECONDS)
            .readTimeout(_YIMSDK.config.socketServerConnectTimeout, TimeUnit.MILLISECONDS)
            .build()
        IO.setDefaultOkHttpCallFactory(okHttpClient)
        IO.setDefaultOkHttpWebSocketFactory(okHttpClient)
        socket = IO.socket(_YIMSDK.config.server, option)
        socket!!.on(Socket.EVENT_CONNECT) {
            _YIMSDK.utils.yimLog("onConnect")
        }
        socket!!.on("reconnect") { _YIMSDK.utils.yimLog("onReconnect") }
        socket!!.on("connecting") { _YIMSDK.utils.yimLog("onConnecting") }
        socket!!.on("connect_timeout") { _YIMSDK.utils.yimLog("onConnectTimeout") }
        socket!!.on(Socket.EVENT_CONNECT_ERROR) {
            _YIMSDK.utils.yimLog("onConnectError")
        }
        socket!!.on(Socket.EVENT_DISCONNECT) {
            _YIMSDK.utils.yimLog("onDisconnect: $it")
            _doLoginFail(it.toString())
        }
        socket!!.on("server") {
            val result = Gson().fromJson((it.first { it is JSONObject } as JSONObject).toString(), Map::class.java)
            onServer(result["event"].toString(), result["data"] as Map<String, Any>)
        }
        socket!!.connect()
    }

    fun emit(event: String, data: Map<String, Any?>? = null, ack: ((isSuccess: Boolean, results: Map<*, *>?, code: Int, msg: String) -> (Unit))? = null) {
        _YIMSDK.utils.yimLog("[emit_request]: \n\tevent: $event\n\tdata: ${_YIMSDK.utils.toJson(data ?: mapOf<String, Any?>())}")
        var isFinish = false
        try {
            if (!_YIMCore.userManager.isLogin()) {
                if (isFinish) return
                isFinish = true
                _YIMSDK.utils.yimLog("[emit_response_cancel]: \n\tevent: $event")
                try {
                    ack?.invoke(false, null, 0, "Please login first!")
                } catch (e: Exception) {
                }
                return
            }
            Timer().schedule(object : TimerTask() {
                override fun run() {
                    if (isFinish) return
                    isFinish = true
                    _YIMSDK.utils.yimLog("[emit_response_timeout]: \n\tevent: $event")
                    try {
                        ack?.invoke(false, null, 0, "[$event] time out")
                    } catch (e: Exception) {
                    }
                }
            }, _YIMSDK.config.socketServerConnectTimeout)
            socket?.emit("client", JSONObject(
                mapOf(
                    "event" to event,
                    "data" to data,
                )
            ), object : Ack {
                override fun call(vararg data: Any?) {
                    try {
                        val results = data.firstOrNull() as? JSONObject
                        if (results == null) {
                            if (isFinish) return
                            isFinish = true
                            _YIMSDK.utils.yimLog("[emit_response_null]: \n\tevent: $event")
                            try {
                                ack?.invoke(false, null, 0, "null response")
                            } catch (e: Exception) {
                            }
                            return
                        }
                        if (isFinish) return
                        isFinish = true
                        val code = results.getInt("code")
                        val isSuccess = (code == 200)
                        val msg = (results.getString("msg")) ?: ""
                        _YIMSDK.utils.yimLog("[emit_response_success]: \n\tevent: $event\n\tdata: $results")
                        results.remove("code")
                        results.remove("msg")
                        try {
                            ack?.invoke(isSuccess, _YIMSDK.utils.jsonObjectToMap(results["data"] as? JSONObject), code, msg)
                        } catch (e: Exception) {
                        }
                    } catch (e: Exception) {
                        if (isFinish) return
                        isFinish = true
                        _YIMSDK.utils.yimLog("[emit_response_exception]: \n\tevent: $event\n\terror: ${e.localizedMessage}")
                        try {
                            ack?.invoke(false, null, 0, "Exception: ${e.localizedMessage}")
                        } catch (e: Exception) {
                        }
                    }
                }
            })
        } catch (e: Exception) {
            if (isFinish) return
            isFinish = true
            _YIMSDK.utils.yimLog("[emit_request_exception]: \n\tevent: $event\n\terror: ${e.localizedMessage}")
            try {
                ack?.invoke(false, null, 0, "Exception: ${e.localizedMessage}")
            } catch (e: Exception) {
            }
        }
    }

    fun dispose(isReconnect: Boolean) {
        if (isReconnect) {
            socket?.off()
            socket?.disconnect()
            socket = null
        } else {
//            currentToken = null
            timer_checkConnect?.cancel()
            timer_checkConnect = null
            timer_login?.cancel()
            timer_login = null
            socket?.off()
            socket?.disconnect()
            socket = null
        }
    }

    fun _doLoginFail(error: String) {
        if (isLoginDone) return
        isLoginDone = true
        _YIMCore.userManager.logout()
        _YIMSDK.utils.runOnUIThread {
            callback_login?.invoke(YIMResult(YIMEnum_LoginResult.Failed, error))
        }
        _YIMSDK.utils.runOnUIThread {
            callback_login = null
        }
    }

    @Synchronized
    fun onServer(event: String, data: Map<String, Any>) {
        @Synchronized
        fun doMessage(message: YIMMessage, isNewMessage: Boolean, callback: ((isSuccess: Boolean) -> Unit)? = null) {
            if (message.id == _lastMessageID) return
            _lastMessageID = message.id
            when (message.conversationType) {
                YIMEnum_ConversationType.P2P -> {
                    val count = _YIMSDK.db.count<_YIMTable_Message>(_YIMTable_Message_.id.equal(message.id))
                    if (count == null) {
                        callback?.invoke(false)
                        return
                    }
                    if (count > 0) {
                        callback?.invoke(false)
                        return
                    }
                    val isSuccess_insert = _YIMSDK.db.insert(_YIMTable_Message(message))
                    if (!isSuccess_insert) {
                        callback?.invoke(false)
                        return
                    }
                    val isSuccess_updateLastMessage = _YIMCore.conversationManager._updateLastMessage(message.conversationType, if (message.from == _YIMSDK.currentUser) message.to else message.from, _YIMEnum_ConversatypeUnRead.Plus)
                    if (!isSuccess_updateLastMessage) {
                        callback?.invoke(false)
                        return
                    }
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_recentConversation?.invoke()
                    }
                    if (isNewMessage) _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_message?.invoke(listOf(message))
                    }
                    callback?.invoke(true)
                }

                YIMEnum_ConversationType.Team -> {
                    val count = _YIMSDK.db.count<_YIMTable_Message>(_YIMTable_Message_.id.equal(message.id))
                    if (count == null) {
                        callback?.invoke(false)
                        return
                    }
                    if (count > 0) {
                        callback?.invoke(false)
                        return
                    }
                    val isSuccess_insert = _YIMSDK.db.insert(_YIMTable_Message(message))
                    if (!isSuccess_insert) {
                        callback?.invoke(false)
                        return
                    }
                    val isSuccess_updateLastMessage = _YIMCore.conversationManager._updateLastMessage(message.conversationType, message.to, _YIMEnum_ConversatypeUnRead.Plus)
                    if (!isSuccess_updateLastMessage) {
                        callback?.invoke(false)
                        return
                    }
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_recentConversation?.invoke()
                    }
                    if (isNewMessage) _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_message?.invoke(listOf(message))
                    }
                    callback?.invoke(true)
                }

                else -> {}
            }
        }
        when (event) {
            "loginFailed" -> {
                _doLoginFail(data["msg"].toString())
            }

            "loginSuccess" -> {
                if (isLoginDone) return
                isLoginDone = true
                timer_checkConnect?.cancel()
                timer_checkConnect = null
                timer_login?.cancel()
                timer_login = null
                timer_checkConnect = Timer()
                timer_checkConnect!!.schedule(object : TimerTask() {
                    override fun run() {
                        if (!_YIMCore.userManager.isLogin(true)) {
                            if (!isReconnecting) {
                                isReconnecting = true
                                _YIMSDK.utils.runOnUIThread {
                                    _YIMCore.listenerManager.callback_status_online?.invoke(YIMResult(YIMEnum_OnlineState.Reconnecting, "Reconnecting"))
                                }
                                dispose(true)
                                Timer().schedule(object : TimerTask() {
                                    override fun run() {
                                        connect(true)
                                        Timer().schedule(object : TimerTask() {
                                            override fun run() {
                                                if (isReconnecting) {
                                                    isReconnecting = false
                                                    dispose(true)
                                                }
                                            }
                                        }, _YIMSDK.config.socketServerConnectTimeout)
                                    }
                                }, 1000)
                            }
                        } else {
                            if (isReconnecting) {
                                isReconnecting = false
                                _YIMSDK.utils.runOnUIThread {
                                    _YIMCore.listenerManager.callback_status_online?.invoke(YIMResult(YIMEnum_OnlineState.Reconnected, "Reconnected"))
                                }
                            }
                            _YIMSDK.server.emit("refreshOnline")
                        }
                    }
                }, 5000, 5000)
                //同步云端会话
                emit("queryConversations") { isSuccess, results, code, msg ->
                    if (isSuccess) {
                        val conversations_server = (results?.get("conversations") as? List<Map<String, Any>>)?.toMutableList()
                        if (conversations_server.isNullOrEmpty()) return@emit
                        _YIMCore.conversationManager.queryRecentConversation { conversations ->
                            //过滤本地已经存在的云端会话
                            conversations?.forEach { conversation ->
                                when (conversation.lastMessage.conversationType) {
                                    YIMEnum_ConversationType.P2P -> {
                                        val conversationID = if (conversation.lastMessage.from == _YIMSDK.currentUser) conversation.lastMessage.to else conversation.lastMessage.from
                                        for (i in conversations_server.size downTo 0) {
                                            if ((conversations_server[i] as JSONObject).getString("conversationID") == conversationID) conversations_server.removeAt(i)
                                        }
                                    }

                                    YIMEnum_ConversationType.Team -> {
                                        val conversationID = conversation.lastMessage.to
                                        for (i in conversations_server.size downTo 0) {
                                            if ((conversations_server[i] as JSONObject).getString("conversationID") == conversationID) conversations_server.removeAt(i)
                                        }
                                    }

                                    else -> {}
                                }
                            }
                            //将本地没有的云端会话，把消息同步下来
                            conversations_server.forEach { conversation ->
                                _YIMCore.messageManager.queryServerMessages(
                                    conversationType = YIMEnum_ConversationType.values().first { it.rawValue == conversation["conversationType"].toString() },
                                    conversationID = conversation["conversationID"].toString(),
                                    limit = _YIMSDK.config.roamMessageSize,
                                ) { isSuccess, messages ->
                                    if (isSuccess) {
                                        messages!!.forEach {
                                            doMessage(it, false) { isSuccess ->
                                                if (!isSuccess) return@doMessage
                                                val isSuccess_update = _YIMSDK.db.update<_YIMTable_Conversation>(
                                                    queryCondition = when (YIMEnum_ConversationType.values().first { it.rawValue == conversation["conversationType"].toString() }) {
                                                        YIMEnum_ConversationType.P2P -> {
                                                            (_YIMTable_Conversation_._from.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._to.equal(conversation["conversationID"].toString()))).or(_YIMTable_Conversation_._to.equal(_YIMSDK.currentUser).and(_YIMTable_Conversation_._from.equal(conversation["conversationID"].toString()))).and(_YIMTable_Conversation_._conversationType.equal(YIMEnum_ConversationType.P2P.rawValue))
                                                        }

                                                        YIMEnum_ConversationType.Team -> {
                                                            _YIMTable_Conversation_._to.equal(conversation["conversationID"].toString()).and(_YIMTable_Conversation_._conversationType.equal(YIMEnum_ConversationType.Team.rawValue))
                                                        }

                                                        else -> null
                                                    },
                                                    onQueryFinish = {
                                                        it?.firstOrNull()?.unRead = conversation["unReadCount"].toString().toInt()
                                                        return@update it
                                                    },
                                                )
                                                if (!isSuccess_update) return@doMessage
                                                _YIMSDK.utils.runOnUIThread {
                                                    _YIMCore.listenerManager.callback_recentConversation?.invoke()
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                _YIMSDK.utils.runOnUIThread {
                    callback_login?.invoke(YIMResult(YIMEnum_LoginResult.Success, "success"))
                }
                _YIMSDK.utils.runOnUIThread {
                    callback_login = null
                }
                //将历史的发送中消息，置为失败状态
                _YIMSDK.db.update<_YIMTable_Message>(queryCondition = _YIMTable_Message_.messageState.equal(YIMEnum_MessageState.Sending.rawValue), onQueryFinish = {
                    it?.forEach { it.messageState = YIMEnum_MessageState.Fail }
                    return@update it
                })
                _YIMCore.conversationManager.queryRecentConversation { conversations ->
                    if (conversations == null) return@queryRecentConversation
                    for (conversation in conversations) {
                        _YIMCore.conversationManager._updateLastMessage(conversation.lastMessage.conversationType, conversation.lastMessage.getConversationID())
                    }
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_recentConversation?.invoke()
                    }
                }
                _YIMSDK.oss.init(data["oss"] as Map<*, *>?)
                _YIMSDK.push.init(data["push"] as Map<*, *>?)
            }

            "kick" -> {
                _YIMCore.userManager.logout()
                _YIMSDK.utils.runOnUIThread {
                    _YIMCore.listenerManager.callback_status_online?.invoke(YIMResult(YIMEnum_OnlineState.Kick, "Kicked by ${data["device"]} device"))
                }
            }

            "message" -> {
                val messages = Gson().fromJson(_YIMSDK.utils.toJson(data["messages"]!!), object : TypeToken<List<_YIMTable_Message>>() {}).map { YIMMessage(it) }
                messages.forEach {
                    doMessage(it, true)
                }
            }

            "broadcast" -> {
                _YIMSDK.utils.runOnUIThread {
                    _YIMCore.listenerManager.callback_broadcast?.invoke(Gson().fromJson(_YIMSDK.utils.toJson(data["message"]!!), YIMBroadcastMessage::class.java))
                }
            }

            "notification" -> {
                _YIMSDK.utils.runOnUIThread {
                    _YIMCore.listenerManager.callback_notification?.invoke(Gson().fromJson(_YIMSDK.utils.toJson(data["message"]!!), YIMNotificationMessage::class.java))
                }
            }

            "revoke" -> {
                Gson().fromJson(_YIMSDK.utils.toJson(data["messages"]!!), object : TypeToken<List<YIMRevokeMessage>>() {}).forEach { message ->
                    val isSuccess_markConversationRevoke = _YIMCore.messageManager._markConversationRevoke(message.conversationType, message.messageID)
                    if (!isSuccess_markConversationRevoke) return
                    val isSuccess_updateLastMessage = _YIMCore.conversationManager._updateLastMessage(message.conversationType, message.conversationID)
                    if (!isSuccess_updateLastMessage) return
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_recentConversation?.invoke()
                    }
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_revoke?.invoke(message)
                    }
                }
            }

            "receipt_p2p" -> {
                (data["conversationIDs"] as List<String>).forEach { conversationID ->
                    val isSuccess_markConversationRead = _YIMCore.messageManager._markConversationRead(YIMEnum_ConversationType.P2P, conversationID, false)
                    if (!isSuccess_markConversationRead) return
                    val isSuccess_updateLastMessage = _YIMCore.conversationManager._updateLastMessage(YIMEnum_ConversationType.P2P, conversationID)
                    if (!isSuccess_updateLastMessage) return
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_recentConversation?.invoke()
                    }
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_status_msg_receipt?.invoke(conversationID)
                    }
                }
            }

            "receipt_team" -> {
                (data["conversationIDs"] as List<String>).forEach { conversationID ->
                    val isSuccess_markConversationRead = _YIMCore.messageManager._markConversationRead(YIMEnum_ConversationType.Team, conversationID, false)
                    if (!isSuccess_markConversationRead) return
                    val isSuccess_updateLastMessage = _YIMCore.conversationManager._updateLastMessage(YIMEnum_ConversationType.Team, conversationID)
                    if (!isSuccess_updateLastMessage) return
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_recentConversation?.invoke()
                    }
                    _YIMSDK.utils.runOnUIThread {
                        _YIMCore.listenerManager.callback_status_msg_receipt?.invoke(conversationID)
                    }
                }
            }
        }
    }
}
